/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.animation;

import fr.inria.zvtm.animation.AnimationManager;
import fr.inria.zvtm.animation.TimingHandler;
import net.jcip.annotations.ThreadSafe;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingSource;
import org.jdesktop.animation.timing.TimingTarget;
import org.jdesktop.animation.timing.interpolation.Interpolator;

@ThreadSafe
public class Animation {
    public static final int INFINITE = -1;
    private final AnimationManager parent;
    private final Animator animator;
    private final TimingTarget timingInterceptor;
    final TimingHandler handler;
    final Object subject;
    final Dimension dimension;

    Animation(AnimationManager parent, int duration, double repeatCount, RepeatBehavior repeatBehavior, Object subject, Dimension dimension, TimingHandler handler) {
        this.parent = parent;
        this.subject = subject;
        this.dimension = dimension;
        this.handler = handler;
        this.timingInterceptor = new TimingInterceptor();
        this.animator = new Animator(duration, repeatCount, repeatBehavior.getAnimatorValue(), this.timingInterceptor);
    }

    public void setInterpolator(Interpolator interpolator) {
        this.animator.setInterpolator(interpolator);
    }

    public void setStartFraction(float startFraction) {
        this.animator.setStartFraction(startFraction);
    }

    boolean orthogonalWith(Animation other) {
        return this.subject != other.subject || this.dimension != other.dimension;
    }

    void setTimer(TimingSource timingSource) {
        this.animator.setTimer(timingSource);
    }

    void start() {
        this.animator.start();
    }

    void stop() {
        this.animator.stop();
    }

    void cancel() {
        this.animator.cancel();
    }

    void pause() {
        this.animator.pause();
    }

    void resume() {
        this.animator.resume();
    }

    boolean isRunning() {
        return this.animator.isRunning();
    }

    void onAnimationEnded() {
        this.parent.onAnimationEnded(this);
    }

    private class TimingInterceptor
    implements TimingTarget {
        TimingInterceptor() {
        }

        public void begin() {
            Animation.this.handler.begin(Animation.this.subject, Animation.this.dimension);
        }

        public void end() {
            Animation.this.handler.end(Animation.this.subject, Animation.this.dimension);
            Animation.this.onAnimationEnded();
        }

        public void repeat() {
            Animation.this.handler.repeat(Animation.this.subject, Animation.this.dimension);
        }

        public void timingEvent(float fraction) {
            Animation.this.handler.timingEvent(fraction, Animation.this.subject, Animation.this.dimension);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RepeatBehavior {
        LOOP{

            Animator.RepeatBehavior getAnimatorValue() {
                return Animator.RepeatBehavior.LOOP;
            }
        }
        ,
        REVERSE{

            Animator.RepeatBehavior getAnimatorValue() {
                return Animator.RepeatBehavior.REVERSE;
            }
        };


        abstract Animator.RepeatBehavior getAnimatorValue();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Dimension {
        POSITION,
        ALTITUDE,
        SIZE,
        ORIENTATION,
        BORDERCOLOR,
        FILLCOLOR,
        TRANSLUCENCY,
        PATH,
        LENS_MAG,
        LENS_RADIUS,
        LENS_MAG_RADIUS;

    }
}

