/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.dialogs;

import java.util.ArrayList;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ContainerCheckedTreeViewer
extends CheckboxTreeViewer {
    public ContainerCheckedTreeViewer(Composite parent) {
        super(parent);
        this.initViewer();
    }

    public ContainerCheckedTreeViewer(Composite parent, int style) {
        super(parent, style);
        this.initViewer();
    }

    public ContainerCheckedTreeViewer(Tree tree) {
        super(tree);
        this.initViewer();
    }

    private void initViewer() {
        this.setUseHashlookup(true);
        this.addCheckStateListener(event -> this.doCheckStateChanged(event.getElement()));
        this.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
                Widget item = ContainerCheckedTreeViewer.this.findItem(event.getElement());
                if (item instanceof TreeItem) {
                    ContainerCheckedTreeViewer.this.initializeItem((TreeItem)item);
                }
            }
        });
    }

    protected void doCheckStateChanged(Object element) {
        Widget item = this.findItem(element);
        if (item instanceof TreeItem) {
            TreeItem treeItem = (TreeItem)item;
            treeItem.setGrayed(false);
            this.updateChildrenItems(treeItem);
            this.updateParentItems(treeItem.getParentItem());
        }
    }

    private void initializeItem(TreeItem item) {
        if (item.getChecked() && !item.getGrayed()) {
            this.updateChildrenItems(item);
        }
    }

    private void updateChildrenItems(TreeItem parent) {
        Item[] children = this.getChildren((Widget)parent);
        boolean state = parent.getChecked();
        Item[] itemArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Item element = itemArray[n2];
            TreeItem curr = (TreeItem)element;
            if (curr.getData() != null && (curr.getChecked() != state || curr.getGrayed())) {
                curr.setChecked(state);
                curr.setGrayed(false);
                this.updateChildrenItems(curr);
            }
            ++n2;
        }
    }

    private void updateParentItems(TreeItem item) {
        if (item != null) {
            Item[] children = this.getChildren((Widget)item);
            boolean containsChecked = false;
            boolean containsUnchecked = false;
            Item[] itemArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Item element = itemArray[n2];
                TreeItem curr = (TreeItem)element;
                containsChecked |= curr.getChecked();
                containsUnchecked |= !curr.getChecked() || curr.getGrayed();
                ++n2;
            }
            item.setChecked(containsChecked);
            item.setGrayed(containsChecked && containsUnchecked);
            this.updateParentItems(item.getParentItem());
        }
    }

    public boolean setChecked(Object element, boolean state) {
        if (super.setChecked(element, state)) {
            this.doCheckStateChanged(element);
            return true;
        }
        return false;
    }

    public void setCheckedElements(Object[] elements) {
        super.setCheckedElements(elements);
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.doCheckStateChanged(element);
            ++n2;
        }
    }

    protected void setExpanded(Item item, boolean expand) {
        super.setExpanded(item, expand);
        if (expand && item instanceof TreeItem) {
            this.initializeItem((TreeItem)item);
        }
    }

    public Object[] getCheckedElements() {
        Object[] checked = super.getCheckedElements();
        ArrayList<Object> result = new ArrayList<Object>();
        Object[] objectArray = checked;
        int n = checked.length;
        int n2 = 0;
        while (n2 < n) {
            Item[] children;
            Object curr = objectArray[n2];
            result.add(curr);
            Widget item = this.findItem(curr);
            if (item != null && (children = this.getChildren(item)).length == 1 && children[0].getData() == null) {
                this.collectChildren(curr, result);
            }
            ++n2;
        }
        return result.toArray();
    }

    private void collectChildren(Object element, ArrayList result) {
        Object[] filteredChildren;
        Object[] objectArray = filteredChildren = this.getFilteredChildren(element);
        int n = filteredChildren.length;
        int n2 = 0;
        while (n2 < n) {
            Object curr = objectArray[n2];
            result.add(curr);
            this.collectChildren(curr, result);
            ++n2;
        }
    }
}

