/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java.hover;

import java.util.HashMap;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.jdt.internal.ui.preferences.JavadocProblemsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock;
import org.eclipse.jdt.internal.ui.preferences.ProblemSeveritiesConfigurationBlock;
import org.eclipse.jdt.internal.ui.text.java.hover.JavaHoverMessages;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ConfigureProblemSeverityAction
extends Action {
    private static final String CONFIGURE_PROBLEM_SEVERITY_DIALOG_ID = "configure_problem_severity_dialog_id";
    private final IJavaProject fProject;
    private final String fOptionId;
    private final boolean fIsJavadocOption;
    private final IInformationControl fInfoControl;

    public ConfigureProblemSeverityAction(IJavaProject project, String optionId, boolean isJavadocOption, IInformationControl infoControl) {
        this.fProject = project;
        this.fOptionId = optionId;
        this.fIsJavadocOption = isJavadocOption;
        this.fInfoControl = infoControl;
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_CONFIGURE_PROBLEM_SEVERITIES);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_CONFIGURE_PROBLEM_SEVERITIES);
        this.setToolTipText(JavaHoverMessages.ProblemHover_action_configureProblemSeverity);
    }

    public void run() {
        String pageId;
        boolean showPropertyPage;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (!this.hasProjectSpecificOptions()) {
            String[] buttons;
            String message = Messages.format(JavaHoverMessages.ProblemHover_chooseSettingsTypeDialog_message, new Object[]{JavaElementLabels.getElementLabel((IJavaElement)this.fProject, JavaElementLabels.ALL_DEFAULT)});
            int result = OptionalMessageDialog.open(CONFIGURE_PROBLEM_SEVERITY_DIALOG_ID, shell, JavaHoverMessages.ProblemHover_chooseSettingsTypeDialog_title, null, message, 3, buttons = new String[]{JavaHoverMessages.ProblemHover_chooseSettingsTypeDialog_button_project, JavaHoverMessages.ProblemHover_chooseSettingsTypeDialog_button_workspace, IDialogConstants.CANCEL_LABEL}, 0, JavaHoverMessages.ProblemHover_chooseSettingsTypeDialog_checkBox_dontShowAgain);
            if (result == 1025) {
                showPropertyPage = false;
            } else {
                if (result == 2 || result == -1) {
                    return;
                }
                showPropertyPage = result == 0;
            }
        } else {
            showPropertyPage = true;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (this.fIsJavadocOption) {
            if (showPropertyPage) {
                pageId = "org.eclipse.jdt.ui.propertyPages.JavadocProblemsPreferencePage";
                data.put("use_project_specific_key", Boolean.TRUE);
            } else {
                pageId = "org.eclipse.jdt.ui.preferences.JavadocProblemsPreferencePage";
            }
            data.put("select_option_key", this.fOptionId);
            data.put("select_option_qualifier", "org.eclipse.jdt.core");
        } else {
            if (showPropertyPage) {
                pageId = "org.eclipse.jdt.ui.propertyPages.ProblemSeveritiesPreferencePage";
                data.put("use_project_specific_key", Boolean.TRUE);
            } else {
                pageId = "org.eclipse.jdt.ui.preferences.ProblemSeveritiesPreferencePage";
            }
            data.put("select_option_key", this.fOptionId);
            data.put("select_option_qualifier", "org.eclipse.jdt.core");
        }
        if (this.fInfoControl != null) {
            this.fInfoControl.dispose();
        }
        if (showPropertyPage) {
            PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)this.fProject, (String)pageId, null, data).open();
        } else {
            PreferencesUtil.createPreferenceDialogOn((Shell)shell, (String)pageId, null, data).open();
        }
    }

    private boolean hasProjectSpecificOptions() {
        OptionsConfigurationBlock.Key[] keys = this.fIsJavadocOption ? JavadocProblemsConfigurationBlock.getKeys() : ProblemSeveritiesConfigurationBlock.getKeys();
        return OptionsConfigurationBlock.hasProjectSpecificOptions(this.fProject.getProject(), keys, null);
    }
}

