/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.ASN1.Object;

import java.text.MessageFormat;
import org.eclipse.titan.designer.AST.ASN1.ASN1Object;
import org.eclipse.titan.designer.AST.ASN1.Object.ObjectClass_Definition;
import org.eclipse.titan.designer.AST.ASN1.Object.Object_Definition;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.IReferenceChainElement;
import org.eclipse.titan.designer.AST.ISetting;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceChain;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.actions.DeclarationCollector;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;

public final class ReferencedObject
extends ASN1Object
implements IReferenceChainElement {
    private static final String OBJECTEXPECTED = "Object reference expected";
    private static final String CIRCULAROBJECTREFERENCE = "Circular object reference chain: `{0}''";
    private final Reference reference;
    private ASN1Object objectReferenced;
    private Object_Definition referencedLast;

    public ReferencedObject(Reference reference) {
        this.reference = reference;
        if (null != reference) {
            reference.setFullNameParent(this);
        }
    }

    @Override
    public ReferencedObject newInstance() {
        return new ReferencedObject(this.reference.newInstance());
    }

    @Override
    public void setMyScope(Scope scope) {
        super.setMyScope(scope);
        if (null != this.reference) {
            this.reference.setMyScope(scope);
        }
    }

    @Override
    public Location getLocation() {
        if (null != this.reference && null != this.reference.getLocation()) {
            return this.reference.getLocation();
        }
        return this.location;
    }

    @Override
    public String chainedDescription() {
        return "object reference: " + this.reference;
    }

    @Override
    public Location getChainLocation() {
        return this.getLocation();
    }

    public ASN1Object getRefd(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        ISetting setting;
        Assignment assignment;
        if (referenceChain.add(this) && null != (assignment = this.reference.getRefdAssignment(timestamp, true, referenceChain)) && null != (setting = this.reference.getRefdSetting(timestamp)) && !ISetting.Setting_type.S_ERROR.equals((Object)setting.getSettingtype())) {
            if (ISetting.Setting_type.S_O.equals((Object)setting.getSettingtype())) {
                this.objectReferenced = (ASN1Object)setting;
                return this.objectReferenced;
            }
            this.location.reportSemanticError(OBJECTEXPECTED);
        }
        this.objectReferenced = new Object_Definition(null);
        this.objectReferenced.setMyGovernor(this.myGovernor);
        return this.objectReferenced;
    }

    public Object_Definition getRefdLast(CompilationTimeStamp timestamp) {
        ReferenceChain referenceChain = ReferenceChain.getInstance(CIRCULAROBJECTREFERENCE, true);
        ASN1Object object = this;
        while (object instanceof ReferencedObject && !object.getIsErroneous(timestamp)) {
            object = object.getRefd(timestamp, referenceChain);
        }
        referenceChain.release();
        return (Object_Definition)object;
    }

    @Override
    public void check(CompilationTimeStamp timestamp) {
        ObjectClass_Definition refdClass;
        if (null != this.lastTimeChecked && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        this.lastTimeChecked = timestamp;
        if (null == this.myGovernor) {
            return;
        }
        ObjectClass_Definition myClass = this.myGovernor.getRefdLast(timestamp, null);
        if (myClass != (refdClass = this.getRefdLast(timestamp, null).getMyGovernor().getRefdLast(timestamp, null))) {
            this.location.reportSemanticError(MessageFormat.format("ObjectClass mismatch: ObjectSet of class `{0}'' was expected instead of `{1}''", myClass.getFullName(), refdClass.getFullName()));
            this.objectReferenced = new Object_Definition(null);
            this.objectReferenced.setIsErroneous(true);
            this.objectReferenced.setMyGovernor(this.myGovernor);
        }
    }

    @Override
    public Object_Definition getRefdLast(CompilationTimeStamp timestamp, IReferenceChain referenceChain) {
        boolean newChain = null == referenceChain;
        IReferenceChain temporalReferenceChain = newChain ? ReferenceChain.getInstance("Circular reference chain: `{0}''", true) : referenceChain;
        this.referencedLast = this.getRefd(timestamp, temporalReferenceChain).getRefdLast(timestamp, temporalReferenceChain);
        if (newChain) {
            temporalReferenceChain.release();
        }
        return this.referencedLast;
    }

    @Override
    public void addProposal(ProposalCollector propCollector, int i) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        if (null != this.referencedLast) {
            this.referencedLast.addProposal(propCollector, i);
        }
    }

    @Override
    public void addDeclaration(DeclarationCollector declarationCollector, int i) {
        if (null == this.lastTimeChecked) {
            this.check(CompilationTimeStamp.getBaseTimestamp());
        }
        if (null != this.referencedLast) {
            this.referencedLast.addDeclaration(declarationCollector, i);
        }
    }

    @Override
    protected boolean memberAccept(ASTVisitor v) {
        return this.reference == null || this.reference.accept(v);
    }
}

