/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST;

import java.util.HashMap;
import java.util.Map;
import org.antlr.v4.runtime.Token;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.designer.AST.MarkerHandler;

public class Location {
    private IResource file;
    private int line;
    private int offset;
    private int endOffset;

    protected Location() {
        this.file = null;
        this.line = -1;
        this.offset = -1;
        this.endOffset = -1;
    }

    public Location(Location location) {
        this.setLocation(location);
    }

    public Location(IResource file) {
        this.file = file;
        this.line = -1;
        this.offset = -1;
        this.endOffset = -1;
    }

    public Location(IResource file, int line) {
        this.file = file;
        this.line = line;
        this.offset = -1;
        this.endOffset = -1;
    }

    public Location(IResource file, int line, int offset, int endOffset) {
        this.setLocation(file, line, offset, endOffset);
    }

    public Location(IResource aFile, Token aStartToken, Token aEndToken) {
        this.setLocation(aFile, aStartToken.getLine(), aStartToken.getStartIndex(), aEndToken.getStopIndex() + 1);
    }

    public Location(IResource aFile, Token aToken) {
        this(aFile, aToken, aToken);
    }

    public Location(Location aBaseLocation, Token aEndToken) {
        this(aBaseLocation);
        this.setEndOffset(aEndToken);
    }

    public final void setOffset(Token aToken) {
        this.setOffset(aToken.getStartIndex());
    }

    public final void setEndOffset(Token aEndToken) {
        this.setEndOffset(aEndToken.getStopIndex() + 1);
    }

    public static Location interval(Location startLoc, Location endLoc) {
        return new Location(startLoc.getFile(), startLoc.getLine(), startLoc.getOffset(), endLoc.getEndOffset());
    }

    protected final void setLocation(Location location) {
        this.file = location.getFile();
        this.line = location.getLine();
        this.offset = location.getOffset();
        this.endOffset = location.getEndOffset();
    }

    protected final void setLocation(IResource file, int line, int offset, int endOffset) {
        this.file = file;
        this.line = line;
        this.offset = offset;
        this.endOffset = endOffset;
    }

    public final IResource getFile() {
        return this.file;
    }

    public final int getLine() {
        return this.line;
    }

    public final void setLine(int line) {
        this.line = line;
    }

    public final int getOffset() {
        return this.offset;
    }

    public final void setOffset(int offset) {
        this.offset = offset;
    }

    public final int getEndOffset() {
        return this.endOffset;
    }

    public final void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Location) {
            Location other = (Location)object;
            return this.line == other.line && this.offset == other.offset && this.endOffset == other.endOffset && this.file.equals((Object)other.file);
        }
        return false;
    }

    public final boolean isBefore(Location other) {
        return this.offset < other.getOffset();
    }

    public final boolean containsOffset(int offset) {
        return this.offset <= offset && this.endOffset >= offset;
    }

    public void reportSyntacticError(String reason) {
        this.reportProblem(reason, 2, "org.eclipse.titan.designer.ontheflySyntacticMarker");
    }

    public void reportSyntacticWarning(String reason) {
        this.reportProblem(reason, 1, "org.eclipse.titan.designer.ontheflySyntacticMarker");
    }

    public void reportConfigurableSemanticProblem(String option, String reason) {
        if ("warning".equals(option)) {
            this.reportSemanticWarning(reason);
        } else if ("error".equals(option)) {
            this.reportSemanticError(reason);
        }
    }

    public void reportSemanticError(String reason) {
        this.reportProblem(reason, 2, "org.eclipse.titan.designer.ontheflySemanticMarker");
    }

    public void reportSingularSemanticError(String reason) {
        if (!this.alreadyExists("org.eclipse.titan.designer.ontheflySemanticMarker", 2, reason)) {
            this.reportProblem(reason, 2, "org.eclipse.titan.designer.ontheflySemanticMarker");
        }
    }

    public void reportSemanticWarning(String reason) {
        this.reportProblem(reason, 1, "org.eclipse.titan.designer.ontheflySemanticMarker");
    }

    public void reportSingularSemanticWarning(String reason) {
        if (!this.alreadyExists("org.eclipse.titan.designer.ontheflySemanticMarker", 1, reason)) {
            this.reportProblem(reason, 1, "org.eclipse.titan.designer.ontheflySemanticMarker");
        }
    }

    public void reportMixedError(String reason) {
        this.reportProblem(reason, 2, "org.eclipse.titan.designer.ontheflyMixedMarker");
    }

    public void reportMixedWarning(String reason) {
        this.reportProblem(reason, 1, "org.eclipse.titan.designer.ontheflyMixedMarker");
    }

    protected final boolean alreadyExists(String markerTypeID, int severity, String reason) {
        if (this.file == null || !this.file.isAccessible()) {
            return false;
        }
        IMarker marker = MarkerHandler.hasMarker(markerTypeID, this.file, this.line, this.offset, this.endOffset, severity, reason);
        if (marker == null) {
            return false;
        }
        return !MarkerHandler.isMarkerdForRemoval(markerTypeID, this.file, marker.getId());
    }

    public void reportExternalProblem(String reason, int severity, String markerID) {
        this.reportProblem(reason, severity, markerID);
    }

    public void reportSingularExternalProblem(String reason, int severity, String markerID) {
        if (!this.alreadyExists(markerID, severity, reason)) {
            this.reportProblem(reason, severity, markerID);
        }
    }

    public void reportExternalProblem(String reason, int severity, int priority, String markerID) {
        this.reportProblem(reason, severity, priority, markerID);
    }

    protected void reportProblem(String reason, int severity, String markerID) {
        this.reportProblem(reason, severity, 2, markerID);
    }

    protected void reportProblem(String reason, int severity, int priority, String markerID) {
        HashMap<String, Object> markerProperties = new HashMap<String, Object>();
        Integer lineNumber = this.line;
        if (this.line != -1) {
            markerProperties.put("lineNumber", lineNumber);
        }
        if (this.offset != -1) {
            markerProperties.put("charStart", this.offset);
        }
        if (this.endOffset != -1) {
            markerProperties.put("charEnd", this.endOffset);
        }
        markerProperties.put("severity", severity);
        markerProperties.put("priority", priority);
        markerProperties.put("message", reason);
        markerProperties.put("transient", Boolean.TRUE);
        try {
            if (this.file != null && this.file.isAccessible()) {
                IMarker marker = MarkerHandler.hasMarker(markerID, this.file, this.line, this.offset, this.endOffset, severity, reason);
                if (marker != null) {
                    MarkerHandler.markUsed(markerID, this.file, marker.getId());
                } else {
                    MarkerCreator markerCreator = new MarkerCreator(markerID, markerProperties);
                    this.file.getWorkspace().run((IWorkspaceRunnable)markerCreator, null, 1, null);
                    IMarker createdMarker = markerCreator.getMarker();
                    long markerId = createdMarker.getId();
                    MarkerHandler.addMarker(markerID, this.file, this.line, this.offset, this.endOffset, markerId);
                }
            }
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)"Error while creating marker", (Throwable)e);
        }
    }

    private final class MarkerCreator
    implements IWorkspaceRunnable {
        private IMarker marker;
        private final String markerID;
        private final Map<String, Object> markerProperties;

        public MarkerCreator(String markerID, Map<String, Object> markerProperties) {
            this.markerID = markerID;
            this.markerProperties = markerProperties;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            this.marker = Location.this.file.createMarker(this.markerID);
            this.marker.setAttributes(this.markerProperties);
        }

        public IMarker getMarker() {
            return this.marker;
        }
    }
}

