/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.AST.TTCN3.definitions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.titan.designer.AST.ASTVisitor;
import org.eclipse.titan.designer.AST.Assignment;
import org.eclipse.titan.designer.AST.ILocateableNode;
import org.eclipse.titan.designer.AST.IReferenceChain;
import org.eclipse.titan.designer.AST.Location;
import org.eclipse.titan.designer.AST.Reference;
import org.eclipse.titan.designer.AST.ReferenceFinder;
import org.eclipse.titan.designer.AST.Scope;
import org.eclipse.titan.designer.AST.TTCN3.IAppendableSyntax;
import org.eclipse.titan.designer.AST.TTCN3.attributes.MultipleWithAttributes;
import org.eclipse.titan.designer.AST.TTCN3.attributes.WithAttributesPath;
import org.eclipse.titan.designer.AST.TTCN3.statements.StatementBlock;
import org.eclipse.titan.designer.editors.ProposalCollector;
import org.eclipse.titan.designer.editors.SkeletonTemplateProposal;
import org.eclipse.titan.designer.editors.T3Doc;
import org.eclipse.titan.designer.editors.ttcn3editor.TTCN3CodeSkeletons;
import org.eclipse.titan.designer.parsers.CompilationTimeStamp;
import org.eclipse.titan.designer.parsers.ttcn3parser.ITTCN3ReparseBase;
import org.eclipse.titan.designer.parsers.ttcn3parser.ReParseException;
import org.eclipse.titan.designer.parsers.ttcn3parser.TTCN3ReparseUpdater;
import org.eclipse.titan.designer.parsers.ttcn3parser.Ttcn3Reparser;

public final class ControlPart
extends Scope
implements ILocateableNode,
IAppendableSyntax {
    private static final String KIND = "controlpart";
    protected StatementBlock statementblock;
    protected WithAttributesPath withAttributesPath = null;
    private Location location;
    private Location commentLocation = null;
    private CompilationTimeStamp lastTimeChecked;

    public static String getKind() {
        return KIND;
    }

    @Override
    public Location getCommentLocation() {
        return this.commentLocation;
    }

    public void setCommentLocation(Location commentLocation) {
        this.commentLocation = commentLocation;
    }

    public ControlPart(StatementBlock statementblock) {
        this.setScopeMacroName("control");
        if (statementblock == null) {
            this.statementblock = new StatementBlock();
        } else {
            this.statementblock = statementblock;
            this.setLocation(statementblock.getLocation());
            this.addSubScope(statementblock.getLocation(), statementblock);
        }
        this.statementblock.setFullNameParent(this);
    }

    @Override
    public void setLocation(Location location) {
        this.location = location;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void setMyScope(Scope scope) {
        this.parentScope = scope;
        this.statementblock.setMyScope(this);
    }

    public Scope getMyScope() {
        return this.statementblock;
    }

    public void setWithAttributes(MultipleWithAttributes attributes) {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        if (attributes != null) {
            this.withAttributesPath.setWithAttributes(attributes);
        }
    }

    public WithAttributesPath getAttributePath() {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        return this.withAttributesPath;
    }

    public void setAttributeParentPath(WithAttributesPath parent) {
        if (this.withAttributesPath == null) {
            this.withAttributesPath = new WithAttributesPath();
        }
        this.withAttributesPath.setAttributeParent(parent);
    }

    public void check(CompilationTimeStamp timestamp) {
        if (this.lastTimeChecked != null && !this.lastTimeChecked.isLess(timestamp)) {
            return;
        }
        T3Doc.check(this.getCommentLocation(), KIND);
        this.statementblock.check(timestamp);
        if (this.withAttributesPath != null) {
            this.withAttributesPath.checkGlobalAttributes(timestamp, false);
            this.withAttributesPath.checkAttributes(timestamp);
        }
        this.lastTimeChecked = timestamp;
    }

    public void postCheck() {
        this.statementblock.postCheck();
    }

    @Override
    public ControlPart getControlPart() {
        return this;
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference) {
        return this.getAssBySRef(timestamp, reference, null);
    }

    @Override
    public Assignment getAssBySRef(CompilationTimeStamp timestamp, Reference reference, IReferenceChain refChain) {
        return this.getParentScope().getAssBySRef(timestamp, reference);
    }

    @Override
    public void addProposal(ProposalCollector propCollector) {
        for (SkeletonTemplateProposal templateProposal : TTCN3CodeSkeletons.CONTROL_PART_FUNCTIONS) {
            propCollector.addTemplateProposal(templateProposal.getPrefix(), templateProposal.getProposal(), TTCN3CodeSkeletons.SKELETON_IMAGE);
        }
        super.addProposal(propCollector);
    }

    @Override
    public List<Integer> getPossibleExtensionStarterTokens() {
        if (this.withAttributesPath == null || this.withAttributesPath.getAttributes() == null) {
            ArrayList<Integer> result = new ArrayList<Integer>();
            result.add(155);
            return result;
        }
        return null;
    }

    @Override
    public List<Integer> getPossiblePrefixTokens() {
        return new ArrayList<Integer>(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateSyntax(TTCN3ReparseUpdater reparser) throws ReParseException {
        if (reparser.isDamaged(this.getLocation())) {
            this.lastTimeChecked = null;
            boolean enveloped = false;
            if (reparser.envelopsDamage(this.statementblock.getLocation())) {
                this.statementblock.updateSyntax(reparser, true);
                enveloped = true;
                reparser.updateLocation(this.statementblock.getLocation());
            } else {
                if (reparser.isDamaged(this.statementblock.getLocation())) {
                    throw new ReParseException();
                }
                this.statementblock.updateSyntax(reparser, false);
                reparser.updateLocation(this.statementblock.getLocation());
            }
            if (this.withAttributesPath != null) {
                if (enveloped) {
                    this.withAttributesPath.updateSyntax(reparser, false);
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                } else {
                    if (reparser.envelopsDamage(this.withAttributesPath.getLocation())) {
                        reparser.extendDamagedRegion(this.withAttributesPath.getLocation());
                        int result = this.reparse(reparser);
                        if (result != 0) throw new ReParseException();
                        return;
                    }
                    if (reparser.isDamaged(this.withAttributesPath.getLocation())) {
                        throw new ReParseException();
                    }
                    this.withAttributesPath.updateSyntax(reparser, false);
                    reparser.updateLocation(this.withAttributesPath.getLocation());
                }
            }
            if (enveloped) return;
            throw new ReParseException();
        }
        this.statementblock.updateSyntax(reparser, false);
        reparser.updateLocation(this.statementblock.getLocation());
        if (this.withAttributesPath == null) return;
        this.withAttributesPath.updateSyntax(reparser, false);
        reparser.updateLocation(this.withAttributesPath.getLocation());
    }

    private int reparse(TTCN3ReparseUpdater aReparser) {
        return aReparser.parse(new ITTCN3ReparseBase(){

            @Override
            public void reparse(Ttcn3Reparser parser) {
                MultipleWithAttributes attributes = parser.pr_reparser_optionalWithStatement().attributes;
                parser.pr_EndOfFile();
                if (parser.isErrorListEmpty()) {
                    ControlPart.this.withAttributesPath.setWithAttributes(attributes);
                    if (attributes != null) {
                        ControlPart.this.getLocation().setEndOffset(attributes.getLocation().getEndOffset());
                    }
                }
            }
        });
    }

    @Override
    public Assignment getEnclosingAssignment(int offset) {
        if (this.statementblock == null) {
            return null;
        }
        return this.statementblock.getEnclosingAssignment(offset);
    }

    @Override
    public void findReferences(ReferenceFinder referenceFinder, List<ReferenceFinder.Hit> foundIdentifiers) {
        if (this.statementblock != null) {
            this.statementblock.findReferences(referenceFinder, foundIdentifiers);
        }
        if (this.withAttributesPath != null) {
            this.withAttributesPath.findReferences(referenceFinder, foundIdentifiers);
        }
    }

    @Override
    public boolean accept(ASTVisitor v) {
        switch (v.visit(this)) {
            case 2: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        if (this.statementblock != null && !this.statementblock.accept(v)) {
            return false;
        }
        if (this.withAttributesPath != null && !this.withAttributesPath.accept(v)) {
            return false;
        }
        return v.leave(this) != 2;
    }
}

