/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.designer.properties.data;

import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class FileBuildPropertyData {
    public static final String QUALIFIER = "org.eclipse.titan.designer.Properties.File";
    public static final String FILERESOURCEXMLNODE = "FileResource";
    public static final String FILEPATHXMLNODE = "FilePath";
    public static final String FILEPROPERTIESXMLNODE = "FileProperties";
    public static final String EXCLUDEFROMBUILDXMLNODE = "ExcludeFromBuild";
    public static final String TRUE_STRING = "true";
    public static final String FALSE_STRING = "false";
    public static final String EXCLUDE_FROM_BUILD_PROPERTY = "excludeFromBuild";

    private FileBuildPropertyData() {
    }

    public static void removeTITANAttributes(IFile file) {
        try {
            file.setPersistentProperty(new QualifiedName(QUALIFIER, EXCLUDE_FROM_BUILD_PROPERTY), null);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While removing properties of `" + file.getName() + "'"), (Throwable)e);
        }
    }

    private static String getPropertyValue(IFile file, String property) {
        String temp = null;
        try {
            temp = file.getPersistentProperty(new QualifiedName(QUALIFIER, property));
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While getting property `" + property + "' of `" + file.getName() + "'"), (Throwable)e);
        }
        if (!TRUE_STRING.equals(temp)) {
            temp = FALSE_STRING;
        }
        return temp;
    }

    private static void setPropertyValue(IFile file, String property, String value) {
        try {
            file.setPersistentProperty(new QualifiedName(QUALIFIER, property), TRUE_STRING.equals(value) ? TRUE_STRING : FALSE_STRING);
        }
        catch (CoreException e) {
            ErrorReporter.logExceptionStackTrace((String)("While setting property `" + property + "' of `" + file.getName() + "'"), (Throwable)e);
        }
    }

    public static boolean hasDefaultProperties(IFile file) {
        return FALSE_STRING.equals(FileBuildPropertyData.getPropertyValue(file, EXCLUDE_FROM_BUILD_PROPERTY));
    }

    public static Element saveFileProperties(Document document, IFile file) {
        Element root = document.createElement(FILERESOURCEXMLNODE);
        Element filePath = document.createElement(FILEPATHXMLNODE);
        filePath.appendChild(document.createTextNode(file.getProjectRelativePath().toPortableString()));
        root.appendChild(filePath);
        Element fileProperties = document.createElement(FILEPROPERTIESXMLNODE);
        Element excludeFromBuild = document.createElement(EXCLUDEFROMBUILDXMLNODE);
        excludeFromBuild.appendChild(document.createTextNode(FileBuildPropertyData.getPropertyValue(file, EXCLUDE_FROM_BUILD_PROPERTY)));
        fileProperties.appendChild(excludeFromBuild);
        root.appendChild(fileProperties);
        return root;
    }

    public static void loadFileProperties(Node node, IProject project, Set<IFile> notYetReachedFiles, Set<IResource> changedResources) {
        NodeList resourceList = node.getChildNodes();
        int filePathIndex = -1;
        int filePropertiesIndex = -1;
        int size = resourceList.getLength();
        for (int i = 0; i < size; ++i) {
            String nodeName = resourceList.item(i).getNodeName();
            if (FILEPATHXMLNODE.equals(nodeName)) {
                filePathIndex = i;
                continue;
            }
            if (!FILEPROPERTIESXMLNODE.equals(nodeName)) continue;
            filePropertiesIndex = i;
        }
        if (filePathIndex == -1 || filePropertiesIndex == -1) {
            return;
        }
        String filePath = resourceList.item(filePathIndex).getTextContent();
        if (!project.exists((IPath)new Path(filePath))) {
            return;
        }
        IFile file = project.getFile(filePath);
        if (notYetReachedFiles.contains(file)) {
            notYetReachedFiles.remove(file);
        }
        NodeList fileProperties = resourceList.item(filePropertiesIndex).getChildNodes();
        String oldValue = FileBuildPropertyData.getPropertyValue(file, EXCLUDE_FROM_BUILD_PROPERTY);
        int size2 = fileProperties.getLength();
        for (int i = 0; i < size2; ++i) {
            Node property = fileProperties.item(i);
            if (!EXCLUDEFROMBUILDXMLNODE.equals(property.getNodeName())) continue;
            String value = property.getTextContent();
            if (oldValue != null && oldValue.equals(value)) continue;
            changedResources.add((IResource)file);
            FileBuildPropertyData.setPropertyValue(file, EXCLUDE_FROM_BUILD_PROPERTY, value);
        }
    }

    public static void loadDefaultProperties(IFile file, Set<IResource> changedResources) {
        String oldValue = FileBuildPropertyData.getPropertyValue(file, EXCLUDE_FROM_BUILD_PROPERTY);
        if (oldValue == null || !oldValue.equals(FALSE_STRING)) {
            changedResources.add((IResource)file);
            FileBuildPropertyData.setPropertyValue(file, EXCLUDE_FROM_BUILD_PROPERTY, FALSE_STRING);
        }
    }

    public static Node copyFileProperties(Node sourceNode, Document document, IProject project, Set<String> notYetReachedFiles, boolean saveDefaultValues) {
        String filePath = null;
        String excludeValue = FALSE_STRING;
        if (sourceNode != null) {
            NodeList resourceList = sourceNode.getChildNodes();
            int filePathIndex = -1;
            int filePropertiesIndex = -1;
            int size = resourceList.getLength();
            for (int i = 0; i < size; ++i) {
                String nodeName = resourceList.item(i).getNodeName();
                if (FILEPATHXMLNODE.equals(nodeName)) {
                    filePathIndex = i;
                    continue;
                }
                if (!FILEPROPERTIESXMLNODE.equals(nodeName)) continue;
                filePropertiesIndex = i;
            }
            if (filePathIndex == -1) {
                return null;
            }
            filePath = resourceList.item(filePathIndex).getTextContent();
            if (!project.exists((IPath)new Path(filePath))) {
                return null;
            }
            notYetReachedFiles.remove(filePath);
            if (filePropertiesIndex != -1) {
                NodeList fileProperties = resourceList.item(filePropertiesIndex).getChildNodes();
                int size2 = fileProperties.getLength();
                for (int i = 0; i < size2; ++i) {
                    Node property = fileProperties.item(i);
                    if (!EXCLUDEFROMBUILDXMLNODE.equals(property.getNodeName()) || FALSE_STRING.equals(excludeValue = property.getTextContent()) || TRUE_STRING.equals(excludeValue)) continue;
                    excludeValue = FALSE_STRING;
                }
            }
        }
        if (!saveDefaultValues && FALSE_STRING.equals(excludeValue)) {
            return null;
        }
        Element root = document.createElement(FILERESOURCEXMLNODE);
        Element filePathNode = document.createElement(FILEPATHXMLNODE);
        filePathNode.appendChild(document.createTextNode(filePath));
        root.appendChild(filePathNode);
        Element fileProperties = document.createElement(FILEPROPERTIESXMLNODE);
        Element excludeFromBuild = document.createElement(EXCLUDEFROMBUILDXMLNODE);
        excludeFromBuild.appendChild(document.createTextNode(excludeValue));
        fileProperties.appendChild(excludeFromBuild);
        root.appendChild(fileProperties);
        return root;
    }

    public static Node copyDefaultFileProperties(Document document, IFile file) {
        Element root = document.createElement(FILERESOURCEXMLNODE);
        Element filePath = document.createElement(FILEPATHXMLNODE);
        filePath.appendChild(document.createTextNode(file.getProjectRelativePath().toPortableString()));
        root.appendChild(filePath);
        Element fileProperties = document.createElement(FILEPROPERTIESXMLNODE);
        Element excludeFromBuild = document.createElement(EXCLUDEFROMBUILDXMLNODE);
        excludeFromBuild.appendChild(document.createTextNode(FALSE_STRING));
        fileProperties.appendChild(excludeFromBuild);
        root.appendChild(fileProperties);
        return root;
    }
}

