/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.commands;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import org.eclipse.core.commands.Command;
import org.eclipse.core.runtime.ListenerList;

public class TagManager {
    private Hashtable<Command, String> fCommandToTags = new Hashtable();
    private ListenerList<Listener> fListeners = new ListenerList();

    public void update(Command command, String tags) {
        if (tags == null || "".equals(tags)) {
            this.fCommandToTags.remove(command);
        } else {
            this.fCommandToTags.put(command, tags);
        }
        this.fireTagManagerChanged();
    }

    private boolean hasTag(String tags, String tag) {
        String[] tagArray = tags.split(",");
        int i = 0;
        while (i < tagArray.length) {
            String trimTag = tagArray[i].trim();
            if (tag.equalsIgnoreCase(trimTag)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String[] getTags() {
        HashSet<String> tagSet = new HashSet<String>();
        for (String tags : this.fCommandToTags.values()) {
            String[] tagArray = tags.split(",");
            int j = 0;
            while (j < tagArray.length) {
                String trimTag = tagArray[j].trim();
                tagSet.add(trimTag);
                ++j;
            }
        }
        return tagSet.toArray(new String[tagSet.size()]);
    }

    public String getTags(Command command) {
        String tags = this.fCommandToTags.get(command);
        if (tags == null) {
            return "";
        }
        return tags;
    }

    public Command[] getCommands(String tag) {
        ArrayList<Command> list = new ArrayList<Command>();
        for (Command command : this.fCommandToTags.keySet()) {
            String tags = this.fCommandToTags.get(command);
            if (!this.hasTag(tags, tag)) continue;
            list.add(command);
        }
        return list.toArray(new Command[list.size()]);
    }

    public void addListener(Listener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeListener(Listener listener) {
        this.fListeners.remove((Object)listener);
    }

    private void fireTagManagerChanged() {
        for (Listener listener : this.fListeners) {
            listener.tagManagerChanged();
        }
    }

    public static interface Listener {
        public void tagManagerChanged();
    }
}

