/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.sew.launcher.workflow.common;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DebuglevelKind implements Enumerator
{
    NONE(-1, "NONE", "NONE"),
    ZERO(0, "ZERO", "ZERO"),
    LOW(1, "LOW", "LOW"),
    MEDIUM(2, "MEDIUM", "MEDIUM"),
    HIGH(3, "HIGH", "HIGH"),
    ULTRA(4, "ULTRA", "ULTRA"),
    GOD_MODE(5, "GOD_MODE", "GOD_MODE");

    public static final int NONE_VALUE = -1;
    public static final int ZERO_VALUE = 0;
    public static final int LOW_VALUE = 1;
    public static final int MEDIUM_VALUE = 2;
    public static final int HIGH_VALUE = 3;
    public static final int ULTRA_VALUE = 4;
    public static final int GOD_MODE_VALUE = 5;
    private static final DebuglevelKind[] VALUES_ARRAY;
    public static final List<DebuglevelKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DebuglevelKind[]{NONE, ZERO, LOW, MEDIUM, HIGH, ULTRA, GOD_MODE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DebuglevelKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DebuglevelKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DebuglevelKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DebuglevelKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DebuglevelKind get(int value) {
        switch (value) {
            case -1: {
                return NONE;
            }
            case 0: {
                return ZERO;
            }
            case 1: {
                return LOW;
            }
            case 2: {
                return MEDIUM;
            }
            case 3: {
                return HIGH;
            }
            case 4: {
                return ULTRA;
            }
            case 5: {
                return GOD_MODE;
            }
        }
        return null;
    }

    private DebuglevelKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

