/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.titan.log.viewer.exceptions;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.titan.common.logging.ErrorReporter;
import org.eclipse.titan.log.viewer.exceptions.TechnicalException;
import org.eclipse.titan.log.viewer.exceptions.UserException;
import org.eclipse.titan.log.viewer.utils.Messages;

public final class TitanLogExceptionHandler {
    private TitanLogExceptionHandler() {
    }

    public static void handleException(Throwable exception) {
        Display display = Display.getDefault();
        if (exception instanceof UserException) {
            final UserException userException = (UserException)exception;
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError(null, (String)Messages.getString("TitanLogExceptionHandler.0"), (String)userException.getMessage());
                }
            });
        } else if (exception instanceof TechnicalException) {
            final TechnicalException technicalException = (TechnicalException)exception;
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError(null, (String)Messages.getString("TitanLogExceptionHandler.1"), (String)technicalException.getMessage());
                    ErrorReporter.logExceptionStackTrace((Exception)technicalException);
                }
            });
        } else {
            final Exception otherException = (Exception)exception;
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError(null, (String)Messages.getString("TitanLogExceptionHandler.2"), (String)otherException.getMessage());
                    ErrorReporter.logExceptionStackTrace((Exception)otherException);
                }
            });
        }
    }
}

