/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.io.IOException;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.Registration;
import org.osgi.service.http.HttpContext;

public class ServletRegistration
extends Registration {
    private Servlet servlet;
    private HttpContext httpContext;
    private ClassLoader registeredContextClassLoader;

    public ServletRegistration(Servlet servlet, HttpContext context) {
        this.servlet = servlet;
        this.httpContext = context;
        this.registeredContextClassLoader = Thread.currentThread().getContextClassLoader();
    }

    public void destroy() {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.registeredContextClassLoader);
            super.destroy();
            this.servlet.destroy();
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.registeredContextClassLoader);
            this.servlet.init(servletConfig);
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        ClassLoader original = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.registeredContextClassLoader);
            if (this.httpContext.handleSecurity(req, resp)) {
                this.servlet.service((ServletRequest)req, (ServletResponse)resp);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(original);
        }
    }

    public Servlet getServlet() {
        return this.servlet;
    }

    public HttpContext getHttpContext() {
        return this.httpContext;
    }
}

