/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.fx;

import javafx.beans.property.Property;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.ui.di.Focus;
import org.eclipse.e4.ui.di.Persist;
import org.eclipse.fx.code.editor.Input;
import org.eclipse.fx.core.di.ContextValue;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;

public class TextEditor {
    private IDocument document;
    private SourceViewerConfiguration configuration;
    private IDocumentPartitioner partitioner;
    private Input<?> input;
    private Property<Input<?>> activeInput;
    private SourceViewer viewer;

    @Inject
    public void setDocument(IDocument document) {
        if (this.viewer != null) {
            throw new IllegalArgumentException("The document has to be set before the editor is initialized");
        }
        this.document = document;
    }

    @Inject
    public void setSourceViewerConfiguration(SourceViewerConfiguration configuration) {
        if (this.viewer != null) {
            throw new IllegalArgumentException("The configuration has to be set before the editor is initialized");
        }
        this.configuration = configuration;
    }

    @Inject
    public void setPartitioner(IDocumentPartitioner partitioner) {
        if (this.viewer != null) {
            throw new IllegalArgumentException("The partitioner has to be set before the editor is initialized");
        }
        this.partitioner = partitioner;
    }

    @Inject
    public void setInput(Input<?> input) {
        if (this.viewer != null) {
            throw new IllegalArgumentException("The input has to be set before the editor is initialized");
        }
        this.input = input;
    }

    @Inject
    @Optional
    public void setActiveInputTracker(@ContextValue(value="activeInput") Property<Input<?>> activeInput) {
        this.activeInput = activeInput;
    }

    @PostConstruct
    public void initUI(BorderPane pane) {
        this.viewer = new SourceViewer();
        if (this.document instanceof IDocumentExtension3) {
            ((IDocumentExtension3)this.document).setDocumentPartitioner(this.configuration.getConfiguredDocumentPartitioning((ISourceViewer)this.viewer), this.partitioner);
        } else {
            this.document.setDocumentPartitioner(this.partitioner);
        }
        this.document.setDocumentPartitioner(this.partitioner);
        this.partitioner.connect(this.document);
        this.viewer.configure(this.configuration);
        this.viewer.setDocument(this.document, this.configuration.getAnnotationModel());
        pane.setCenter((Node)this.viewer);
        if (this.activeInput != null) {
            this.activeInput.setValue(this.input);
        }
    }

    @Persist
    public void save() {
        this.input.persist();
        this.documentSaved();
    }

    protected void documentSaved() {
    }

    @Focus
    void focused() {
        if (this.activeInput != null) {
            this.activeInput.setValue(this.input);
        }
        this.viewer.getTextWidget().requestFocus();
        if (this.viewer.getTextWidget().getCaretOffset() == -1 && this.viewer.getTextWidget().getContent().getCharCount() > 0) {
            this.viewer.getTextWidget().setCaretOffset(0);
        }
    }

    @PreDestroy
    void destroy() {
        if (this.activeInput != null && this.activeInput.getValue() == this.input) {
            this.activeInput.setValue(null);
        }
        this.input = null;
    }
}

