/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.internal;

import org.eclipse.xtext.formatting2.ITextSegment;
import org.eclipse.xtext.formatting2.internal.CommentReplacer;
import org.eclipse.xtext.formatting2.internal.TextSegment;
import org.eclipse.xtext.formatting2.regionaccess.IComment;

public abstract class SinglelineCommentReplacer
extends CommentReplacer {
    private final String prefix;

    public SinglelineCommentReplacer(IComment comment, String prefix) {
        super(comment);
        this.prefix = prefix;
    }

    protected ITextSegment getFirstSpace() {
        int start;
        IComment comment = this.getComment();
        String text = comment.getText();
        if (!text.startsWith(this.prefix)) {
            return null;
        }
        int i = start = this.prefix.length();
        while (i < text.length()) {
            char charAt = text.charAt(i);
            if (!Character.isWhitespace(charAt) || charAt == '\r' || charAt == '\n') {
                return new TextSegment(comment.getTextRegionAccess(), comment.getOffset() + start, i - start);
            }
            ++i;
        }
        return new TextSegment(comment.getTextRegionAccess(), comment.getOffset() + start, text.length() - start);
    }

    public String getPrefix() {
        return this.prefix;
    }

    protected boolean hasEmptyBody() {
        int start;
        IComment comment = this.getComment();
        String text = comment.getText();
        if (!text.startsWith(this.prefix)) {
            return false;
        }
        int i = start = this.prefix.length();
        while (i < text.length()) {
            char charAt = text.charAt(i);
            if (!Character.isWhitespace(charAt)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

