/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.di.context.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.fx.core.Callback;
import org.eclipse.fx.core.ObjectSerializer;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.ValueSerializer;
import org.eclipse.fx.core.adapter.AdapterService;
import org.eclipse.fx.core.di.context.internal.PreferenceValueSupplier;
import org.eclipse.fx.core.log.Log;
import org.eclipse.fx.core.log.Logger;
import org.eclipse.fx.core.preferences.Value;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceValue<T>
implements Value<T> {
    private @Nullable IEclipsePreferences instancePreference;
    private @Nullable IEclipsePreferences configurationPreference;
    private @Nullable IEclipsePreferences defaultPreference;
    private @Nullable String contextKey;
    @Nullable List<Callback<T>> callbacks;
    @Nullable List<Callback<Void>> disposalCallbacks;
    private @Nullable T value;
    @Inject
    @Optional
    @Nullable IEventBroker eventBroker;
    @Inject
    @Log
    private Logger logger;
    private // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable IEclipsePreferences.IPreferenceChangeListener listener;
    private @NonNull AdapterService adapterService;
    private @NonNull ValueSerializer valueSerializer;
    private @NonNull ObjectSerializer objectSerializer;
    private @NonNull IEclipseContext context;

    @Inject
    public PreferenceValue(@NonNull IEclipseContext context, @NonNull AdapterService adapterService, @NonNull ValueSerializer valueSerializer, @NonNull ObjectSerializer objectSerializer) {
        this.context = context;
        this.adapterService = adapterService;
        this.valueSerializer = valueSerializer;
        this.objectSerializer = objectSerializer;
    }

    public void init(String nodePath, @NonNull String contextKey, Class<?> cl, T defaultValue) {
        IEclipsePreferences.IPreferenceChangeListener listener;
        this.contextKey = contextKey;
        IEclipsePreferences instancePreference = InstanceScope.INSTANCE.getNode(nodePath);
        IEclipsePreferences configurationPreference = ConfigurationScope.INSTANCE.getNode(nodePath);
        IEclipsePreferences defaultPreference = DefaultScope.INSTANCE.getNode(nodePath);
        this.listener = listener = event -> {
            if (contextKey.equals(event.getKey())) {
                this.setCurrentValue(PreferenceValueSupplier.getValue(nodePath, contextKey, cl, defaultValue));
            }
        };
        instancePreference.addPreferenceChangeListener(listener);
        configurationPreference.addPreferenceChangeListener(listener);
        defaultPreference.addPreferenceChangeListener(listener);
        this.instancePreference = instancePreference;
        this.configurationPreference = configurationPreference;
        this.defaultPreference = defaultPreference;
        this.contextKey = contextKey;
        this.setCurrentValue(PreferenceValueSupplier.getValue(nodePath, contextKey, cl, defaultValue));
    }

    void setCurrentValue(@Nullable T o) {
        this.value = o;
        if (this.callbacks != null) {
            Callback[] callbackArray = this.callbacks.toArray(new Callback[0]);
            int n = callbackArray.length;
            int n2 = 0;
            while (n2 < n) {
                Callback c = callbackArray[n2];
                try {
                    c.call(o);
                }
                catch (Throwable t) {
                    this.logger.error("Failed while executing callback", t);
                }
                ++n2;
            }
        }
    }

    public @Nullable T getValue() {
        return this.value;
    }

    public void publish(@Nullable T value) {
        IEclipsePreferences preference = this.instancePreference;
        if (preference == null) {
            throw new IllegalStateException("The backing IEclipsePreference is null");
        }
        if (value == null) {
            preference.remove(this.contextKey);
        } else {
            String v = value.getClass() == String.class || value.getClass() == CharSequence.class ? value.toString() : (this.valueSerializer.test(value.getClass()) ? this.valueSerializer.toString(value) : this.objectSerializer.serialize(value));
            preference.put(this.contextKey, v);
            try {
                preference.flush();
            }
            catch (BackingStoreException e) {
                e.printStackTrace();
            }
        }
        if (this.eventBroker != null) {
            this.eventBroker.send("org/eclipse/fx/context/key", Collections.singletonMap(this.contextKey, value));
        }
    }

    public Subscription subscribeOnValueChange(final Callback<T> callback) {
        if (this.callbacks == null) {
            this.callbacks = new ArrayList<Callback<T>>();
        }
        if (this.callbacks != null) {
            this.callbacks.add(callback);
        }
        return new Subscription(){

            public void dispose() {
                List callbacks = PreferenceValue.this.callbacks;
                if (callbacks != null) {
                    callbacks.remove(callback);
                }
            }
        };
    }

    public Subscription subscribeOnDispose(final Callback<Void> callback) {
        if (this.disposalCallbacks == null) {
            this.disposalCallbacks = new ArrayList<Callback<Void>>();
        }
        if (this.disposalCallbacks != null) {
            this.disposalCallbacks.add(callback);
        }
        return new Subscription(){

            public void dispose() {
                List<Callback<Void>> disposalCallbacks = PreferenceValue.this.disposalCallbacks;
                if (disposalCallbacks != null) {
                    disposalCallbacks.remove(callback);
                }
            }
        };
    }

    public <A> A adaptTo(@NonNull Class<A> adapt) {
        return (A)this.adapterService.adapt((Object)this, adapt, new AdapterService.ValueAccess[]{new ValueAccessImpl(this.context)});
    }

    public boolean canAdaptTo(Class<?> adapt) {
        return this.adapterService.canAdapt((Object)this, adapt);
    }

    @PreDestroy
    void dispose() {
        List<Callback<Void>> disposalCallbacks = this.disposalCallbacks;
        if (disposalCallbacks != null) {
            Callback[] callbackArray = disposalCallbacks.toArray(new Callback[0]);
            int n = callbackArray.length;
            int n2 = 0;
            while (n2 < n) {
                Callback callback = callbackArray[n2];
                try {
                    callback.call(null);
                }
                catch (Throwable t) {
                    this.logger.error("Failure while executing clean up callback", t);
                }
                ++n2;
            }
            disposalCallbacks.clear();
        }
        if (this.callbacks != null) {
            this.callbacks.clear();
        }
        this.value = null;
        this.cleanupListener(this.instancePreference);
        this.cleanupListener(this.configurationPreference);
        this.cleanupListener(this.defaultPreference);
        this.instancePreference = null;
        this.configurationPreference = null;
        this.defaultPreference = null;
        this.listener = null;
    }

    private void cleanupListener(@Nullable IEclipsePreferences node) {
        IEclipsePreferences.IPreferenceChangeListener listener = this.listener;
        if (node != null && listener != null) {
            try {
                node.removePreferenceChangeListener(listener);
            }
            catch (Throwable throwable) {}
        }
    }

    static class ValueAccessImpl
    implements AdapterService.ValueAccess {
        private final IEclipseContext context;

        public ValueAccessImpl(IEclipseContext context) {
            this.context = context;
        }

        public <O> O getValue(String key) {
            return (O)this.context.get(key);
        }

        public <O> O getValue(@NonNull Class<O> key) {
            return (O)this.context.get(key);
        }
    }
}

