/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import org.eclipse.core.runtime.Assert;
import org.eclipse.fx.text.ui.DefaultDocumentAdapter;
import org.eclipse.fx.text.ui.IDocumentAdapter;
import org.eclipse.fx.text.ui.IRewriteTarget;
import org.eclipse.fx.text.ui.ITextHover;
import org.eclipse.fx.text.ui.ITextInputListener;
import org.eclipse.fx.text.ui.ITextListener;
import org.eclipse.fx.text.ui.ITextPresentationListener;
import org.eclipse.fx.text.ui.ITextViewer;
import org.eclipse.fx.text.ui.ITextViewerExtension;
import org.eclipse.fx.text.ui.ITextViewerExtension2;
import org.eclipse.fx.text.ui.ITextViewerExtension4;
import org.eclipse.fx.text.ui.ITextViewerExtension6;
import org.eclipse.fx.text.ui.ITextViewerExtension7;
import org.eclipse.fx.text.ui.ITextViewerExtension8;
import org.eclipse.fx.text.ui.TextEvent;
import org.eclipse.fx.text.ui.TextPresentation;
import org.eclipse.fx.text.ui.TextViewerHoverManager;
import org.eclipse.fx.ui.controls.styledtext.StyleRange;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.StyledTextContent;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentRewriteSessionEvent;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.IDocumentInformationMapping;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentRewriteSessionListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ISlaveDocumentManager;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.SlaveDocumentEvent;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.projection.ChildDocument;
import org.eclipse.jface.text.projection.ChildDocumentManager;

public class TextViewer
extends AnchorPane
implements ITextViewer,
ITextViewerExtension,
ITextViewerExtension2,
ITextViewerExtension4,
ITextViewerExtension6,
ITextViewerExtension7,
ITextViewerExtension8 {
    private StyledTextArea fTextWidget;
    private IDocument fVisibleDocument;
    private VisibleDocumentListener fVisibleDocumentListener = new VisibleDocumentListener();
    private ISlaveDocumentManager fSlaveDocumentManager;
    private IDocumentInformationMapping fInformationMapping;
    private IDocumentAdapter fDocumentAdapter;
    private WidgetCommand fWidgetCommand = new WidgetCommand();
    protected List fTextListeners;
    private int fRedrawCounter = 0;
    private IRegion fLastSentSelectionChange;
    private String fPartitioning;
    private IDocument fDocument;
    private boolean fReplaceTextPresentation;
    private DocumentRewriteSessionListener fDocumentRewriteSessionListener = new DocumentRewriteSessionListener();
    private IRewriteTarget fRewriteTarget;
    private ViewerState fViewerState;
    private List fTextInputListeners;
    protected Position fMarkPosition;
    private final String MARK_POSITION_CATEGORY = "__mark_category_" + this.hashCode();
    private final IPositionUpdater fMarkPositionUpdater = new DefaultPositionUpdater(this.MARK_POSITION_CATEGORY);
    private List fTextPresentationListeners;
    protected Map<TextHoverKey, ITextHover> fTextHovers;
    private TextViewerHoverManager fTextHoverManager;

    public TextViewer() {
        this.createControl();
    }

    protected void createControl() {
        this.fTextWidget = this.createTextWidget();
        AnchorPane.setLeftAnchor((Node)this.fTextWidget, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.fTextWidget, (Double)0.0);
        AnchorPane.setTopAnchor((Node)this.fTextWidget, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.fTextWidget, (Double)0.0);
        this.getChildren().add((Object)this.fTextWidget);
    }

    @Override
    public StyledTextArea getTextWidget() {
        return this.fTextWidget;
    }

    protected StyledTextArea createTextWidget() {
        StyledTextArea styledText = new StyledTextArea();
        styledText.setLineRulerVisible(true);
        return styledText;
    }

    public void setInput(Object input) {
        IDocument document = null;
        if (input instanceof IDocument) {
            document = (IDocument)input;
        }
        this.setDocument(document);
    }

    public Object getInput() {
        return this.getDocument();
    }

    public void setDocumentPartitioning(String partitioning) {
        this.fPartitioning = partitioning;
    }

    protected String getDocumentPartitioning() {
        return this.fPartitioning;
    }

    protected void setVisibleDocument(IDocument document) {
        if (this.fVisibleDocument == document && this.fVisibleDocument instanceof ChildDocument) {
            return;
        }
        if (this.fVisibleDocument != null) {
            if (this.fVisibleDocumentListener != null) {
                this.fVisibleDocument.removeDocumentListener((IDocumentListener)this.fVisibleDocumentListener);
            }
            if (this.fVisibleDocument != document) {
                this.freeSlaveDocument(this.fVisibleDocument);
            }
        }
        this.fVisibleDocument = document;
        this.initializeDocumentInformationMapping(this.fVisibleDocument);
        this.initializeWidgetContents();
        if (this.fVisibleDocument != null && this.fVisibleDocumentListener != null) {
            this.fVisibleDocument.addDocumentListener((IDocumentListener)this.fVisibleDocumentListener);
        }
    }

    @Override
    public IDocument getDocument() {
        return this.fDocument;
    }

    @Override
    public void setDocument(IDocument document) {
        this.fReplaceTextPresentation = true;
        this.fireInputDocumentAboutToBeChanged(this.fDocument, document);
        IDocument oldDocument = this.fDocument;
        this.fDocument = document;
        this.setVisibleDocument(this.fDocument);
        this.inputChanged(this.fDocument, oldDocument);
        this.fireInputDocumentChanged(oldDocument, this.fDocument);
        this.fLastSentSelectionChange = null;
        this.fReplaceTextPresentation = false;
    }

    @Override
    public void setDocument(IDocument document, int modelRangeOffset, int modelRangeLength) {
        this.fReplaceTextPresentation = true;
        this.fireInputDocumentAboutToBeChanged(this.fDocument, document);
        IDocument oldDocument = this.fDocument;
        this.fDocument = document;
        try {
            IDocument slaveDocument = this.createSlaveDocument(document);
            this.updateSlaveDocument(slaveDocument, modelRangeOffset, modelRangeLength);
            this.setVisibleDocument(slaveDocument);
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalArgumentException();
        }
        this.inputChanged(this.fDocument, oldDocument);
        this.fireInputDocumentChanged(oldDocument, this.fDocument);
        this.fLastSentSelectionChange = null;
        this.fReplaceTextPresentation = false;
    }

    protected IDocument createSlaveDocument(IDocument document) {
        ISlaveDocumentManager manager = this.getSlaveDocumentManager();
        if (manager != null) {
            if (manager.isSlaveDocument(document)) {
                return document;
            }
            return manager.createSlaveDocument(document);
        }
        return document;
    }

    protected boolean updateSlaveDocument(IDocument slaveDocument, int modelRangeOffset, int modelRangeLength) throws BadLocationException {
        return this.updateVisibleDocument(slaveDocument, modelRangeOffset, modelRangeLength);
    }

    protected boolean updateVisibleDocument(IDocument visibleDocument, int visibleRegionOffset, int visibleRegionLength) throws BadLocationException {
        if (visibleDocument instanceof ChildDocument) {
            ChildDocument childDocument = (ChildDocument)visibleDocument;
            IDocument document = childDocument.getParentDocument();
            int line = document.getLineOfOffset(visibleRegionOffset);
            int offset = document.getLineOffset(line);
            int length = visibleRegionOffset - offset + visibleRegionLength;
            Position parentRange = childDocument.getParentDocumentRange();
            if (offset != parentRange.getOffset() || length != parentRange.getLength()) {
                childDocument.setParentDocumentRange(offset, length);
                return true;
            }
        }
        return false;
    }

    @Override
    public IRegion getVisibleRegion() {
        IDocument document = this.getVisibleDocument();
        if (document instanceof ChildDocument) {
            Position p = ((ChildDocument)document).getParentDocumentRange();
            return new Region(p.getOffset(), p.getLength());
        }
        return new Region(0, document == null ? 0 : document.getLength());
    }

    protected void fireInputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        List listener = this.fTextInputListeners;
        if (listener != null) {
            int i = 0;
            while (i < listener.size()) {
                ITextInputListener l = (ITextInputListener)listener.get(i);
                l.inputDocumentAboutToBeChanged(oldInput, newInput);
                ++i;
            }
        }
    }

    protected void fireInputDocumentChanged(IDocument oldInput, IDocument newInput) {
        List listener = this.fTextInputListeners;
        if (listener != null) {
            int i = 0;
            while (i < listener.size()) {
                ITextInputListener l = (ITextInputListener)listener.get(i);
                l.inputDocumentChanged(oldInput, newInput);
                ++i;
            }
        }
    }

    protected IDocument getVisibleDocument() {
        return this.fVisibleDocument;
    }

    protected void freeSlaveDocument(IDocument slave) {
        ISlaveDocumentManager manager = this.getSlaveDocumentManager();
        if (manager != null && manager.isSlaveDocument(slave)) {
            manager.freeSlaveDocument(slave);
        }
    }

    protected ISlaveDocumentManager getSlaveDocumentManager() {
        if (this.fSlaveDocumentManager == null) {
            this.fSlaveDocumentManager = this.createSlaveDocumentManager();
        }
        return this.fSlaveDocumentManager;
    }

    protected ISlaveDocumentManager createSlaveDocumentManager() {
        return new ChildDocumentManager();
    }

    protected void initializeDocumentInformationMapping(IDocument visibleDocument) {
        ISlaveDocumentManager manager = this.getSlaveDocumentManager();
        this.fInformationMapping = manager == null ? null : manager.createMasterSlaveMapping(visibleDocument);
    }

    protected void inputChanged(Object newInput, Object oldInput) {
        IDocument newDocument;
        IDocumentExtension4 document;
        IDocument oldDocument = (IDocument)oldInput;
        if (oldDocument != null) {
            if (this.fMarkPosition != null && !this.fMarkPosition.isDeleted()) {
                oldDocument.removePosition(this.fMarkPosition);
            }
            try {
                oldDocument.removePositionUpdater(this.fMarkPositionUpdater);
                oldDocument.removePositionCategory(this.MARK_POSITION_CATEGORY);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
        this.fMarkPosition = null;
        if (oldDocument instanceof IDocumentExtension4) {
            document = (IDocumentExtension4)oldDocument;
            document.removeDocumentRewriteSessionListener((IDocumentRewriteSessionListener)this.fDocumentRewriteSessionListener);
        }
        if (newInput instanceof IDocumentExtension4) {
            document = (IDocumentExtension4)newInput;
            document.addDocumentRewriteSessionListener((IDocumentRewriteSessionListener)this.fDocumentRewriteSessionListener);
        }
        if ((newDocument = (IDocument)newInput) != null) {
            newDocument.addPositionCategory(this.MARK_POSITION_CATEGORY);
            newDocument.addPositionUpdater(this.fMarkPositionUpdater);
        }
    }

    private void initializeWidgetContents() {
        if (this.fTextWidget != null && this.fVisibleDocument != null) {
            if (this.fDocumentAdapter == null) {
                this.fDocumentAdapter = this.createDocumentAdapter();
            }
            this.fDocumentAdapter.setDocument(this.fVisibleDocument);
            this.fTextWidget.setContent((StyledTextContent)this.fDocumentAdapter);
            System.err.println(this.fDocumentAdapter);
            this.invalidateTextPresentation();
        }
    }

    protected IDocumentAdapter createDocumentAdapter() {
        return new DefaultDocumentAdapter();
    }

    @Override
    public final void invalidateTextPresentation() {
        if (this.fVisibleDocument != null) {
            this.fWidgetCommand.event = null;
            this.fWidgetCommand.start = 0;
            this.fWidgetCommand.length = this.fVisibleDocument.getLength();
            this.fWidgetCommand.text = this.fVisibleDocument.get();
            this.updateTextListeners(this.fWidgetCommand);
        }
    }

    protected void updateTextListeners(WidgetCommand cmd) {
        ArrayList textListeners = this.fTextListeners;
        if (textListeners != null) {
            textListeners = new ArrayList(textListeners);
            DocumentEvent event = cmd.event;
            if (event instanceof SlaveDocumentEvent) {
                event = ((SlaveDocumentEvent)event).getMasterEvent();
            }
            TextEvent e = new TextEvent(cmd.start, cmd.length, cmd.text, cmd.preservedText, event, this.redraws());
            int i = 0;
            while (i < textListeners.size()) {
                ITextListener l = (ITextListener)textListeners.get(i);
                l.textChanged(e);
                ++i;
            }
        }
    }

    protected final boolean redraws() {
        return this.fRedrawCounter <= 0;
    }

    protected void handleVisibleDocumentAboutToBeChanged(DocumentEvent event) {
    }

    protected void handleVisibleDocumentChanged(DocumentEvent event) {
    }

    @Override
    public void addTextListener(ITextListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fTextListeners == null) {
            this.fTextListeners = new ArrayList();
        }
        if (!this.fTextListeners.contains(listener)) {
            this.fTextListeners.add(listener);
        }
    }

    @Override
    public void removeTextListener(ITextListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fTextListeners != null) {
            this.fTextListeners.remove(listener);
            if (this.fTextListeners.size() == 0) {
                this.fTextListeners = null;
            }
        }
    }

    @Override
    public void addTextInputListener(ITextInputListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fTextInputListeners == null) {
            this.fTextInputListeners = new ArrayList();
        }
        if (!this.fTextInputListeners.contains(listener)) {
            this.fTextInputListeners.add(listener);
        }
    }

    @Override
    public void removeTextInputListener(ITextInputListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fTextInputListeners != null) {
            this.fTextInputListeners.remove(listener);
            if (this.fTextInputListeners.size() == 0) {
                this.fTextInputListeners = null;
            }
        }
    }

    @Override
    public void changeTextPresentation(TextPresentation presentation, boolean controlRedraw) {
        if (presentation == null || !this.redraws()) {
            return;
        }
        if (this.fTextWidget == null) {
            return;
        }
        if (this.fTextPresentationListeners != null) {
            ArrayList listeners = new ArrayList(this.fTextPresentationListeners);
            int i = 0;
            int size = listeners.size();
            while (i < size) {
                ITextPresentationListener listener = (ITextPresentationListener)listeners.get(i);
                listener.applyTextPresentation(presentation);
                ++i;
            }
        }
        if (presentation.isEmpty()) {
            return;
        }
        if (this.fReplaceTextPresentation) {
            this.applyTextPresentation(presentation);
        } else {
            this.addPresentation(presentation);
        }
    }

    private void addPresentation(TextPresentation presentation) {
        StyleRange range = presentation.getDefaultStyleRange();
        if (range != null) {
            if ((range = this.modelStyleRange2WidgetStyleRange(range)) != null) {
                this.fTextWidget.setStyleRange(range);
            }
            ArrayList<StyleRange> ranges = new ArrayList<StyleRange>(presentation.getDenumerableRanges());
            Iterator e = presentation.getNonDefaultStyleRangeIterator();
            while (e.hasNext()) {
                range = (StyleRange)e.next();
                if ((range = this.modelStyleRange2WidgetStyleRange(range)) == null) continue;
                ranges.add(range);
            }
            if (!ranges.isEmpty()) {
                this.fTextWidget.replaceStyleRanges(0, 0, ranges.toArray(new StyleRange[ranges.size()]));
            }
        } else {
            IRegion region = this.modelRange2WidgetRange(presentation.getCoverage());
            if (region == null) {
                return;
            }
            ArrayList<StyleRange> list = new ArrayList<StyleRange>(presentation.getDenumerableRanges());
            Iterator e = presentation.getAllStyleRangeIterator();
            while (e.hasNext()) {
                range = (StyleRange)e.next();
                if ((range = this.modelStyleRange2WidgetStyleRange(range)) == null) continue;
                list.add(range);
            }
            if (!list.isEmpty()) {
                StyleRange[] ranges = new StyleRange[list.size()];
                list.toArray(ranges);
                this.fTextWidget.replaceStyleRanges(region.getOffset(), region.getLength(), ranges);
            }
        }
    }

    private void applyTextPresentation(TextPresentation presentation) {
        ArrayList<StyleRange> list = new ArrayList<StyleRange>(presentation.getDenumerableRanges());
        Iterator e = presentation.getAllStyleRangeIterator();
        while (e.hasNext()) {
            StyleRange range = (StyleRange)e.next();
            if ((range = this.modelStyleRange2WidgetStyleRange(range)) == null) continue;
            list.add(range);
        }
        if (!list.isEmpty()) {
            StyleRange[] ranges = new StyleRange[list.size()];
            list.toArray(ranges);
            this.fTextWidget.setStyleRanges(ranges);
        }
    }

    protected StyleRange modelStyleRange2WidgetStyleRange(StyleRange range) {
        IRegion region = this.modelRange2WidgetRange((IRegion)new Region(range.start, range.length));
        if (region != null) {
            StyleRange result = (StyleRange)range.clone();
            result.start = region.getOffset();
            result.length = region.getLength();
            return result;
        }
        return null;
    }

    public IRegion modelRange2WidgetRange(IRegion modelRange) {
        if (this.fInformationMapping == null) {
            return modelRange;
        }
        try {
            Region reversed;
            IRegion result;
            if (modelRange.getLength() < 0 && (result = this.fInformationMapping.toImageRegion((IRegion)(reversed = new Region(modelRange.getOffset() + modelRange.getLength(), -modelRange.getLength())))) != null) {
                return new Region(result.getOffset() + result.getLength(), -result.getLength());
            }
            return this.fInformationMapping.toImageRegion(modelRange);
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    public IRewriteTarget getRewriteTarget() {
        if (this.fRewriteTarget == null) {
            this.fRewriteTarget = new RewriteTarget();
        }
        return this.fRewriteTarget;
    }

    public final void setRedraw(boolean redraw) {
    }

    @Override
    public void setVisibleRegion(int start, int length) {
        IRegion region = this.getVisibleRegion();
        if (start == region.getOffset() && length == region.getLength()) {
            return;
        }
        this.setRedraw(false);
        try {
            try {
                IDocument slaveDocument = this.createSlaveDocument(this.getVisibleDocument());
                if (this.updateSlaveDocument(slaveDocument, start, length)) {
                    this.setVisibleDocument(slaveDocument);
                }
            }
            catch (BadLocationException badLocationException) {
                throw new IllegalArgumentException("TextViewer.error.invalid_visible_region_2");
            }
        }
        finally {
            this.setRedraw(true);
        }
    }

    @Override
    public void resetVisibleRegion() {
        IDocument slave;
        IDocument master;
        ISlaveDocumentManager manager = this.getSlaveDocumentManager();
        if (manager != null && (master = manager.getMasterDocument(slave = this.getVisibleDocument())) != null) {
            this.setVisibleDocument(master);
            manager.freeSlaveDocument(slave);
        }
    }

    @Override
    public boolean overlapsWithVisibleRegion(int start, int length) {
        IDocument document = this.getVisibleDocument();
        if (document instanceof ChildDocument) {
            ChildDocument cdoc = (ChildDocument)document;
            return cdoc.getParentDocumentRange().overlapsWith(start, length);
        }
        if (document != null) {
            int size = document.getLength();
            return start >= 0 && length >= 0 && start + length <= size;
        }
        return false;
    }

    @Override
    public final void invalidateTextPresentation(int offset, int length) {
        IRegion widgetRange;
        if (this.fVisibleDocument != null && (widgetRange = this.modelRange2WidgetRange((IRegion)new Region(offset, length))) != null) {
            this.fWidgetCommand.event = null;
            this.fWidgetCommand.start = widgetRange.getOffset();
            this.fWidgetCommand.length = widgetRange.getLength();
            try {
                this.fWidgetCommand.text = this.fVisibleDocument.get(widgetRange.getOffset(), widgetRange.getLength());
                this.updateTextListeners(this.fWidgetCommand);
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    @Override
    public void addTextPresentationListener(ITextPresentationListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fTextPresentationListeners == null) {
            this.fTextPresentationListeners = new ArrayList();
        }
        if (!this.fTextPresentationListeners.contains(listener)) {
            this.fTextPresentationListeners.add(listener);
        }
    }

    @Override
    public void removeTextPresentationListener(ITextPresentationListener listener) {
        Assert.isNotNull((Object)listener);
        if (this.fTextPresentationListeners != null) {
            this.fTextPresentationListeners.remove(listener);
            if (this.fTextPresentationListeners.size() == 0) {
                this.fTextPresentationListeners = null;
            }
        }
    }

    @Override
    public void setTextHover(ITextHover textViewerHover, String contentType, int stateMask) {
        TextHoverKey key = new TextHoverKey(contentType, stateMask);
        if (textViewerHover != null) {
            if (this.fTextHovers == null) {
                this.fTextHovers = new HashMap<TextHoverKey, ITextHover>();
            }
            this.fTextHovers.put(key, textViewerHover);
        } else if (this.fTextHovers != null) {
            this.fTextHovers.remove(key);
        }
        this.ensureHoverControlManagerInstalled();
    }

    @Override
    public void removeTextHovers(String contentType) {
        if (this.fTextHovers == null) {
            return;
        }
        for (TextHoverKey key : new HashSet<TextHoverKey>(this.fTextHovers.keySet())) {
            if (!key.fContentType.equals(contentType)) continue;
            this.fTextHovers.remove(key);
        }
    }

    public ITextHover getTextHover(int offset, int stateMask) {
        if (this.fTextHovers == null) {
            return null;
        }
        IDocument document = this.getDocument();
        if (document == null) {
            return null;
        }
        try {
            String contentType = TextUtilities.getContentType((IDocument)document, (String)this.getDocumentPartitioning(), (int)offset, (boolean)true);
            TextHoverKey key = new TextHoverKey(contentType, stateMask);
            ITextHover textHover = this.fTextHovers.get(key);
            if (textHover == null) {
                key.setStateMask(255);
                textHover = this.fTextHovers.get(key);
            }
            return textHover;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private void ensureHoverControlManagerInstalled() {
        if (this.fTextHovers != null && !this.fTextHovers.isEmpty() && this.fTextHoverManager == null) {
            this.fTextHoverManager = this.createTextHovermanager();
            this.fTextHoverManager.install(this.getTextWidget());
        }
    }

    protected TextViewerHoverManager createTextHovermanager() {
        return new TextViewerHoverManager(this);
    }

    private class DocumentRewriteSessionListener
    implements IDocumentRewriteSessionListener {
        private DocumentRewriteSessionListener() {
        }

        public void documentRewriteSessionChanged(DocumentRewriteSessionEvent event) {
            boolean viewportStabilize;
            IRewriteTarget target = TextViewer.this.getRewriteTarget();
            boolean toggleRedraw = event.getSession().getSessionType() != DocumentRewriteSessionType.UNRESTRICTED_SMALL;
            boolean bl = viewportStabilize = !toggleRedraw;
            if (DocumentRewriteSessionEvent.SESSION_START == event.getChangeType()) {
                if (toggleRedraw) {
                    target.setRedraw(false);
                }
                target.beginCompoundChange();
                if (viewportStabilize && TextViewer.this.fViewerState == null) {
                    TextViewer.this.fViewerState = new ViewerState();
                }
            } else if (DocumentRewriteSessionEvent.SESSION_STOP == event.getChangeType()) {
                if (viewportStabilize && TextViewer.this.fViewerState != null) {
                    TextViewer.this.fViewerState.restore(true);
                    TextViewer.this.fViewerState = null;
                }
                target.endCompoundChange();
                if (toggleRedraw) {
                    target.setRedraw(true);
                }
            }
        }
    }

    class RewriteTarget
    implements IRewriteTarget {
        RewriteTarget() {
        }

        @Override
        public void beginCompoundChange() {
        }

        @Override
        public void endCompoundChange() {
        }

        @Override
        public IDocument getDocument() {
            return TextViewer.this.getDocument();
        }

        @Override
        public void setRedraw(boolean redraw) {
            TextViewer.this.setRedraw(redraw);
        }
    }

    protected class TextHoverKey {
        private String fContentType;
        private int fStateMask;

        protected TextHoverKey(String contentType, int stateMask) {
            Assert.isNotNull((Object)contentType);
            this.fContentType = contentType;
            this.fStateMask = stateMask;
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            TextHoverKey textHoverKey = (TextHoverKey)obj;
            return textHoverKey.fContentType.equals(this.fContentType) && textHoverKey.fStateMask == this.fStateMask;
        }

        public int hashCode() {
            return this.fStateMask << 16 | this.fContentType.hashCode();
        }

        private void setStateMask(int stateMask) {
            this.fStateMask = stateMask;
        }
    }

    private final class ViewerState {
        private ViewerState() {
        }

        public void restore(boolean restoreViewport) {
        }
    }

    class VisibleDocumentListener
    implements IDocumentListener {
        VisibleDocumentListener() {
        }

        public void documentAboutToBeChanged(DocumentEvent e) {
            if (e.getDocument() == TextViewer.this.getVisibleDocument()) {
                TextViewer.this.fWidgetCommand.setEvent(e);
            }
            TextViewer.this.handleVisibleDocumentAboutToBeChanged(e);
        }

        public void documentChanged(DocumentEvent e) {
            if (((TextViewer)TextViewer.this).fWidgetCommand.event == e) {
                TextViewer.this.updateTextListeners(TextViewer.this.fWidgetCommand);
            }
            TextViewer.this.fLastSentSelectionChange = null;
            TextViewer.this.handleVisibleDocumentChanged(e);
        }
    }

    protected class WidgetCommand {
        public DocumentEvent event;
        public int start;
        public int length;
        public String text;
        public String preservedText;

        protected WidgetCommand() {
        }

        public void setEvent(DocumentEvent e) {
            block6: {
                this.event = e;
                this.start = e.getOffset();
                this.length = e.getLength();
                this.text = e.getText();
                if (this.length != 0) {
                    try {
                        if (e instanceof SlaveDocumentEvent) {
                            SlaveDocumentEvent slave = (SlaveDocumentEvent)e;
                            DocumentEvent master = slave.getMasterEvent();
                            if (master != null) {
                                this.preservedText = master.getDocument().get(master.getOffset(), master.getLength());
                            }
                            break block6;
                        }
                        this.preservedText = e.getDocument().get(e.getOffset(), e.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        this.preservedText = null;
                    }
                } else {
                    this.preservedText = null;
                }
            }
        }
    }
}

