/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.di.context.internal;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.fx.core.Callback;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.adapter.AdapterProvider;
import org.eclipse.fx.core.adapter.AdapterService;
import org.eclipse.fx.core.di.ContextBoundValue;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.component.annotations.Component;

@Component
public class ObservableAdapterProvider
implements AdapterProvider<ContextBoundValue, IObservableValue> {
    public Class<ContextBoundValue> getSourceType() {
        return ContextBoundValue.class;
    }

    public Class<IObservableValue> getTargetType() {
        return IObservableValue.class;
    }

    public boolean canAdapt(ContextBoundValue sourceObject, Class<IObservableValue> targetType) {
        return true;
    }

    public IObservableValue adapt(ContextBoundValue sourceObject, Class<IObservableValue> targetType, AdapterService.ValueAccess ... valueAccess) {
        Realm r = null;
        AdapterService.ValueAccess[] valueAccessArray = valueAccess;
        int n = valueAccess.length;
        int n2 = 0;
        while (n2 < n) {
            AdapterService.ValueAccess a = valueAccessArray[n2];
            r = (Realm)a.getValue(Realm.class);
            if (r != null) break;
            ++n2;
        }
        if (r == null) {
            r = Realm.getDefault();
        }
        if (r == null) {
            r = new Realm(){

                public boolean isCurrent() {
                    return true;
                }
            };
        }
        ContextBoundObservableValue w = new ContextBoundObservableValue(r, sourceObject);
        sourceObject.subscribeOnDispose((Callback)new Callback<Void>((IObservableValue)w){
            private final /* synthetic */ IObservableValue val$w;
            {
                this.val$w = iObservableValue;
            }

            public void call(Void value) {
                this.val$w.dispose();
            }
        });
        return w;
    }

    private static class ContextBoundObservableValue
    extends AbstractObservableValue {
        private ContextBoundValue sourceObject;
        private Object valueType;
        private Subscription currentSubscription;

        public ContextBoundObservableValue(Realm realm, ContextBoundValue boundValue) {
            this(realm, boundValue, null);
        }

        public ContextBoundObservableValue(Realm realm, ContextBoundValue boundValue, Object valueType) {
            super(realm);
            this.sourceObject = boundValue;
            this.valueType = valueType;
        }

        public Object getValueType() {
            return this.valueType;
        }

        protected Object doGetValue() {
            return this.sourceObject.getValue();
        }

        protected void doSetValue(Object value) {
            this.sourceObject.publish(value);
        }

        protected void firstListenerAdded() {
            this.currentSubscription = this.sourceObject.subscribeOnValueChange((Callback)new ContextBoundValueChanged());
        }

        protected void lastListenerRemoved() {
            if (this.currentSubscription != null) {
                this.currentSubscription.dispose();
                this.currentSubscription = null;
            }
        }

        final class ContextBoundValueChanged
        implements Callback {
            private Object lastValue;

            public ContextBoundValueChanged() {
                this.lastValue = ContextBoundObservableValue.this.doGetValue();
            }

            public void call(@Nullable Object value) {
                ContextBoundObservableValue.this.getRealm().exec(() -> {
                    if (this.lastValue != value) {
                        this.lastValue = value;
                        ContextBoundObservableValue.this.fireValueChange(Diffs.createValueDiff((Object)this.lastValue, (Object)this.lastValue));
                    }
                });
            }
        }
    }
}

