/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui.internal;

import com.google.common.collect.RangeSet;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.scene.text.TextBoundsType;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.text.ui.IFeature;
import org.eclipse.fx.ui.controls.Util;
import org.eclipse.fx.ui.controls.styledtext.StyledTextArea;
import org.eclipse.fx.ui.controls.styledtext.model.Annotation;
import org.eclipse.fx.ui.controls.styledtext.model.AnnotationProvider;
import org.eclipse.fx.ui.controls.styledtext.model.LineRulerAnnotationPresenter;

public class LineNumberSupport
implements IFeature {
    @Override
    public Subscription install(final StyledTextArea control) {
        final LineNrAnnotationPresenter presenter = new LineNrAnnotationPresenter();
        final LineNrAnnotationProvider provider = new LineNrAnnotationProvider();
        DoubleBinding charWidth = Util.createTextWidthBinding((String)"C", (ObservableValue)control.fontProperty(), (ObservableValue)control.fontZoomFactorProperty());
        final DoubleBinding width = Bindings.createDoubleBinding(() -> (double)Integer.toString(control.lineCountProperty().get()).length() * charWidth.get(), (Observable[])new Observable[]{control.lineCountProperty(), charWidth});
        presenter.w.bind((ObservableValue)width);
        control.getAnnotationProvider().add((Object)provider);
        control.getAnnotationPresenter().add((Object)presenter);
        return new Subscription(){

            public void dispose() {
                presenter.w.unbind();
                width.dispose();
                control.getAnnotationProvider().remove((Object)provider);
                control.getAnnotationPresenter().remove((Object)presenter);
            }
        };
    }

    public class LineNrAnnotation
    implements Annotation {
        private final int nr;

        public LineNrAnnotation(int nr) {
            this.nr = nr;
        }

        public int getNr() {
            return this.nr;
        }

        public Object getModel() {
            return this.nr;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.nr;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LineNrAnnotation other = (LineNrAnnotation)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return this.nr == other.nr;
        }

        private LineNumberSupport getOuterType() {
            return LineNumberSupport.this;
        }
    }

    public class LineNrAnnotationPresenter
    implements LineRulerAnnotationPresenter {
        private DoubleProperty w = new SimpleDoubleProperty(16.0);

        public LineRulerAnnotationPresenter.LayoutHint getLayoutHint() {
            return LineRulerAnnotationPresenter.LayoutHint.ALIGN_RIGHT;
        }

        public boolean isApplicable(Annotation annotation) {
            return annotation instanceof LineNrAnnotation;
        }

        public Node createNode() {
            Text node = new Text();
            node.setBoundsType(TextBoundsType.LOGICAL_VERTICAL_CENTER);
            node.getStyleClass().add((Object)"line-ruler-text");
            return new StackPane(new Node[]{node});
        }

        public DoubleProperty getWidth() {
            return this.w;
        }

        public int getOrder() {
            return 10000;
        }

        public boolean isVisible(Set<Annotation> annotation) {
            return true;
        }

        public void updateNode(Node node, Set<Annotation> annotation) {
            Text n = (Text)((Pane)node).getChildren().get(0);
            annotation.stream().findFirst().ifPresent(m -> {
                int nr = ((LineNrAnnotation)m).getNr();
                n.setText("" + nr);
            });
        }

        public String toString() {
            return "LineNrAP@" + this.hashCode();
        }

        public Optional<String> getStyleClass() {
            return Optional.of("line-number-ruler");
        }
    }

    public class LineNrAnnotationProvider
    implements AnnotationProvider {
        public Set<? extends Annotation> computeAnnotations(int index) {
            return Collections.singleton(new LineNrAnnotation(index + 1));
        }

        public Subscription registerChangeListener(Consumer<RangeSet<Integer>> onChange) {
            return new Subscription(){

                public void dispose() {
                }
            };
        }
    }
}

