/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.IProjectConfigurationManager;
import org.eclipse.m2e.core.project.configurator.AbstractProjectConfigurator;
import org.eclipse.m2e.core.project.configurator.ILifecycleMapping;
import org.eclipse.m2e.jdt.IClasspathDescriptor;
import org.eclipse.m2e.jdt.IClasspathEntryDescriptor;
import org.eclipse.m2e.jdt.IClasspathManagerDelegate;
import org.eclipse.m2e.jdt.IJavaProjectConfigurator;
import org.eclipse.m2e.jdt.internal.BuildPathManager;

public class DefaultClasspathManagerDelegate
implements IClasspathManagerDelegate {
    private final IProjectConfigurationManager configurationManager = MavenPlugin.getProjectConfigurationManager();
    private final IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();

    @Override
    public void populateClasspath(IClasspathDescriptor classpath, IMavenProjectFacade projectFacade, int kind, IProgressMonitor monitor) throws CoreException {
        this.addClasspathEntries(classpath, projectFacade, kind, monitor);
        for (IJavaProjectConfigurator configurator : this.getJavaProjectConfigurators(projectFacade, monitor)) {
            configurator.configureClasspath(projectFacade, classpath, monitor);
        }
    }

    private List<IJavaProjectConfigurator> getJavaProjectConfigurators(IMavenProjectFacade projectFacade, IProgressMonitor monitor) throws CoreException {
        ArrayList<IJavaProjectConfigurator> configurators = new ArrayList<IJavaProjectConfigurator>();
        ILifecycleMapping lifecycleMapping = this.configurationManager.getLifecycleMapping(projectFacade);
        if (lifecycleMapping != null) {
            for (AbstractProjectConfigurator configurator : lifecycleMapping.getProjectConfigurators(projectFacade, monitor)) {
                if (!(configurator instanceof IJavaProjectConfigurator)) continue;
                configurators.add((IJavaProjectConfigurator)configurator);
            }
        }
        return configurators;
    }

    void addClasspathEntries(IClasspathDescriptor classpath, IMavenProjectFacade facade, int kind, IProgressMonitor monitor) throws CoreException {
        ArtifactFilter scopeFilter = 1 == kind ? new ArtifactFilter(){

            public boolean include(Artifact artifact) {
                return BuildPathManager.SCOPE_FILTER_RUNTIME.include(artifact) || "provided".equals(artifact.getScope()) || "system".equals(artifact.getScope());
            }
        } : BuildPathManager.SCOPE_FILTER_TEST;
        MavenProject mavenProject = facade.getMavenProject(monitor);
        Set artifacts = mavenProject.getArtifacts();
        HashMap<IPath, ProjectTestAttributes> projectTestAttributes = new HashMap<IPath, ProjectTestAttributes>(artifacts.size());
        for (Artifact a : artifacts) {
            IMavenProjectFacade dependency;
            if (!scopeFilter.include(a) || !a.getArtifactHandler().isAddedToClasspath() || (dependency = this.projectManager.getMavenProject(a.getGroupId(), a.getArtifactId(), a.getBaseVersion())) != null && dependency.getProject().equals((Object)facade.getProject())) continue;
            IClasspathEntryDescriptor entry = null;
            if (dependency != null && dependency.getFullPath(a.getFile()) != null) {
                IPath projectPath = dependency.getFullPath();
                entry = classpath.addProjectEntry(projectPath);
                ProjectTestAttributes testAttributes2 = (ProjectTestAttributes)projectTestAttributes.get(projectPath);
                if (testAttributes2 == null) {
                    testAttributes2 = new ProjectTestAttributes(this.isTestScope(a), !this.isTestArtifact(a));
                    projectTestAttributes.put(projectPath, testAttributes2);
                } else {
                    testAttributes2.isTest &= this.isTestScope(a);
                    testAttributes2.excludeTestSources = testAttributes2.excludeTestSources & !this.isTestArtifact(a);
                }
            } else {
                File artifactFile = a.getFile();
                if (artifactFile != null) {
                    entry = classpath.addLibraryEntry(Path.fromOSString((String)artifactFile.getAbsolutePath()));
                    entry.setClasspathAttribute("test", this.isTestScope(a) ? "true" : null);
                }
            }
            if (entry == null) continue;
            entry.setArtifactKey(new ArtifactKey(a.getGroupId(), a.getArtifactId(), a.getBaseVersion(), a.getClassifier()));
            entry.setScope(a.getScope());
            entry.setOptionalDependency(a.isOptional());
        }
        projectTestAttributes.forEach((entryPath, testAttributes) -> {
            IClasspathEntryDescriptor descriptor = this.findClasspathDescriptor(classpath, (IPath)entryPath);
            descriptor.setClasspathAttribute("test", testAttributes.isTest ? "true" : null);
            descriptor.setClasspathAttribute("without_test_code", testAttributes.excludeTestSources ? "true" : null);
        });
    }

    private boolean isTestScope(Artifact a) {
        return "test".equals(a.getScope());
    }

    private boolean isTestArtifact(Artifact a) {
        return "tests".equals(a.getClassifier()) || "test-jar".equals(a.getType());
    }

    private IClasspathEntryDescriptor findClasspathDescriptor(IClasspathDescriptor classpath, IPath p) {
        return classpath.getEntryDescriptors().stream().filter(e -> p.equals((Object)e.getPath())).findFirst().orElse(null);
    }

    static class ProjectTestAttributes {
        boolean isTest;
        boolean excludeTestSources;

        ProjectTestAttributes(boolean isTest, boolean excludeTestSources) {
            this.isTest = isTest;
            this.excludeTestSources = excludeTestSources;
        }
    }
}

