/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.base;

import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.fx.ui.workbench.renderers.base.BaseRenderer;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WToolControl;

public abstract class BaseToolControlRenderer<N>
extends BaseRenderer<MToolControl, WToolControl<N>> {
    private static final String LOCAL_CONTEXT = "efx_toolcontrol_context";

    @Override
    protected void doProcessContent(MToolControl element) {
        WToolControl widget = (WToolControl)this.getWidget((MUIElement)element);
        if (widget == null) {
            this.getLogger().error("Could not find widget for '" + element + "'");
            return;
        }
        Class<?> cl = widget.getWidget().getClass();
        IEclipseContext modelContext = this.getModelContext((MUIElement)element);
        if (modelContext == null) {
            this.getLogger().error("The model context is null - impossible to proceed");
            return;
        }
        IEclipseContext context = modelContext.createChild("ToolControl");
        context.set(MToolControl.class, (Object)element);
        do {
            context.set(cl.getName(), widget.getWidget());
        } while (!(cl = cl.getSuperclass()).getName().equals("java.lang.Object"));
        BaseToolControlRenderer.populateModelInterfaces(element, context, MToolControl.class);
        IContributionFactory contributionFactory = (IContributionFactory)context.get(IContributionFactory.class.getName());
        Object newPart = contributionFactory.create(element.getContributionURI(), context);
        element.setObject(newPart);
        element.getTransientData().put(LOCAL_CONTEXT, context);
    }

    public void childRendered(MToolControl parentElement, MUIElement element) {
    }

    public void hideChild(MToolControl container, MUIElement changedObj) {
    }

    @Override
    public void destroyWidget(MToolControl element) {
        super.destroyWidget(element);
        IEclipseContext local = (IEclipseContext)element.getTransientData().get(LOCAL_CONTEXT);
        if (local != null) {
            local.dispose();
            element.getTransientData().remove(LOCAL_CONTEXT);
        }
    }
}

