/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.code.editor.ldef.generator;

import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fx.code.editor.ldef.lDef.Check;
import org.eclipse.fx.code.editor.ldef.lDef.Codegeneration;
import org.eclipse.fx.code.editor.ldef.lDef.ConfigValue;
import org.eclipse.fx.code.editor.ldef.lDef.E4CodeGeneration;
import org.eclipse.fx.code.editor.ldef.lDef.Equals;
import org.eclipse.fx.code.editor.ldef.lDef.JavaCodeGeneration;
import org.eclipse.fx.code.editor.ldef.lDef.JavaFXIntegration;
import org.eclipse.fx.code.editor.ldef.lDef.Keyword;
import org.eclipse.fx.code.editor.ldef.lDef.LanguageDef;
import org.eclipse.fx.code.editor.ldef.lDef.LexicalPartitionHighlighting;
import org.eclipse.fx.code.editor.ldef.lDef.LexicalPartitionHighlighting_Rule;
import org.eclipse.fx.code.editor.ldef.lDef.Partition_MultiLineRule;
import org.eclipse.fx.code.editor.ldef.lDef.Partition_Rule;
import org.eclipse.fx.code.editor.ldef.lDef.Partition_SingleLineRule;
import org.eclipse.fx.code.editor.ldef.lDef.Partitioner;
import org.eclipse.fx.code.editor.ldef.lDef.Partitioner_Rule;
import org.eclipse.fx.code.editor.ldef.lDef.Range;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_CharacterRule;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_Keyword;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_MultiLineRule;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_PatternRule;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_Rule;
import org.eclipse.fx.code.editor.ldef.lDef.Scanner_SingleLineRule;
import org.eclipse.fx.code.editor.ldef.lDef.Token;
import org.eclipse.fx.code.editor.ldef.lDef.WhitespaceRule;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class JavaFXCodeGenerator {
    public Object generate(LanguageDef model, IFileSystemAccess access) {
        boolean _notEquals;
        Object _xblockexpression = null;
        JavaFXIntegration javaFXIntegration = (JavaFXIntegration)IterableExtensions.head((Iterable)Iterables.filter(model.getIntegration().getCodeIntegrationList(), JavaFXIntegration.class));
        Object _xifexpression = null;
        boolean bl = _notEquals = !Objects.equals(javaFXIntegration, null);
        if (_notEquals) {
            boolean _notEquals_2;
            boolean _notEquals_1;
            Object _xblockexpression_1 = null;
            JavaCodeGeneration javaCodeGen = (JavaCodeGeneration)IterableExtensions.head((Iterable)Iterables.filter(javaFXIntegration.getCodegenerationList(), JavaCodeGeneration.class));
            boolean bl2 = _notEquals_1 = !Objects.equals(javaCodeGen, null);
            if (_notEquals_1) {
                String project = this.findProjectResource(javaCodeGen);
                Object _xifexpression_1 = null;
                boolean _equals = Objects.equals(project, null);
                _xifexpression_1 = _equals ? "" : "/" + project + "/src/";
                Object prefix = _xifexpression_1;
                String basePackage = javaCodeGen.getName();
                String _replace = basePackage.replace(".", "/");
                String _plus = (String)prefix + _replace;
                String _plus_1 = _plus + "/";
                String _firstUpper = StringExtensions.toFirstUpper((String)model.getName());
                String _plus_2 = _plus_1 + _firstUpper;
                String _plus_3 = _plus_2 + "PartitionScanner.java";
                access.generateFile(_plus_3, this.generateRulePartitioner(model, basePackage));
                String _replace_1 = basePackage.replace(".", "/");
                String _plus_4 = (String)prefix + _replace_1;
                String _plus_5 = _plus_4 + "/";
                String _firstUpper_1 = StringExtensions.toFirstUpper((String)model.getName());
                String _plus_6 = _plus_5 + _firstUpper_1;
                String _plus_7 = _plus_6 + "Partitioner.java";
                access.generateFile(_plus_7, this.generatePartitioner(model, basePackage));
                String _replace_2 = basePackage.replace(".", "/");
                String _plus_8 = (String)prefix + _replace_2;
                String _plus_9 = _plus_8 + "/";
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)model.getName());
                String _plus_10 = _plus_9 + _firstUpper_2;
                String _plus_11 = _plus_10 + "PresentationReconciler.java";
                access.generateFile(_plus_11, this.generatePresentationReconciler(model, basePackage));
                EList<LexicalPartitionHighlighting> _list = model.getLexicalHighlighting().getList();
                for (LexicalPartitionHighlighting h : _list) {
                    if (!(h instanceof LexicalPartitionHighlighting_Rule)) continue;
                    String _replace_3 = basePackage.replace(".", "/");
                    String _plus_12 = (String)prefix + _replace_3;
                    String _plus_13 = _plus_12 + "/";
                    String _firstUpper_3 = StringExtensions.toFirstUpper((String)model.getName());
                    String _plus_14 = _plus_13 + _firstUpper_3;
                    String _name = ((LexicalPartitionHighlighting_Rule)h).getPartition().getName();
                    String _plus_15 = _plus_14 + _name;
                    String _plus_16 = _plus_15 + ".java";
                    access.generateFile(_plus_16, this.generateScanner(model, (LexicalPartitionHighlighting_Rule)h, basePackage));
                }
            }
            E4CodeGeneration e4CodeGen = (E4CodeGeneration)IterableExtensions.head((Iterable)Iterables.filter(javaFXIntegration.getCodegenerationList(), E4CodeGeneration.class));
            Object _xifexpression_2 = null;
            boolean bl3 = _notEquals_2 = !Objects.equals(e4CodeGen, null);
            if (_notEquals_2) {
                boolean _notEquals_3;
                Object _xifexpression_3 = null;
                boolean bl4 = _notEquals_3 = !Objects.equals(javaCodeGen, null);
                if (_notEquals_3) {
                    String basePackage_1 = e4CodeGen.getName();
                    String javaBasePackage = javaCodeGen.getName();
                    String project_1 = this.findProjectResource(e4CodeGen);
                    Object _xifexpression_4 = null;
                    boolean _equals_1 = Objects.equals(project_1, null);
                    _xifexpression_4 = _equals_1 ? "" : "/" + project_1 + "/src/";
                    Object prefix_1 = _xifexpression_4;
                    String _replace_4 = basePackage_1.replace(".", "/");
                    String _plus_17 = (String)prefix_1 + _replace_4;
                    String _plus_18 = _plus_17 + "/";
                    String _firstUpper_4 = StringExtensions.toFirstUpper((String)model.getName());
                    String _plus_19 = _plus_18 + _firstUpper_4;
                    String _plus_20 = _plus_19 + "DocumentPartitionerTypeProvider.java";
                    access.generateFile(_plus_20, this.generateDocumentPartitionerTypeProvider(model, basePackage_1, javaBasePackage));
                    String _replace_5 = basePackage_1.replace(".", "/");
                    String _plus_21 = (String)prefix_1 + _replace_5;
                    String _plus_22 = _plus_21 + "/";
                    String _firstUpper_5 = StringExtensions.toFirstUpper((String)model.getName());
                    String _plus_23 = _plus_22 + _firstUpper_5;
                    String _plus_24 = _plus_23 + "PresentationReconcilerTypeProvider.java";
                    access.generateFile(_plus_24, this.generatePresentationReconcilerTypeProvider(model, basePackage_1, javaBasePackage));
                } else {
                    _xifexpression_3 = null;
                }
                _xifexpression_2 = _xifexpression_3;
            }
            _xifexpression = _xblockexpression_1 = _xifexpression_2;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String findProjectResource(Codegeneration codeGen) {
        Functions.Function1 _function = it -> {
            String _key = it.getKey();
            return Objects.equals(_key, "project");
        };
        ConfigValue _findFirst = (ConfigValue)IterableExtensions.findFirst(codeGen.getConfigValue(), (Functions.Function1)_function);
        String _simpleValue = null;
        if (_findFirst != null) {
            _simpleValue = _findFirst.getSimpleValue();
        }
        return _simpleValue;
    }

    public CharSequence generateDocumentPartitionerTypeProvider(LanguageDef model, String basePackage, String javaBasePackage) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        _builder.append(basePackage);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("@org.osgi.service.component.annotations.Component");
        _builder.newLine();
        _builder.append("public class ");
        String _firstUpper = StringExtensions.toFirstUpper((String)model.getName());
        _builder.append(_firstUpper);
        _builder.append("DocumentPartitionerTypeProvider implements org.eclipse.fx.code.editor.services.DocumentPartitionerTypeProvider {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public Class<? extends org.eclipse.jface.text.IDocumentPartitioner> getType(org.eclipse.fx.code.editor.Input<?> s) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return ");
        _builder.append(javaBasePackage, "\t\t");
        _builder.append(".");
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)model.getName());
        _builder.append(_firstUpper_1, "\t\t");
        _builder.append("Partitioner.class;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public boolean test(org.eclipse.fx.code.editor.Input<?> t) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return (t instanceof org.eclipse.fx.code.editor.services.URIProvider) && ((org.eclipse.fx.code.editor.services.URIProvider)t).getURI().toString().endsWith(\".");
        String _name = model.getName();
        _builder.append(_name, "\t\t");
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatePresentationReconcilerTypeProvider(LanguageDef model, String basePackage, String javaBasePackage) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        _builder.append(basePackage);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("@org.osgi.service.component.annotations.Component");
        _builder.newLine();
        _builder.append("public class ");
        String _firstUpper = StringExtensions.toFirstUpper((String)model.getName());
        _builder.append(_firstUpper);
        _builder.append("PresentationReconcilerTypeProvider implements org.eclipse.fx.code.editor.fx.services.PresentationReconcilerTypeProvider {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public Class<? extends org.eclipse.fx.text.ui.presentation.PresentationReconciler> getType(org.eclipse.fx.code.editor.Input<?> s) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return ");
        _builder.append(javaBasePackage, "\t\t");
        _builder.append(".");
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)model.getName());
        _builder.append(_firstUpper_1, "\t\t");
        _builder.append("PresentationReconciler.class;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public boolean test(org.eclipse.fx.code.editor.Input<?> t) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return (t instanceof org.eclipse.fx.code.editor.services.URIProvider) && ((org.eclipse.fx.code.editor.services.URIProvider)t).getURI().toString().endsWith(\".dart\");");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatePartitioner(LanguageDef model, String basePackage) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        _builder.append(basePackage);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class ");
        String _firstUpper = StringExtensions.toFirstUpper((String)model.getName());
        _builder.append(_firstUpper);
        _builder.append("Partitioner extends org.eclipse.jface.text.rules.FastPartitioner {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public ");
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)model.getName());
        _builder.append(_firstUpper_1, "\t");
        _builder.append("Partitioner() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("super(new ");
        String _firstUpper_2 = StringExtensions.toFirstUpper((String)model.getName());
        _builder.append(_firstUpper_2, "\t\t");
        _builder.append("PartitionScanner(), new String[] {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        Functions.Function1 _function = it -> it.getName();
        Functions.Function1 _function_1 = it -> {
            boolean _equals = it.equals("__dftl_partition_content_type");
            return !_equals;
        };
        Functions.Function1 _function_2 = it -> "\"" + it + "\"";
        String _join = IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)ListExtensions.map(model.getParitioning().getPartitions(), (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2), (CharSequence)",");
        _builder.append(_join, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("});");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateRulePartitioner(LanguageDef model, String basePackage) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        _builder.append(basePackage);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class ");
        String _firstUpper = StringExtensions.toFirstUpper((String)model.getName());
        _builder.append(_firstUpper);
        _builder.append("PartitionScanner extends org.eclipse.jface.text.rules.RuleBasedPartitionScanner {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public ");
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)model.getName());
        _builder.append(_firstUpper_1, "\t");
        _builder.append("PartitionScanner() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("org.eclipse.jface.text.rules.IPredicateRule[] pr = new org.eclipse.jface.text.rules.IPredicateRule[");
        Partitioner _partitioner = model.getParitioning().getPartitioner();
        int _size = ((Partitioner_Rule)_partitioner).getRuleList().size();
        _builder.append((Object)_size, "\t\t");
        _builder.append("];");
        _builder.newLineIfNotEmpty();
        Partitioner _partitioner_1 = model.getParitioning().getPartitioner();
        Iterable _indexed = IterableExtensions.indexed(((Partitioner_Rule)_partitioner_1).getRuleList());
        for (Pair r : _indexed) {
            _builder.append("\t\t");
            _builder.append("pr[");
            Integer _key = (Integer)r.getKey();
            _builder.append((Object)_key, "\t\t");
            _builder.append("] = ");
            CharSequence _generatePartitionRule = this.generatePartitionRule((Partition_Rule)r.getValue());
            _builder.append((Object)_generatePartitionRule, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("setPredicateRules(pr);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generatePresentationReconciler(LanguageDef model, String basePackage) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        _builder.append(basePackage);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class ");
        String _firstUpper = StringExtensions.toFirstUpper((String)model.getName());
        _builder.append(_firstUpper);
        _builder.append("PresentationReconciler extends org.eclipse.fx.text.ui.presentation.PresentationReconciler {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public ");
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)model.getName());
        _builder.append(_firstUpper_1, "\t");
        _builder.append("PresentationReconciler() {");
        _builder.newLineIfNotEmpty();
        EList<LexicalPartitionHighlighting> _list = model.getLexicalHighlighting().getList();
        for (LexicalPartitionHighlighting h : _list) {
            if (h instanceof LexicalPartitionHighlighting_Rule) {
                _builder.append("\t\t");
                _builder.append("org.eclipse.fx.text.ui.rules.DefaultDamagerRepairer ");
                String _name = ((LexicalPartitionHighlighting_Rule)h).getPartition().getName();
                _builder.append(_name, "\t\t");
                _builder.append("DamageRepairer = new org.eclipse.fx.text.ui.rules.DefaultDamagerRepairer(new ");
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)model.getName());
                _builder.append(_firstUpper_2, "\t\t");
                String _name_1 = ((LexicalPartitionHighlighting_Rule)h).getPartition().getName();
                _builder.append(_name_1, "\t\t");
                _builder.append("());");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t\t");
                _builder.append("//FIXME Need to generate JS-Damager");
                _builder.newLine();
            }
            _builder.append("\t\t");
            _builder.append("setDamager(");
            String _name_2 = h.getPartition().getName();
            _builder.append(_name_2, "\t\t");
            _builder.append("DamageRepairer, \"");
            String _name_3 = h.getPartition().getName();
            _builder.append(_name_3, "\t\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("setRepairer(");
            String _name_4 = h.getPartition().getName();
            _builder.append(_name_4, "\t\t");
            _builder.append("DamageRepairer, \"");
            String _name_5 = h.getPartition().getName();
            _builder.append(_name_5, "\t\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateScanner(LanguageDef model, LexicalPartitionHighlighting_Rule highlighter, String basePackage) {
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("package ");
        _builder.append(basePackage);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("public class ");
        String _firstUpper = StringExtensions.toFirstUpper((String)model.getName());
        _builder.append(_firstUpper);
        String _name = highlighter.getPartition().getName();
        _builder.append(_name);
        _builder.append(" extends org.eclipse.jface.text.rules.RuleBasedScanner {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("public ");
        String _firstUpper_1 = StringExtensions.toFirstUpper((String)model.getName());
        _builder.append(_firstUpper_1, "\t");
        String _name_1 = highlighter.getPartition().getName();
        _builder.append(_name_1, "\t");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        EList<Token> _tokenList = highlighter.getTokenList();
        for (Token t : _tokenList) {
            _builder.append("\t\t");
            _builder.append("org.eclipse.jface.text.rules.Token ");
            String _name_2 = t.getName();
            _builder.append(_name_2, "\t\t");
            _builder.append("Token = new org.eclipse.jface.text.rules.Token(new org.eclipse.fx.text.ui.TextAttribute(\"");
            String _name_3 = model.getName();
            _builder.append(_name_3, "\t\t");
            _builder.append(".");
            String _name_4 = t.getName();
            _builder.append(_name_4, "\t\t");
            _builder.append("\"));");
            _builder.newLineIfNotEmpty();
            boolean _isDefault = t.isDefault();
            if (!_isDefault) continue;
            _builder.append("\t\t");
            _builder.append("setDefaultReturnToken(");
            String _name_5 = t.getName();
            _builder.append(_name_5, "\t\t");
            _builder.append("Token);");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("org.eclipse.jface.text.rules.IRule[] rules = new org.eclipse.jface.text.rules.IRule[");
        int _addWhitespaceRule = JavaFXCodeGenerator.addWhitespaceRule(JavaFXCodeGenerator.addKeywordGroup(JavaFXCodeGenerator.countRules(highlighter), highlighter), highlighter.getWhitespace());
        _builder.append((Object)_addWhitespaceRule, "\t\t");
        _builder.append("];");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        int count = 0;
        _builder.newLineIfNotEmpty();
        EList<Token> _tokenList_1 = highlighter.getTokenList();
        for (Token t_1 : _tokenList_1) {
            Functions.Function1 _function = s -> s instanceof Scanner_Rule;
            Iterable _filter = IterableExtensions.filter(t_1.getScannerList(), (Functions.Function1)_function);
            for (Scanner s2 : _filter) {
                _builder.append("\t\t");
                _builder.append("rules[");
                int _plusPlus = count++;
                _builder.append((Object)_plusPlus, "\t\t");
                _builder.append("] = ");
                CharSequence _generateScannerRule = this.generateScannerRule(t_1, (Scanner_Rule)s2);
                _builder.append((Object)_generateScannerRule, "\t\t");
                _builder.newLineIfNotEmpty();
            }
        }
        WhitespaceRule _whitespace = highlighter.getWhitespace();
        boolean bl = _notEquals = !Objects.equals(_whitespace, null);
        if (_notEquals) {
            _builder.append("\t\t");
            _builder.append("rules[");
            int _plusPlus_1 = count++;
            _builder.append((Object)_plusPlus_1, "\t\t");
            _builder.append("] = ");
            CharSequence _generateWhitespaceRule = this.generateWhitespaceRule(highlighter.getWhitespace());
            _builder.append((Object)_generateWhitespaceRule, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        boolean _hasKeywordGroup = JavaFXCodeGenerator.hasKeywordGroup(highlighter);
        if (_hasKeywordGroup) {
            _builder.append("\t\t");
            _builder.append("org.eclipse.fx.text.rules.JavaLikeWordDetector wordDetector= new org.eclipse.fx.text.rules.JavaLikeWordDetector();");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("org.eclipse.fx.text.rules.CombinedWordRule combinedWordRule= new org.eclipse.fx.text.rules.CombinedWordRule(wordDetector, ");
            Functions.Function1 _function_1 = t_2 -> t_2.isDefault();
            String _name_6 = ((Token)IterableExtensions.findFirst(highlighter.getTokenList(), (Functions.Function1)_function_1)).getName();
            _builder.append(_name_6, "\t\t");
            _builder.append("Token);");
            _builder.newLineIfNotEmpty();
            EList<Token> _tokenList_2 = highlighter.getTokenList();
            for (Token t_22 : _tokenList_2) {
                Functions.Function1 _function_2 = s_1 -> s_1 instanceof Scanner_Keyword;
                Iterable _filter_1 = IterableExtensions.filter(t_22.getScannerList(), (Functions.Function1)_function_2);
                for (Scanner kw : _filter_1) {
                    _builder.append("\t\t");
                    _builder.append("{");
                    _builder.newLine();
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("org.eclipse.fx.text.rules.CombinedWordRule.WordMatcher ");
                    String _name_7 = t_22.getName();
                    _builder.append(_name_7, "\t\t\t");
                    _builder.append("WordRule = new org.eclipse.fx.text.rules.CombinedWordRule.WordMatcher();");
                    _builder.newLineIfNotEmpty();
                    EList<Keyword> _keywords = ((Scanner_Keyword)kw).getKeywords();
                    for (Keyword w : _keywords) {
                        _builder.append("\t\t");
                        _builder.append("\t");
                        String _name_8 = t_22.getName();
                        _builder.append(_name_8, "\t\t\t");
                        _builder.append("WordRule.addWord(\"");
                        String _name_9 = w.getName();
                        _builder.append(_name_9, "\t\t\t");
                        _builder.append("\", ");
                        String _name_10 = t_22.getName();
                        _builder.append(_name_10, "\t\t\t");
                        _builder.append("Token);");
                        _builder.newLineIfNotEmpty();
                    }
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append("combinedWordRule.addWordMatcher(");
                    String _name_11 = t_22.getName();
                    _builder.append(_name_11, "\t\t\t");
                    _builder.append("WordRule);");
                    _builder.newLineIfNotEmpty();
                    _builder.append("\t\t");
                    _builder.append("}");
                    _builder.newLine();
                }
            }
            _builder.append("\t\t");
            _builder.append("rules[");
            int _plusPlus_2 = count++;
            _builder.append((Object)_plusPlus_2, "\t\t");
            _builder.append("] = combinedWordRule;");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("setRules(rules);");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public static boolean hasKeywordGroup(LexicalPartitionHighlighting_Rule highlighter) {
        EList<Token> _tokenList = highlighter.getTokenList();
        for (Token t : _tokenList) {
            boolean _notEquals;
            Functions.Function1 _function = s -> s instanceof Scanner_Keyword;
            Scanner _head = (Scanner)IterableExtensions.head((Iterable)IterableExtensions.filter(t.getScannerList(), (Functions.Function1)_function));
            boolean bl = _notEquals = !Objects.equals(_head, null);
            if (!_notEquals) continue;
            return true;
        }
        return false;
    }

    public static int addKeywordGroup(int count, LexicalPartitionHighlighting_Rule highlighter) {
        EList<Token> _tokenList = highlighter.getTokenList();
        for (Token t : _tokenList) {
            boolean _notEquals;
            Functions.Function1 _function = s -> s instanceof Scanner_Keyword;
            Scanner _head = (Scanner)IterableExtensions.head((Iterable)IterableExtensions.filter(t.getScannerList(), (Functions.Function1)_function));
            boolean bl = _notEquals = !Objects.equals(_head, null);
            if (!_notEquals) continue;
            return count + 1;
        }
        return count;
    }

    public static int addWhitespaceRule(int count, WhitespaceRule r) {
        boolean _notEquals;
        boolean bl = _notEquals = !Objects.equals(r, null);
        if (_notEquals) {
            return count + 1;
        }
        return count;
    }

    public static int countRules(LexicalPartitionHighlighting_Rule highlighter) {
        int c = 0;
        EList<Token> _tokenList = highlighter.getTokenList();
        for (Token t : _tokenList) {
            int _c = c;
            Functions.Function1 _function = s -> s instanceof Scanner_Rule;
            int _length = ((Object[])Conversions.unwrapArray((Object)IterableExtensions.filter(t.getScannerList(), (Functions.Function1)_function), Object.class)).length;
            c = _c + _length;
        }
        return c;
    }

    protected CharSequence _generateScannerRule(Token t, Scanner_SingleLineRule r) {
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        Check _check = r.getCheck();
        boolean bl = _notEquals = !Objects.equals(_check, null);
        if (_notEquals) {
            _builder.append("new org.eclipse.fx.text.rules.ColumnStartRule(");
        }
        _builder.append("new org.eclipse.jface.text.rules.SingleLineRule(");
        _builder.newLineIfNotEmpty();
        _builder.append("\t  ");
        _builder.append("\"");
        String _escapeString = JavaFXCodeGenerator.escapeString(r.getStartSeq());
        _builder.append(_escapeString, "\t  ");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(", ");
        String _endSeq = r.getEndSeq();
        boolean bl2 = _notEquals_1 = !Objects.equals(_endSeq, null);
        if (_notEquals_1) {
            _builder.append("\"");
            String _escapeString_1 = JavaFXCodeGenerator.escapeString(r.getEndSeq());
            _builder.append(_escapeString_1, "\t");
            _builder.append("\"");
        } else {
            _builder.append("null");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(", ");
        String _name = t.getName();
        _builder.append(_name, "\t");
        _builder.append("Token");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(", ");
        String _escapeSeq = r.getEscapeSeq();
        boolean bl3 = _notEquals_2 = !Objects.equals(_escapeSeq, null);
        if (_notEquals_2) {
            _builder.append("'");
            String _escapeChar = JavaFXCodeGenerator.escapeChar(r.getEscapeSeq());
            _builder.append(_escapeChar, "\t");
            _builder.append("'");
        } else {
            _builder.append("(char)0");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(", ");
        if (Objects.equals(r.getEndSeq(), null) || r.getEndSeq().isEmpty()) {
            _builder.append("true");
        } else {
            _builder.append("false");
        }
        _builder.append(")");
        Check _check_1 = r.getCheck();
        boolean bl4 = _notEquals_3 = !Objects.equals(_check_1, null);
        if (_notEquals_3) {
            _builder.append(",");
            CharSequence _predicate = JavaFXCodeGenerator.toPredicate(r.getCheck());
            _builder.append((Object)_predicate, "\t");
            _builder.append(")");
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateScannerRule(Token t, Scanner_MultiLineRule r) {
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        Check _check = r.getCheck();
        boolean bl = _notEquals = !Objects.equals(_check, null);
        if (_notEquals) {
            _builder.append("new org.eclipse.fx.text.rules.ColumnStartRule(");
        }
        _builder.append("new org.eclipse.jface.text.rules.MultiLineRule(");
        _builder.newLineIfNotEmpty();
        _builder.append("\t  ");
        _builder.append("\"");
        String _escapeString = JavaFXCodeGenerator.escapeString(r.getStartSeq());
        _builder.append(_escapeString, "\t  ");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(", \"");
        String _escapeString_1 = JavaFXCodeGenerator.escapeString(r.getEndSeq());
        _builder.append(_escapeString_1, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(", ");
        String _name = t.getName();
        _builder.append(_name, "\t");
        _builder.append("Token");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(", ");
        String _escapeSeq = r.getEscapeSeq();
        boolean bl2 = _notEquals_1 = !Objects.equals(_escapeSeq, null);
        if (_notEquals_1) {
            _builder.append("'");
            String _escapeChar = JavaFXCodeGenerator.escapeChar(r.getEscapeSeq());
            _builder.append(_escapeChar, "\t");
            _builder.append("'");
        } else {
            _builder.append("(char)0");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(", ");
        if (Objects.equals(r.getEndSeq(), null) || r.getEndSeq().isEmpty()) {
            _builder.append("true");
        } else {
            _builder.append("false");
        }
        _builder.append(")");
        Check _check_1 = r.getCheck();
        boolean bl3 = _notEquals_2 = !Objects.equals(_check_1, null);
        if (_notEquals_2) {
            _builder.append(",");
            CharSequence _predicate = JavaFXCodeGenerator.toPredicate(r.getCheck());
            _builder.append((Object)_predicate, "\t");
            _builder.append(")");
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    public CharSequence generateWhitespaceRule(WhitespaceRule r) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isJavawhitespace = r.isJavawhitespace();
        if (_isJavawhitespace) {
            _builder.append("new org.eclipse.jface.text.rules.WhitespaceRule(Character::isWhitespace);");
            _builder.newLine();
        } else {
            _builder.append("new org.eclipse.jface.text.rules.WhitespaceRule(new org.eclipse.fx.text.rules.FixedCharacterWSDetector(new char[] {");
            Functions.Function1 _function = it -> {
                String _escapeChar = JavaFXCodeGenerator.escapeChar(it);
                String _plus = "'" + _escapeChar;
                return _plus + "'";
            };
            String _join = IterableExtensions.join((Iterable)ListExtensions.map(r.getCharacters(), (Functions.Function1)_function), (CharSequence)",");
            _builder.append(_join);
            _builder.append("}));");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence _generateScannerRule(Token t, Scanner_CharacterRule r) {
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        Check _check = r.getCheck();
        boolean bl = _notEquals = !Objects.equals(_check, null);
        if (_notEquals) {
            _builder.append("new org.eclipse.fx.text.rules.ColumnStartRule(");
        }
        _builder.append("new org.eclipse.fx.text.rules.CharacterRule(");
        String _name = t.getName();
        _builder.append(_name);
        _builder.append("Token, new char[] {");
        Functions.Function1 _function = it -> {
            String _escapeChar = JavaFXCodeGenerator.escapeChar(it);
            String _plus = "'" + _escapeChar;
            return _plus + "'";
        };
        String _join = IterableExtensions.join((Iterable)ListExtensions.map(r.getCharacters(), (Functions.Function1)_function), (CharSequence)",");
        _builder.append(_join);
        _builder.append("})");
        Check _check_1 = r.getCheck();
        boolean bl2 = _notEquals_1 = !Objects.equals(_check_1, null);
        if (_notEquals_1) {
            _builder.append(",");
            CharSequence _predicate = JavaFXCodeGenerator.toPredicate(r.getCheck());
            _builder.append((Object)_predicate);
            _builder.append(")");
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generateScannerRule(Token t, Scanner_PatternRule r) {
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        Check _check = r.getCheck();
        boolean bl = _notEquals = !Objects.equals(_check, null);
        if (_notEquals) {
            _builder.append("new org.eclipse.fx.text.rules.ColumnStartRule(");
        }
        _builder.append("new org.eclipse.fx.text.rules.RegexRule(");
        String _name = t.getName();
        _builder.append(_name);
        _builder.append("Token, java.util.regex.Pattern.compile(\"");
        String _replace = r.getStartPattern().replace("\\", "\\\\");
        _builder.append(_replace);
        _builder.append("\"),");
        int _max = Math.max(1, r.getLength());
        _builder.append((Object)_max);
        _builder.append(",java.util.regex.Pattern.compile(\"");
        String _replace_1 = r.getContentPattern().replace("\\", "\\\\");
        _builder.append(_replace_1);
        _builder.append("\"))");
        Check _check_1 = r.getCheck();
        boolean bl2 = _notEquals_1 = !Objects.equals(_check_1, null);
        if (_notEquals_1) {
            _builder.append(",");
            CharSequence _predicate = JavaFXCodeGenerator.toPredicate(r.getCheck());
            _builder.append((Object)_predicate);
            _builder.append(")");
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generatePartitionRule(Partition_SingleLineRule r) {
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        Check _check = r.getCheck();
        boolean bl = _notEquals = !Objects.equals(_check, null);
        if (_notEquals) {
            _builder.append("new org.eclipse.fx.text.rules.PredicateColumnStartRule(");
        }
        _builder.append("new org.eclipse.jface.text.rules.SingleLineRule(");
        _builder.newLineIfNotEmpty();
        _builder.append("\t  ");
        _builder.append("\"");
        String _escapeString = JavaFXCodeGenerator.escapeString(r.getStartSeq());
        _builder.append(_escapeString, "\t  ");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(", ");
        String _endSeq = r.getEndSeq();
        boolean bl2 = _notEquals_1 = !Objects.equals(_endSeq, null);
        if (_notEquals_1) {
            _builder.append("\"");
            String _escapeString_1 = JavaFXCodeGenerator.escapeString(r.getEndSeq());
            _builder.append(_escapeString_1, "\t");
            _builder.append("\"");
        } else {
            _builder.append("null");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(", new org.eclipse.jface.text.rules.Token(\"");
        String _name = r.getParition().getName();
        _builder.append(_name, "\t");
        _builder.append("\")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(", ");
        String _escapeSeq = r.getEscapeSeq();
        boolean bl3 = _notEquals_2 = !Objects.equals(_escapeSeq, null);
        if (_notEquals_2) {
            _builder.append("'");
            String _escapeChar = JavaFXCodeGenerator.escapeChar(r.getEscapeSeq());
            _builder.append(_escapeChar, "\t");
            _builder.append("'");
        } else {
            _builder.append("(char)0");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(", ");
        if (Objects.equals(r.getEndSeq(), null) || r.getEndSeq().isEmpty()) {
            _builder.append("true");
        } else {
            _builder.append("false");
        }
        _builder.append(")");
        Check _check_1 = r.getCheck();
        boolean bl4 = _notEquals_3 = !Objects.equals(_check_1, null);
        if (_notEquals_3) {
            _builder.append(",");
            CharSequence _predicate = JavaFXCodeGenerator.toPredicate(r.getCheck());
            _builder.append((Object)_predicate, "\t");
            _builder.append(")");
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence _generatePartitionRule(Partition_MultiLineRule r) {
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        StringConcatenation _builder = new StringConcatenation();
        Check _check = r.getCheck();
        boolean bl = _notEquals = !Objects.equals(_check, null);
        if (_notEquals) {
            _builder.append("new org.eclipse.fx.text.rules.PredicateColumnStartRule(");
        }
        _builder.append("new org.eclipse.jface.text.rules.MultiLineRule(");
        _builder.newLineIfNotEmpty();
        _builder.append("\t  ");
        _builder.append("\"");
        String _escapeString = JavaFXCodeGenerator.escapeString(r.getStartSeq());
        _builder.append(_escapeString, "\t  ");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(", \"");
        String _escapeString_1 = JavaFXCodeGenerator.escapeString(r.getEndSeq());
        _builder.append(_escapeString_1, "\t");
        _builder.append("\"");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(", new org.eclipse.jface.text.rules.Token(\"");
        String _name = r.getParition().getName();
        _builder.append(_name, "\t");
        _builder.append("\")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(", ");
        String _escapeSeq = r.getEscapeSeq();
        boolean bl2 = _notEquals_1 = !Objects.equals(_escapeSeq, null);
        if (_notEquals_1) {
            _builder.append("'");
            String _escapeChar = JavaFXCodeGenerator.escapeChar(r.getEscapeSeq());
            _builder.append(_escapeChar, "\t");
            _builder.append("'");
        } else {
            _builder.append("(char)0");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append(", ");
        if (Objects.equals(r.getEndSeq(), null) || r.getEndSeq().isEmpty()) {
            _builder.append("true");
        } else {
            _builder.append("false");
        }
        _builder.append(")");
        Check _check_1 = r.getCheck();
        boolean bl3 = _notEquals_2 = !Objects.equals(_check_1, null);
        if (_notEquals_2) {
            _builder.append(",");
            CharSequence _predicate = JavaFXCodeGenerator.toPredicate(r.getCheck());
            _builder.append((Object)_predicate, "\t");
            _builder.append(")");
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected static CharSequence _toPredicate(Equals range) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("v -> v == ");
        int _value = range.getValue();
        _builder.append((Object)_value);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected static CharSequence _toPredicate(Range range) {
        StringConcatenation _builder = new StringConcatenation();
        if (range.getMinValue().size() == 1 && range.getMaxValue().size() == 1) {
            _builder.append("v -> ");
            Integer _head = (Integer)IterableExtensions.head(range.getMinValue());
            _builder.append((Object)_head);
            _builder.append(" ");
            String _ltOperator = JavaFXCodeGenerator.toLtOperator(range.getLtIncl());
            _builder.append(_ltOperator);
            _builder.append(" v && v ");
            String _ltOperator_1 = JavaFXCodeGenerator.toLtOperator(range.getGtIncl());
            _builder.append(_ltOperator_1);
            _builder.append(" ");
            Integer _head_1 = (Integer)IterableExtensions.head(range.getMaxValue());
            _builder.append((Object)_head_1);
            _builder.newLineIfNotEmpty();
        } else {
            boolean _equals;
            int _size = range.getMinValue().size();
            boolean bl = _equals = _size == 1;
            if (_equals) {
                _builder.append("v -> ");
                Integer _head_2 = (Integer)IterableExtensions.head(range.getMinValue());
                _builder.append((Object)_head_2);
                _builder.append(" ");
                String _ltOperator_2 = JavaFXCodeGenerator.toLtOperator(range.getLtIncl());
                _builder.append(_ltOperator_2);
                _builder.append(" v");
                _builder.newLineIfNotEmpty();
            } else {
                boolean _equals_1;
                int _size_1 = range.getMaxValue().size();
                boolean bl2 = _equals_1 = _size_1 == 1;
                if (_equals_1) {
                    _builder.append("v -> v ");
                    String _ltOperator_3 = JavaFXCodeGenerator.toLtOperator(range.getGtIncl());
                    _builder.append(_ltOperator_3);
                    _builder.append(" ");
                    Integer _head_3 = (Integer)IterableExtensions.head(range.getMaxValue());
                    _builder.append((Object)_head_3);
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        return _builder;
    }

    public static String toLtOperator(String b) {
        if (Objects.equals(b, "(") || Objects.equals(b, ")")) {
            return "<";
        }
        return "<=";
    }

    public static String escapeString(String data) {
        return data.replaceAll("\"", "\\\\\"");
    }

    public static String escapeChar(String data) {
        boolean _equals = Objects.equals(data, "\\");
        if (_equals) {
            return "\\\\";
        }
        boolean _equals_1 = Objects.equals(data, "'");
        if (_equals_1) {
            return "\\'";
        }
        return data;
    }

    @XbaseGenerated
    public CharSequence generateScannerRule(Token t, Scanner_Rule r) {
        if (r instanceof Scanner_CharacterRule) {
            return this._generateScannerRule(t, (Scanner_CharacterRule)r);
        }
        if (r instanceof Scanner_MultiLineRule) {
            return this._generateScannerRule(t, (Scanner_MultiLineRule)r);
        }
        if (r instanceof Scanner_PatternRule) {
            return this._generateScannerRule(t, (Scanner_PatternRule)r);
        }
        if (r instanceof Scanner_SingleLineRule) {
            return this._generateScannerRule(t, (Scanner_SingleLineRule)r);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(t, r).toString());
    }

    @XbaseGenerated
    public CharSequence generatePartitionRule(Partition_Rule r) {
        if (r instanceof Partition_MultiLineRule) {
            return this._generatePartitionRule((Partition_MultiLineRule)r);
        }
        if (r instanceof Partition_SingleLineRule) {
            return this._generatePartitionRule((Partition_SingleLineRule)r);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(r).toString());
    }

    @XbaseGenerated
    public static CharSequence toPredicate(Check range) {
        if (range instanceof Equals) {
            return JavaFXCodeGenerator._toPredicate((Equals)range);
        }
        if (range instanceof Range) {
            return JavaFXCodeGenerator._toPredicate((Range)range);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(range).toString());
    }
}

