/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.custom;

import org.eclipse.fmc.blockdiagram.editor.BlockDiagramMessages;
import org.eclipse.fmc.blockdiagram.editor.features.custom.FMCCustomFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.ICustomContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.Text;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ConnectionDecorator;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IGaService;
import org.eclipse.graphiti.services.IPeService;

public class AddTextToConnectionCustomFeature
extends FMCCustomFeature {
    public AddTextToConnectionCustomFeature(IFeatureProvider featureProvider) {
        super(featureProvider);
    }

    public void execute(ICustomContext context) {
        IGaService ga = Graphiti.getGaService();
        IPeService pe = Graphiti.getPeService();
        PictogramElement[] pictogramElementArray = context.getPictogramElements();
        int n = pictogramElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            PictogramElement element = pictogramElementArray[n2];
            Connection con = (Connection)element;
            ConnectionDecorator letter = pe.createConnectionDecorator(con, true, (double)0.4f, true);
            Text txt = ga.createText((GraphicsAlgorithmContainer)letter, BlockDiagramMessages.FMCAddFeature_DefaultShapeTitle);
            txt.setForeground(ga.manageColor(this.getDiagram(), 0, 0, 0));
            ga.setLocation((GraphicsAlgorithm)txt, -8, 22);
            ++n2;
        }
    }

    public boolean canExecute(ICustomContext context) {
        if (context.getPictogramElements().length == 0) {
            return false;
        }
        PictogramElement[] pictogramElementArray = context.getPictogramElements();
        int n = pictogramElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            PictogramElement element = pictogramElementArray[n2];
            if (!(element instanceof Connection)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String getName() {
        return "Add Text";
    }
}

