/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.clipboard;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.imageio.ImageIO;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fmc.blockdiagram.editor.BlockDiagramEditor;
import org.eclipse.graphiti.ui.editor.DiagramEditorInput;
import org.eclipse.graphiti.ui.internal.GraphitiUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;

public class PasteFromClipboard {
    private static final String IMG_TYPE = ".png";
    private static final String PASTED_IMAGES_FOLDER = ".images/";
    private static final String CLIP_NAME = "clip";
    private static final String IMAGE_PREFIX = "org.eclipse.fmc.";

    public static String pasteImagesFromClipboard(BlockDiagramEditor editor) {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        String nextImageName = PasteFromClipboard.getNextImageName(editor);
        if (clipboard.getAvailableDataFlavors().length == 0) {
            return null;
        }
        DataFlavor dataFlavor = clipboard.getAvailableDataFlavors()[0];
        try {
            Transferable contents = clipboard.getContents(dataFlavor);
            Object transferData = contents.getTransferData(contents.getTransferDataFlavors()[0]);
            if (transferData instanceof BufferedImage) {
                BufferedImage img = (BufferedImage)transferData;
                PasteFromClipboard.writeImageToDisk(editor, PasteFromClipboard.transformToSWTImage(Display.getDefault(), img));
                return IMAGE_PREFIX + nextImageName;
            }
            if (transferData instanceof List) {
                List files = (List)transferData;
                for (Object f : files) {
                    if (!(f instanceof File)) continue;
                    BufferedImage img = ImageIO.read((File)f);
                    PasteFromClipboard.writeImageToDisk(editor, PasteFromClipboard.transformToSWTImage(Display.getDefault(), img));
                    return IMAGE_PREFIX + nextImageName;
                }
            }
        }
        catch (IOException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.fmc.blockdiagram.editor", "Error while writing copied image to disk", (Throwable)e));
        }
        catch (UnsupportedFlavorException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.fmc.blockdiagram.editor", "Error while pasting from clipboard", (Throwable)e));
        }
        return null;
    }

    private static void writeImageToDisk(BlockDiagramEditor editor, org.eclipse.swt.graphics.Image img) {
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{img.getImageData()};
        String imageName = PasteFromClipboard.getNextImageName(editor);
        String imageNameWithEnding = String.valueOf(imageName) + IMG_TYPE;
        String absoluteImagePath = String.valueOf(PasteFromClipboard.getImageFolder(editor).toFileString()) + "\\" + imageNameWithEnding;
        loader.save(absoluteImagePath, 5);
        GraphitiUIPlugin.getDefault().getImageRegistry().put(IMAGE_PREFIX + imageName, img);
    }

    private static org.eclipse.swt.graphics.Image transformToSWTImage(Display display, Image awtImage) {
        int width = awtImage.getWidth(null);
        int height = awtImage.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics2D g2d = bufferedImage.createGraphics();
        g2d.drawImage(awtImage, 0, 0, null);
        g2d.dispose();
        int[] data = ((DataBufferInt)bufferedImage.getData().getDataBuffer()).getData();
        ImageData imageData = new ImageData(width, height, 24, new PaletteData(0xFF0000, 65280, 255));
        imageData.setPixels(0, 0, data.length, data, 0);
        org.eclipse.swt.graphics.Image swtImage = new org.eclipse.swt.graphics.Image((Device)display, imageData);
        return swtImage;
    }

    private static String getNextImageName(BlockDiagramEditor editor) {
        File[] files = PasteFromClipboard.loadClipFiles(editor);
        int max = -1;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String name = file.getName().split("\\.")[0];
            Integer num = Integer.valueOf(name.replace(CLIP_NAME, ""));
            if (num > max) {
                max = num;
            }
            ++n2;
        }
        return CLIP_NAME + (max + 1);
    }

    private static File[] loadClipFiles(BlockDiagramEditor editor) {
        URI resolvedImagesURI = PasteFromClipboard.getImageFolder(editor);
        File f = new File(resolvedImagesURI.toFileString());
        if (!f.exists() && !f.mkdir()) {
            throw new IllegalStateException("Cannot create image folder: " + f.getAbsolutePath());
        }
        File[] files = f.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        return files;
    }

    public static void registerClipImages(BlockDiagramEditor editor) throws MalformedURLException {
        File[] fileArray = PasteFromClipboard.loadClipFiles(editor);
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)new URL("file:///" + file.getAbsolutePath()));
            if (GraphitiUIPlugin.getDefault().getImageRegistry().get(IMAGE_PREFIX + file.getName().replace(IMG_TYPE, "")) == null) {
                GraphitiUIPlugin.getDefault().getImageRegistry().put(IMAGE_PREFIX + file.getName().replace(IMG_TYPE, ""), descriptor);
            }
            ++n2;
        }
    }

    private static URI getImageFolder(BlockDiagramEditor editor) {
        DiagramEditorInput input = (DiagramEditorInput)editor.getEditorInput();
        String projectName = URI.createURI((String)input.getUriString()).segment(1);
        URI projectURI = URI.createPlatformResourceURI((String)projectName, (boolean)true);
        URI imagesURI = URI.createURI((String)(String.valueOf(projectURI.toString()) + "/" + PASTED_IMAGES_FOLDER));
        URI resolvedImagesURI = CommonPlugin.resolve((URI)imagesURI);
        return resolvedImagesURI;
    }
}

