/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.features.add;

import org.eclipse.fmc.blockdiagram.editor.features.add.ShapeAddFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.context.IAddContext;
import org.eclipse.graphiti.mm.GraphicsAlgorithmContainer;
import org.eclipse.graphiti.mm.algorithms.GraphicsAlgorithm;
import org.eclipse.graphiti.mm.algorithms.RoundedRectangle;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.util.ColorConstant;
import org.eclipse.graphiti.util.IColorConstant;

public class DotsShapeAddFeature
extends ShapeAddFeature {
    public DotsShapeAddFeature(IFeatureProvider featureProvider) {
        super(featureProvider);
    }

    public DotsShapeAddFeature(IFeatureProvider featureProvider, boolean linked) {
        super(featureProvider);
        this.linked = linked;
    }

    public PictogramElement add(IAddContext context) {
        ContainerShape newShape = this.pe.createContainerShape(context.getTargetContainer(), true);
        this.createGraphics(newShape, context);
        if (this.linked) {
            this.link((PictogramElement)newShape, context.getNewObject());
        }
        return newShape;
    }

    protected void createGraphics(ContainerShape container, IAddContext context) {
        RoundedRectangle invRectangle = this.ga.createRoundedRectangle((GraphicsAlgorithmContainer)container, this.getWidth(context), this.getHeight(context));
        invRectangle.setLineVisible(Boolean.valueOf(false));
        invRectangle.setFilled(Boolean.valueOf(false));
        this.ga.setLocationAndSize((GraphicsAlgorithm)invRectangle, context.getX(), context.getY(), this.getWidth(context), this.getHeight(context));
        if (context.getWidth() > context.getHeight()) {
            int gap = DotsShapeAddFeature.getDotsGap(this.getWidth(context));
            int i = 0;
            while (i < 3) {
                Shape nestedContainer = this.pe.createShape(container, false);
                RoundedRectangle rectangle = this.ga.createRoundedRectangle((GraphicsAlgorithmContainer)nestedContainer, 6, 6);
                this.ga.setLocationAndSize((GraphicsAlgorithm)rectangle, 0 + i * gap, this.getHeight(context) / 2, 6, 6);
                rectangle.setForeground(Graphiti.getGaService().manageColor(this.getDiagram(), (IColorConstant)new ColorConstant(0, 0, 0)));
                rectangle.setBackground(Graphiti.getGaService().manageColor(this.getDiagram(), (IColorConstant)new ColorConstant(0, 0, 0)));
                rectangle.setFilled(Boolean.valueOf(true));
                ++i;
            }
        } else {
            int gap = DotsShapeAddFeature.getDotsGap(this.getHeight(context));
            int i = 0;
            while (i < 3) {
                Shape nestedContainer = this.pe.createShape(container, false);
                RoundedRectangle rectangle = this.ga.createRoundedRectangle((GraphicsAlgorithmContainer)nestedContainer, 6, 6);
                this.ga.setLocationAndSize((GraphicsAlgorithm)rectangle, this.getWidth(context) / 2, 0 + i * gap, 6, 6);
                rectangle.setForeground(Graphiti.getGaService().manageColor(this.getDiagram(), (IColorConstant)new ColorConstant(0, 0, 0)));
                rectangle.setBackground(Graphiti.getGaService().manageColor(this.getDiagram(), (IColorConstant)new ColorConstant(0, 0, 0)));
                rectangle.setFilled(Boolean.valueOf(true));
                ++i;
            }
        }
    }

    public static int getDotsGap(int width) {
        return (width - 6) / 2;
    }
}

