/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fmc.blockdiagram.editor.property;

import java.math.BigDecimal;
import java.math.MathContext;
import org.eclipse.fmc.blockdiagram.editor.algorithm.connection.FMCConnectionAlgorithm;
import org.eclipse.fmc.blockdiagram.editor.algorithm.connection.FMCConnectionAlgorithmFactory;
import org.eclipse.fmc.blockdiagram.editor.property.FMCPropertySection;
import org.eclipse.fmc.mm.DataflowDirection;
import org.eclipse.fmc.mm.RequestDirection;
import org.eclipse.graphiti.mm.pictograms.CompositeConnection;
import org.eclipse.graphiti.mm.pictograms.Connection;
import org.eclipse.graphiti.mm.pictograms.ManhattanConnection;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class ConnectionPropertySection
extends FMCPropertySection {
    private static final String TOOLTIP_DATA_FLOW = "Sets the direction of the data flow of the selected connection";
    private static final String TOOLTIP_REQUEST_DIRECTION = "Sets the request direction of the channel";
    private static final String TOOLTIP_CONNECTION_TYPE = "Sets the typeof the direction";
    private static final String TOOLTIP_CHANNEL_LOCATION = "Moves the channel symbol along the given relative position";
    private FMCConnectionAlgorithmFactory conFactory = FMCConnectionAlgorithmFactory.getInstance();
    private Spinner channelLocation;
    private CCombo dataFlowDirection;
    private CCombo requestDirection;
    private CCombo connectionType;
    private static final BigDecimal HUNDRET = new BigDecimal(100);

    private void createConnectionProperties(TabbedPropertySheetWidgetFactory fac) {
        this.createDataFlowDirection(fac);
        this.createRequestDirection(fac);
        this.createChannelLocation(fac);
        this.createConnectionType(fac);
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        TabbedPropertySheetWidgetFactory fac = this.getWidgetFactory();
        this.comp = fac.createComposite(parent, 0);
        this.comp.setLayout((Layout)new GridLayout(2, false));
        this.createConnectionProperties(fac);
        this.refresh();
    }

    protected void createConnectionType(TabbedPropertySheetWidgetFactory fac) {
        Label label = fac.createLabel(this.comp, "Connection Type:");
        label.setToolTipText(TOOLTIP_CONNECTION_TYPE);
        this.connectionType = fac.createCCombo(this.comp, 4);
        this.connectionType.setToolTipText(TOOLTIP_REQUEST_DIRECTION);
        this.connectionType.setEditable(false);
        this.connectionType.setItems(new String[]{"Auto Routing", "Manual Routing"});
        this.connectionType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PictogramElement el = ConnectionPropertySection.this.getSingleInput();
                ConnectionPropertySection.this.getActions().changeConnectionType((Connection)el, ConnectionPropertySection.this.connectionType.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createDataFlowDirection(TabbedPropertySheetWidgetFactory fac) {
        Label label = fac.createLabel(this.comp, "DataFlow:");
        label.setToolTipText(TOOLTIP_DATA_FLOW);
        this.dataFlowDirection = fac.createCCombo(this.comp, 4);
        this.dataFlowDirection.setToolTipText(TOOLTIP_DATA_FLOW);
        this.dataFlowDirection.setEditable(false);
        this.dataFlowDirection.setItems(new String[]{"Unspecified", "Default", "Other"});
        this.dataFlowDirection.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PictogramElement el = ConnectionPropertySection.this.getSingleInput();
                ConnectionPropertySection.this.getActions().changeDataFlowDirection((Connection)el, ConnectionPropertySection.this.dataFlowDirection.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createRequestDirection(TabbedPropertySheetWidgetFactory fac) {
        Label label = fac.createLabel(this.comp, "Channel Type:");
        label.setToolTipText(TOOLTIP_REQUEST_DIRECTION);
        this.requestDirection = fac.createCCombo(this.comp, 4);
        this.requestDirection.setToolTipText(TOOLTIP_REQUEST_DIRECTION);
        this.requestDirection.setEditable(false);
        this.requestDirection.setItems(new String[]{"Unspecified", "Request", "Response", "Request/Response"});
        this.requestDirection.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PictogramElement el = ConnectionPropertySection.this.getSingleInput();
                ConnectionPropertySection.this.getActions().changeRequestDirection((Connection)el, ConnectionPropertySection.this.requestDirection.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createChannelLocation(TabbedPropertySheetWidgetFactory fac) {
        Label label = fac.createLabel(this.comp, "ChannelLocation:");
        label.setToolTipText(TOOLTIP_CHANNEL_LOCATION);
        this.channelLocation = new Spinner(this.comp, 2048);
        this.channelLocation.setToolTipText(TOOLTIP_CHANNEL_LOCATION);
        this.channelLocation.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int location = ((Spinner)e.getSource()).getSelection();
                PictogramElement el = ConnectionPropertySection.this.getSingleInput();
                if (el != null && el instanceof Connection) {
                    Connection con = (Connection)el;
                    FMCConnectionAlgorithm algorithm = ConnectionPropertySection.this.conFactory.getAlgorithm((PictogramElement)con);
                    BigDecimal decimal = new BigDecimal(algorithm.getChannelLocation(con), new MathContext(2));
                    BigDecimal locationDecimal = new BigDecimal(location, new MathContext(2));
                    if (!locationDecimal.divide(HUNDRET).equals(decimal)) {
                        ConnectionPropertySection.this.getActions().changeChannelLocation(con, (double)location / 100.0);
                    }
                }
            }
        });
    }

    private void refreshConnection(Connection con) {
        this.connectionType.setEnabled(!(con instanceof CompositeConnection));
        this.connectionType.select(con instanceof ManhattanConnection ? 0 : 1);
        if (this.dataFlowDirection != null) {
            this.dataFlowDirection.setEnabled(!this.helper.isModifyAccess((PictogramElement)con));
        }
        if (this.helper.isCommunicationChannel((PictogramElement)con)) {
            FMCConnectionAlgorithm connectionAlgorithm = this.conFactory.getAlgorithm((PictogramElement)con);
            if (this.requestDirection != null) {
                this.requestDirection.setEnabled(true);
            }
            this.channelLocation.setEnabled(true);
            this.channelLocation.setSelection((int)(connectionAlgorithm.getChannelLocation(con) * 100.0));
        } else {
            this.channelLocation.setEnabled(false);
            if (this.requestDirection != null) {
                this.requestDirection.setEnabled(false);
            }
        }
        FMCConnectionAlgorithm algorithm = this.conFactory.getAlgorithm((PictogramElement)con);
        if (this.dataFlowDirection != null) {
            DataflowDirection direction = algorithm.getDirection(con);
            switch (direction) {
                case UNSPECIFIED: {
                    this.dataFlowDirection.select(0);
                    break;
                }
                case DEFAULT: {
                    this.dataFlowDirection.select(1);
                    break;
                }
                case OTHER: {
                    this.dataFlowDirection.select(2);
                }
            }
        }
        if (this.requestDirection != null) {
            RequestDirection reqDirection = algorithm.getRequestDirection(con);
            switch (reqDirection) {
                case UNSPECIFIED: {
                    this.requestDirection.select(0);
                    break;
                }
                case REQUEST: {
                    this.requestDirection.select(1);
                    break;
                }
                case RESPONSE: {
                    this.requestDirection.select(2);
                    break;
                }
                case REQUESTRESPONSE: {
                    this.requestDirection.select(3);
                }
            }
        }
    }

    public void refresh() {
        if (!this.isDisposed()) {
            ScrolledComposite tabbedPropertyComposite;
            PictogramElement el = this.getSingleInput();
            if (el != null && el instanceof Connection) {
                this.refreshConnection((Connection)el);
            }
            if ((tabbedPropertyComposite = this.findTabbedPropertyComposite(this.comp)) != null) {
                int cols = tabbedPropertyComposite.getSize().x / 150 * 2;
                cols = cols < 2 ? 2 : cols;
                this.comp.setLayout((Layout)new GridLayout(cols > 8 ? 8 : cols, false));
                this.comp.layout();
            }
        }
    }
}

