/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.orb.admin.cli;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.beans.PropertyVetoException;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;
import org.glassfish.orb.admin.config.IiopListener;
import org.glassfish.orb.admin.config.IiopService;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service(name="create-iiop-listener")
@PerLookup
@I18n(value="create.iiop.listener")
@ExecuteOn(value={RuntimeType.DAS, RuntimeType.INSTANCE})
@TargetType(value={CommandTarget.CLUSTER, CommandTarget.CONFIG, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE})
public class CreateIiopListener
implements AdminCommand {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(CreateIiopListener.class);
    @Param(name="target", optional=true, defaultValue="server")
    String target;
    @Param(name="listeneraddress", alias="address")
    String listeneraddress;
    @Param(name="iiopport", optional=true, alias="port", defaultValue="1072")
    String iiopport;
    @Param(optional=true, defaultValue="true")
    Boolean enabled;
    @Param(name="securityenabled", optional=true, defaultValue="false", alias="security-enabled")
    Boolean securityenabled;
    @Param(name="property", optional=true, separator=58)
    Properties properties;
    @Param(name="listener_id", primary=true, alias="id")
    String listener_id;
    @Inject
    Configs configs;
    @Inject
    Servers servers;
    @Inject
    ServiceLocator services;

    public void execute(AdminCommandContext context) {
        Target targetUtil = this.services.getService(Target.class, new Annotation[0]);
        Config config = targetUtil.getConfig(this.target);
        ActionReport report = context.getActionReport();
        IiopService iiopService = (IiopService)config.getExtensionByType(IiopService.class);
        for (IiopListener listener : iiopService.getIiopListener()) {
            if (listener.getId().equals(this.listener_id)) {
                String ls = localStrings.getLocalString("create.iiop.listener.duplicate", "IIOP Listener named {0} already exists.", new Object[]{this.listener_id});
                report.setMessage(ls);
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            if (!listener.getAddress().trim().equals(this.listeneraddress) || !listener.getPort().trim().equals(this.iiopport)) continue;
            String def = "Port [{0}] is already taken by another listener: [{1}] for address [{2}], choose another port.";
            String ls = localStrings.getLocalString("create.iiop.listener.port.occupied", def, new Object[]{this.iiopport, listener.getId(), this.listeneraddress});
            report.setMessage(ls);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<IiopService>(){

                public Object run(IiopService param) throws PropertyVetoException, TransactionFailure {
                    IiopListener newListener = (IiopListener)param.createChild(IiopListener.class);
                    newListener.setId(CreateIiopListener.this.listener_id);
                    newListener.setAddress(CreateIiopListener.this.listeneraddress);
                    newListener.setPort(CreateIiopListener.this.iiopport);
                    newListener.setSecurityEnabled(CreateIiopListener.this.securityenabled.toString());
                    newListener.setEnabled(CreateIiopListener.this.enabled.toString());
                    if (CreateIiopListener.this.properties != null) {
                        for (Map.Entry<Object, Object> entry : CreateIiopListener.this.properties.entrySet()) {
                            Property property = (Property)newListener.createChild(Property.class);
                            property.setName((String)entry.getKey());
                            property.setValue((String)entry.getValue());
                            newListener.getProperty().add(property);
                        }
                    }
                    param.getIiopListener().add(newListener);
                    return newListener;
                }
            }, (ConfigBeanProxy)iiopService);
            report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        }
        catch (TransactionFailure e) {
            String actual = e.getMessage();
            String def = "Creation of: " + this.listener_id + "failed because of: " + actual;
            String msg = localStrings.getLocalString("create.iiop.listener.fail", def, new Object[]{this.listener_id, actual});
            report.setMessage(msg);
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            report.setFailureCause((Throwable)e);
        }
    }
}

