/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.common.util.admin;

import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class AsadminInput {
    public static final String CLI_INPUT_OPTION_NAME = "_auxinput";
    public static final String CLI_INPUT_OPTION = "--_auxinput";
    public static final String SYSTEM_IN_INDICATOR = "-";
    private static final String VERSION_1_0 = "1.0";
    private static final String VERSION_INTRODUCER = "version=";
    private static final String CURRENT_VERSION = "1.0";
    private static final LocalStringManager localStrings = new LocalStringManagerImpl(AsadminInput.class);

    public static String versionSpecifier() {
        return "version=1.0";
    }

    public static InputReader reader(String inputPath) throws URISyntaxException, IOException {
        if (inputPath.equals(SYSTEM_IN_INDICATOR)) {
            return AsadminInput.reader(System.in);
        }
        return AsadminInput.reader(new FileInputStream(inputPath));
    }

    public static InputReader reader(InputStream is) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        String version = AsadminInput.readVersionFromFirstLine(reader);
        return AsadminInput.newReader(reader, version);
    }

    private static InputReader newReader(BufferedReader reader, String version) throws IOException {
        if (version.equals("1.0")) {
            return new InputReader_1_0(reader);
        }
        throw new IllegalArgumentException(AsadminInput.unknownVersionMsg(version));
    }

    private static String readVersionFromFirstLine(BufferedReader reader) throws IOException {
        String firstLine = reader.readLine();
        if (firstLine == null || !firstLine.startsWith(VERSION_INTRODUCER) || firstLine.length() <= VERSION_INTRODUCER.length()) {
            throw new IOException(AsadminInput.badVersionMsg());
        }
        return firstLine.substring(VERSION_INTRODUCER.length());
    }

    private static String badVersionMsg() {
        return MessageFormat.format(localStrings.getLocalString("AsadminInputNoVersion", "Input to asadmin does not specify a version using {0} as the first line"), VERSION_INTRODUCER);
    }

    private static String unknownVersionMsg(String version) {
        return MessageFormat.format(localStrings.getLocalString("AsadminInputUnknownVersion", "Input to asadmin specifies version {0} which is not recognized"), version);
    }

    private static class InputReader_1_0
    implements InputReader {
        private final Map<String, Properties> settings;
        private final BufferedReader reader;

        @Override
        public Map<String, Properties> settings() {
            return this.settings;
        }

        private InputReader_1_0(BufferedReader reader) throws IOException {
            this.reader = reader;
            this.settings = this.loadSettings();
            reader.close();
        }

        private Map<String, Properties> loadSettings() throws IOException {
            HashMap<String, Properties> result = new HashMap<String, Properties>();
            Properties entireContent = new Properties();
            entireContent.load(this.reader);
            for (String propName : entireContent.stringPropertyNames()) {
                int firstDot = propName.indexOf(46);
                if (firstDot == -1) continue;
                String categoryName = propName.substring(0, firstDot);
                String propWithinCategory = propName.substring(firstDot + 1);
                Properties category = (Properties)result.get(categoryName);
                if (category == null) {
                    category = new Properties();
                    result.put(categoryName, category);
                }
                category.setProperty(propWithinCategory, entireContent.getProperty(propName));
            }
            return result;
        }
    }

    public static interface InputReader {
        public Map<String, Properties> settings();
    }
}

