/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.integration.tests.emf;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.core.graph.IGraphChangeListener;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.query.InvalidQueryException;
import org.eclipse.hawk.core.query.QueryExecutionException;
import org.eclipse.hawk.graph.GraphWrapper;
import org.eclipse.hawk.graph.syncValidationListener.SyncValidationListener;
import org.eclipse.hawk.integration.tests.IntegrationTestSuite;
import org.eclipse.hawk.integration.tests.ModelIndexingTest;
import org.eclipse.hawk.integration.tests.emf.EMFModelSupportFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;

public class ScopedQueryTest
extends ModelIndexingTest {
    private static final String MM_URI = "http://github.com/mondo-hawk/testing/xrefs";
    @Rule
    public ModelIndexingTest.GraphChangeListenerRule<SyncValidationListener> syncValidation = new ModelIndexingTest.GraphChangeListenerRule((ModelIndexingTest)this, (IGraphChangeListener)new SyncValidationListener());

    @Parameterized.Parameters(name="{1}")
    public static Iterable<Object[]> params() {
        return IntegrationTestSuite.caseParams();
    }

    public ScopedQueryTest(File baseDir, IGraphDatabaseFactory dbf) {
        super(baseDir, dbf, new EMFModelSupportFactory());
    }

    @Before
    public void prepare() throws Exception {
        this.indexer.registerMetamodels(new File[]{new File(this.baseDir, "resources/metamodels/Ecore.ecore"), new File(this.baseDir, "resources/metamodels/crossrefs.ecore")});
        this.requestFolderIndex(new File(this.baseDir, "resources/models/scopedQuery"));
    }

    @Test
    public void listFiles() throws Throwable {
        this.scheduleAndWait(() -> {
            block9: {
                Throwable throwable = null;
                Object var2_3 = null;
                IGraphTransaction tx = this.db.beginTransaction();
                try {
                    GraphWrapper gw = new GraphWrapper(this.db);
                    Function<String, Supplier> query = path -> () -> gw.getFileNodes(Collections.singleton("*"), Collections.singleton(path)).size();
                    Assert.assertEquals((long)3L, (long)((Integer)query.apply("*").get()).intValue());
                    Assert.assertEquals((long)2L, (long)((Integer)query.apply("/subfolder/*").get()).intValue());
                    Assert.assertEquals((long)1L, (long)((Integer)query.apply("/subfolder/subfolder/*").get()).intValue());
                    if (tx == null) break block9;
                }
                catch (Throwable throwable2) {
                    try {
                        if (tx != null) {
                            tx.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                tx.close();
            }
            return null;
        });
    }

    @Test
    public void instanceCounts() throws Throwable {
        this.scheduleAndWait(() -> {
            this.assertNoErrors(this.syncValidation.getListener());
            Assert.assertEquals((String)"With no context, it should return all six elements", (Object)6, (Object)this.eol("return Element.all.size;"));
            Assert.assertEquals((String)"With file context '*', it should return all six elements", (Object)6, (Object)this.eol("return Element.all.size;", this.fc("*")));
            Assert.assertEquals((String)"With file context '/root.model', it should return only the two root elements", new HashSet<Integer>(Arrays.asList(0, 1)), (Object)this.eol("return Element.all.id.asSet;", this.fc("/root.model")));
            Assert.assertEquals((String)"With file context '/subfolder/*', it should return four elements", (Object)4, (Object)this.eol("return Element.all.size;", this.fc("/subfolder/*")));
            Assert.assertEquals((String)"With file context '/subfolder/subfolder/*', it should return only two elements", (Object)2, (Object)this.eol("return Element.all.size;", this.fc("/subfolder/subfolder/*")));
            return null;
        });
    }

    @Test
    public void instanceCountsAllOf() throws Throwable {
        this.scheduleAndWait(() -> {
            this.assertNoErrors(this.syncValidation.getListener());
            Throwable throwable = null;
            Object var2_3 = null;
            try (IGraphTransaction tx = this.db.beginTransaction();){
                Assert.assertEquals((String)"With no context, it should return all six elements of the exact type", (long)6L, (long)this.queryEngine.getAllOf("Element", "_hawkOfType").size());
                Assert.assertEquals((String)"With no context, it should return all six elements of the exact type or subtypes", (long)6L, (long)this.queryEngine.getAllOf("Element", "_hawkOfKind").size());
                Assert.assertEquals((String)"With file context '*', it should return all six elements", (long)6L, (long)this.queryEngine.getAllOf(MM_URI, "Element", "*").size());
                Assert.assertEquals((String)"With file context '/root.model', it should return only the two root elements", (long)2L, (long)this.queryEngine.getAllOf(MM_URI, "Element", "/root.model").size());
                Assert.assertEquals((String)"With file context '/subfolder/*', it should return four elements", (long)4L, (long)this.queryEngine.getAllOf(MM_URI, "Element", "/subfolder/*").size());
                Assert.assertEquals((String)"With file context '/subfolder/subfolder/*', it should return only two elements", (long)2L, (long)this.queryEngine.getAllOf(MM_URI, "Element", "/subfolder/subfolder/*").size());
                tx.success();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return null;
        });
    }

    @Test
    public void forwardRefs() throws Throwable {
        this.scheduleAndWait(() -> {
            this.assertNoErrors(this.syncValidation.getListener());
            this.assertForwardRefs(null, 0, 1);
            this.assertForwardRefs(null, 1, 3);
            this.assertForwardRefs(null, 12, 1);
            this.assertForwardRefs("/subfolder/*", 12, 0);
            this.assertForwardRefs(null, 15, 2);
            this.assertForwardRefs("/subfolder/*", 15, 1);
            this.assertForwardRefs(null, 23, 3);
            this.assertForwardRefs("/subfolder/*", 23, 2);
            this.assertForwardRefs("/subfolder/subfolder/*", 23, 1);
            this.assertForwardRefs(null, 27, 1);
            return null;
        });
    }

    @Test
    public void reverseRefs() throws Throwable {
        this.scheduleAndWait(() -> {
            this.assertNoErrors(this.syncValidation.getListener());
            this.assertReverseRefs(null, 0, 3);
            this.assertReverseRefs(null, 1, 1);
            this.assertReverseRefs(null, 12, 1);
            this.assertReverseRefs("/subfolder/*", 12, 0);
            this.assertReverseRefs(null, 15, 3);
            this.assertReverseRefs("/subfolder/*", 15, 2);
            this.assertReverseRefs(null, 23, 2);
            this.assertReverseRefs("/subfolder/*", 23, 1);
            this.assertReverseRefs("/subfolder/subfolder/*", 23, 1);
            this.assertReverseRefs(null, 27, 1);
            this.assertReverseRefs("/subfolder/*", 27, 1);
            this.assertReverseRefs("/subfolder/subfolder/*", 27, 1);
            return null;
        });
    }

    private void assertForwardRefs(String path, int id, int expectedSize) throws InvalidQueryException, QueryExecutionException {
        Map<String, Object> context = this.fc(path);
        Assert.assertEquals((String)String.format("With context %s, element %d should see %d elements", context, id, expectedSize), (Object)expectedSize, (Object)this.eol(String.format("return Element.all.selectOne(e|e.id=%d).xrefs.size;", id), context));
    }

    private void assertReverseRefs(String path, int id, int expectedSize) throws InvalidQueryException, QueryExecutionException {
        Map<String, Object> context = this.fc(path);
        Assert.assertEquals((String)String.format("With context %s, element %d should be seen by %d elements", context, id, expectedSize), (Object)expectedSize, (Object)this.eol(String.format("return Element.all.selectOne(e|e.id=%d).revRefNav_xrefs.size;", id), context));
    }

    private Map<String, Object> fc(String path) {
        if (path == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FILE", path);
        map.put("ENABLE_TRAVERSAL_SCOPING", "true");
        return map;
    }
}

