/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.backend.tests;

import org.eclipse.hawk.backend.tests.BackendTestSuite;
import org.eclipse.hawk.backend.tests.LogbackOnlyErrorsRule;
import org.eclipse.hawk.backend.tests.RedirectSystemErrorRule;
import org.eclipse.hawk.backend.tests.factories.IGraphDatabaseFactory;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.graph.IGraphDatabase;
import org.eclipse.hawk.core.graph.IGraphTransaction;
import org.eclipse.hawk.core.util.DefaultConsole;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class DatabaseManagementTest {
    private IGraphDatabaseFactory dbFactory;
    @Rule
    public RedirectSystemErrorRule errRule = new RedirectSystemErrorRule();
    @Rule
    public LogbackOnlyErrorsRule logRule = new LogbackOnlyErrorsRule();
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Parameterized.Parameters(name="Parameters are {0}")
    public static Iterable<Object[]> params() {
        return BackendTestSuite.caseParams();
    }

    public DatabaseManagementTest(IGraphDatabaseFactory dbFactory) {
        this.dbFactory = dbFactory;
    }

    @Test
    public void testStartShutdown() throws Exception {
        IGraphDatabase db = this.dbFactory.create();
        db.run(this.folder.getRoot(), (IConsole)new DefaultConsole());
        Assert.assertNotNull((Object)db.getFileIndex());
        Assert.assertNotNull((Object)db.getMetamodelIndex());
        Throwable throwable = null;
        Object var3_4 = null;
        try (IGraphTransaction tx = db.beginTransaction();){
            Assert.assertEquals((long)2L, (long)db.getNodeIndexNames().size());
            tx.success();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        db.shutdown();
    }

    @Test
    public void testStartDelete() throws Exception {
        IGraphDatabase db = this.dbFactory.create();
        DefaultConsole console = new DefaultConsole();
        db.run(this.folder.getRoot(), (IConsole)console);
        Assert.assertTrue((boolean)this.folder.getRoot().exists());
        db.delete();
        Assert.assertFalse((boolean)this.folder.getRoot().exists());
        this.folder.getRoot().mkdirs();
        db.run(this.folder.getRoot(), (IConsole)console);
        db.shutdown();
    }

    @Test
    public void testStartTransaction() throws Exception {
        IGraphDatabase db = this.dbFactory.create();
        db.run(this.folder.getRoot(), (IConsole)new DefaultConsole());
        Assert.assertEquals((Object)IGraphDatabase.Mode.TX_MODE, (Object)db.currentMode());
        Throwable throwable = null;
        Object var3_4 = null;
        try (IGraphTransaction tx = db.beginTransaction();){
            Assert.assertEquals((Object)IGraphDatabase.Mode.TX_MODE, (Object)db.currentMode());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        db.enterBatchMode();
        Assert.assertEquals((Object)IGraphDatabase.Mode.NO_TX_MODE, (Object)db.currentMode());
        db.exitBatchMode();
        Assert.assertEquals((Object)IGraphDatabase.Mode.TX_MODE, (Object)db.currentMode());
        db.shutdown();
    }
}

