/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.emfresource.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.hawk.emfresource.HawkResource;
import org.eclipse.hawk.emfresource.HawkResourceChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HawkFileResourceImpl
extends ResourceImpl
implements HawkResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(HawkFileResourceImpl.class);
    private final HawkResource mainResource;
    private final BiMap<String, String> nodeIdToFragment = HashBiMap.create();

    public HawkFileResourceImpl() {
        this.mainResource = null;
    }

    public HawkFileResourceImpl(URI uri, HawkResource mainResource) {
        super(uri);
        this.mainResource = mainResource;
    }

    public TreeIterator<EObject> getAllContents() {
        if (!this.getContents().isEmpty()) {
            LOGGER.warn("getAllContents() being called on a non-empty Hawk resource: inefficient!");
        }
        return super.getAllContents();
    }

    public void save(Map<?, ?> options) {
        this.doSave(null, null);
    }

    @Override
    public boolean hasChildren(EObject o) {
        if (this.mainResource != null) {
            return this.mainResource.hasChildren(o);
        }
        return o.eAllContents().hasNext();
    }

    @Override
    public Map<EObject, Object> fetchValuesByEStructuralFeature(EStructuralFeature feature) throws Exception {
        return this.mainResource.fetchValuesByEStructuralFeature(feature);
    }

    @Override
    public EList<EObject> fetchNodes(EClass eClass, boolean mustFetchAttributes) throws Exception {
        return this.mainResource.fetchNodes(eClass, mustFetchAttributes);
    }

    @Override
    public EList<EObject> fetchNodes(List<String> ids, boolean mustFetchAttributes) throws Exception {
        return this.mainResource.fetchNodes(ids, mustFetchAttributes);
    }

    @Override
    public List<Object> fetchValuesByEClassifier(EClassifier dataType) throws Exception {
        return this.mainResource.fetchValuesByEClassifier(dataType);
    }

    @Override
    public Map<EClass, List<EStructuralFeature>> fetchTypesWithEClassifier(EClassifier dataType) throws Exception {
        return this.mainResource.fetchTypesWithEClassifier(dataType);
    }

    @Override
    public boolean addSyncEndListener(Runnable r) {
        return this.mainResource.addSyncEndListener(r);
    }

    @Override
    public boolean removeSyncEndListener(Runnable r) {
        return this.mainResource.removeSyncEndListener(r);
    }

    @Override
    public boolean addChangeListener(HawkResourceChangeListener l) {
        return this.mainResource.addChangeListener(l);
    }

    @Override
    public boolean removeChangeListener(HawkResourceChangeListener l) {
        return this.mainResource.removeChangeListener(l);
    }

    protected void doSave(OutputStream outputStream, Map<?, ?> options) {
        LOGGER.warn("Hawk views are read-only: ignoring request to save");
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) {
    }

    public boolean isLoaded() {
        return false;
    }

    @Override
    public List<String> getRegisteredMetamodels() throws Exception {
        return this.mainResource.getRegisteredMetamodels();
    }

    @Override
    public List<String> getRegisteredTypes(String metamodelURI) throws Exception {
        return this.mainResource.getRegisteredTypes(metamodelURI);
    }

    @Override
    public String getEObjectNodeID(EObject obj) {
        return this.mainResource.getEObjectNodeID(obj);
    }

    public void addFragment(String nodeId, String fragment) {
        this.nodeIdToFragment.forcePut((Object)nodeId, (Object)fragment);
    }

    public void removeFragment(String nodeId) {
        this.nodeIdToFragment.remove((Object)nodeId);
    }

    public String getURIFragment(EObject eObject) {
        String nodeId = this.getEObjectNodeID(eObject);
        return (String)this.nodeIdToFragment.get((Object)nodeId);
    }

    public EObject getEObject(String uriFragment) {
        String nodeId = (String)this.nodeIdToFragment.inverse().get((Object)uriFragment);
        try {
            if (nodeId == null) {
                return this.fetchNode(this, uriFragment, false);
            }
            return this.fetchNode(nodeId, false);
        }
        catch (Exception e) {
            LOGGER.error("Could not retrieve EObject by fragment", (Throwable)e);
            return null;
        }
    }

    @Override
    public EObject fetchNode(HawkResource containerResource, String uriFragment, boolean mustFetchAttributes) throws Exception {
        return this.mainResource.fetchNode(containerResource, uriFragment, mustFetchAttributes);
    }

    @Override
    public EObject fetchNode(String id, boolean mustFetchAttributes) throws Exception {
        return this.mainResource.fetchNode(id, mustFetchAttributes);
    }

    @Override
    public void fetchAttributes(Map<String, EObject> idToEObject) throws Exception {
        this.mainResource.fetchAttributes(idToEObject);
    }

    protected void doUnload() {
        if (!this.getContents().isEmpty()) {
            this.getContents().clear();
        }
        this.getErrors().clear();
        this.getWarnings().clear();
    }

    @Override
    public void markChanged(EObject eob) {
        this.mainResource.markChanged(eob);
    }

    @Override
    public Object performRawQuery(String queryLanguage, String query, Map<String, Object> context) throws Exception {
        return this.mainResource.performRawQuery(queryLanguage, query, context);
    }
}

