/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.svn;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.hawk.core.IConsole;
import org.eclipse.hawk.core.ICredentialsStore;
import org.eclipse.hawk.core.IModelIndexer;
import org.eclipse.hawk.core.IVcsManager;
import org.eclipse.hawk.core.VcsChangeType;
import org.eclipse.hawk.core.VcsCommit;
import org.eclipse.hawk.core.VcsCommitItem;
import org.eclipse.hawk.core.VcsRepositoryDelta;
import org.eclipse.hawk.svn.SvnUtil;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SvnManager
implements IVcsManager {
    private IConsole console;
    private boolean isActive = false;
    private String repositoryURL;
    private String username;
    private String password;
    private IModelIndexer indexer;
    private boolean isFrozen = false;
    private SVNRepository svnRepository;
    private static final Set<String> EXTENSION_BLACKLIST = new HashSet<String>(Arrays.asList(".png", ".jpg", ".bmp", ".jar", ".gz", ".tar"));

    public void init(String vcsloc, IModelIndexer indexer) throws Exception {
        this.console = indexer.getConsole();
        this.repositoryURL = vcsloc;
        this.indexer = indexer;
    }

    public void run() throws Exception {
        try {
            ICredentialsStore credStore = this.indexer.getCredentialsStore();
            if (this.username != null) {
                this.setCredentials(this.username, this.password, credStore);
            } else {
                ICredentialsStore.Credentials credentials = credStore.get(this.repositoryURL);
                if (credentials != null) {
                    this.username = credentials.getUsername();
                    this.password = credentials.getPassword();
                } else {
                    this.console.printerrln("No username/password recorded for the repository " + this.repositoryURL);
                    this.username = "";
                    this.password = "";
                }
            }
            this.getFirstRevision();
            this.isActive = true;
        }
        catch (Exception e) {
            this.console.printerrln("exception in svnmanager run():");
            this.console.printerrln((Throwable)e);
        }
    }

    protected SVNRepository getSVNRepository() {
        if (this.svnRepository == null) {
            this.svnRepository = SvnUtil.connectToSVNInstance(this.repositoryURL, this.username, this.password);
        }
        return this.svnRepository;
    }

    public VcsRepositoryDelta getDelta(String startRevision, String endRevision) throws Exception {
        SVNRepository svnRepository = this.getSVNRepository();
        ArrayList<VcsCommit> commits = new ArrayList<VcsCommit>();
        VcsRepositoryDelta delta = new VcsRepositoryDelta(commits);
        delta.setManager((IVcsManager)this);
        String rootURL = svnRepository.getRepositoryRoot(false).toDecodedString();
        String overlappedURL = this.makeRelative(rootURL, this.repositoryURL);
        if (startRevision == null && endRevision != startRevision || !startRevision.equals(endRevision)) {
            Collection c = svnRepository.log(new String[]{""}, null, startRevision == null ? 0L : Long.valueOf(startRevision), Long.valueOf(endRevision).longValue(), true, true);
            for (Object o : c) {
                SVNLogEntry svnLogEntry = (SVNLogEntry)o;
                VcsCommit commit = new VcsCommit();
                commit.setAuthor(svnLogEntry.getAuthor());
                commit.setMessage(svnLogEntry.getMessage());
                commit.setRevision(String.valueOf(svnLogEntry.getRevision()));
                commit.setJavaDate(svnLogEntry.getDate());
                commits.add(commit);
                Map changedPaths = svnLogEntry.getChangedPaths();
                for (String path : changedPaths.keySet()) {
                    String ext;
                    SVNLogEntryPath svnLogEntryPath = (SVNLogEntryPath)changedPaths.get(path);
                    int lastDotIndex = path.lastIndexOf(".");
                    if (lastDotIndex <= 1 || EXTENSION_BLACKLIST.contains(ext = path.substring(lastDotIndex, path.length())) || !path.contains(overlappedURL)) continue;
                    VcsCommitItem commitItem = new VcsCommitItem();
                    commit.getItems().add(commitItem);
                    commitItem.setCommit(commit);
                    commitItem.setPath(path);
                    if (svnLogEntryPath.getType() == 'A') {
                        commitItem.setChangeType(VcsChangeType.ADDED);
                        continue;
                    }
                    if (svnLogEntryPath.getType() == 'M') {
                        commitItem.setChangeType(VcsChangeType.UPDATED);
                        continue;
                    }
                    if (svnLogEntryPath.getType() == 'D') {
                        commitItem.setChangeType(VcsChangeType.DELETED);
                        continue;
                    }
                    if (svnLogEntryPath.getType() == 'R') {
                        commitItem.setChangeType(VcsChangeType.REPLACED);
                        continue;
                    }
                    this.console.printerrln("Found unrecognised svn log entry type: " + svnLogEntryPath.getType());
                    commitItem.setChangeType(VcsChangeType.UNKNOWN);
                }
            }
        }
        return delta;
    }

    public String getCurrentRevision() throws Exception {
        return String.valueOf(this.getSVNRepository().getLatestRevision());
    }

    public String getFirstRevision() throws Exception {
        SVNRepository svnRepository = this.getSVNRepository();
        Collection c = svnRepository.log(new String[]{""}, null, 0L, Long.valueOf(this.getCurrentRevision()).longValue(), true, true);
        Iterator iterator = c.iterator();
        if (iterator.hasNext()) {
            Object o = iterator.next();
            return String.valueOf(((SVNLogEntry)o).getRevision());
        }
        return null;
    }

    private String makeRelative(String base, String extension) {
        String[] extensionSegments;
        StringBuilder result = new StringBuilder();
        List<String> baseSegments = Arrays.asList(base.split("/"));
        String[] stringArray = extensionSegments = extension.split("/");
        int n = extensionSegments.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            if (!baseSegments.contains(ext)) {
                result.append(extension.substring(extension.indexOf(ext)));
                break;
            }
            ++n2;
        }
        return result.toString();
    }

    public File importFile(String revision, String path, File temp) {
        SVNRepository svnRepository = this.getSVNRepository();
        long rev = revision == null ? SVNRevision.HEAD.getNumber() : Long.valueOf(revision).longValue();
        try {
            SVNNodeKind node = svnRepository.checkPath(path, rev);
            if (node == SVNNodeKind.NONE) {
                return null;
            }
        }
        catch (SVNException e1) {
            this.console.printerrln((Throwable)e1);
            return null;
        }
        try {
            Throwable e1 = null;
            Object var8_10 = null;
            try (FileOutputStream fOS = new FileOutputStream(temp);){
                svnRepository.getFile(path, rev, new SVNProperties(), (OutputStream)fOS);
                return temp;
            }
            catch (Throwable throwable) {
                if (e1 == null) {
                    e1 = throwable;
                } else if (e1 != throwable) {
                    e1.addSuppressed(throwable);
                }
                throw e1;
            }
        }
        catch (Exception e) {
            this.console.printerrln((Throwable)e);
            return null;
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void shutdown() {
        this.repositoryURL = null;
        this.console = null;
    }

    public String getLocation() {
        return this.repositoryURL;
    }

    public void setCredentials(String username, String password, ICredentialsStore credStore) {
        if (!(username == null || password == null || this.repositoryURL == null || username.equals(this.username) && password.equals(this.password))) {
            try {
                credStore.put(this.repositoryURL, new ICredentialsStore.Credentials(username, password));
            }
            catch (Exception e) {
                this.console.printerrln("Could not save new username/password");
                this.console.printerrln((Throwable)e);
            }
        }
        this.username = username;
        this.password = password;
        this.svnRepository = null;
    }

    public String getHumanReadableName() {
        return "SVN Monitor";
    }

    public Collection<VcsCommitItem> getDelta(String startRevision) throws Exception {
        if (Long.valueOf(startRevision) < 0L) {
            return this.getDelta(null, this.getCurrentRevision()).getCompactedCommitItems();
        }
        return this.getDelta(startRevision, this.getCurrentRevision()).getCompactedCommitItems();
    }

    public boolean isAuthSupported() {
        return true;
    }

    public boolean isPathLocationAccepted() {
        return false;
    }

    public boolean isURLLocationAccepted() {
        return true;
    }

    public String getRepositoryPath(String rawPath) {
        if (rawPath.startsWith(this.repositoryURL)) {
            return rawPath.substring(this.repositoryURL.length());
        }
        return rawPath;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isFrozen() {
        return this.isFrozen;
    }

    public void setFrozen(boolean f) {
        this.isFrozen = f;
    }

    public String getDefaultLocation() {
        return "svn://";
    }
}

