/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.modelio.exml.model.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.eclipse.hawk.modelio.exml.model.parser.ExmlObject;
import org.eclipse.hawk.modelio.exml.model.parser.ExmlReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExmlParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExmlParser.class);

    public ExmlObject getObject(File container, InputStream is) throws XMLStreamException, FactoryConfigurationError {
        try (XMLEventReader reader = XMLInputFactory.newFactory().createXMLEventReader(is);){
            this.skipUntilElementStarts(reader, "OBJECT");
            ExmlObject exmlObj = new ExmlObject(container);
            this.fillObject(reader, exmlObj);
            ExmlObject exmlObject = exmlObj;
            return exmlObject;
        }
    }

    public Iterable<ExmlObject> getObjects(final File fZip) {
        return new Iterable<ExmlObject>(){

            @Override
            public Iterator<ExmlObject> iterator() {
                try {
                    final ZipFile zipFile = new ZipFile(fZip);
                    final Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    return new Iterator<ExmlObject>(){
                        ExmlObject nextObject = null;
                        boolean closed = false;

                        @Override
                        public boolean hasNext() {
                            return this.findNextObject(entries) != null;
                        }

                        @Override
                        public ExmlObject next() {
                            ExmlObject ret = this.findNextObject(entries);
                            this.nextObject = null;
                            return ret;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        private ExmlObject findNextObject(Enumeration<? extends ZipEntry> entries2) {
                            while (!this.closed && this.nextObject == null && entries2.hasMoreElements()) {
                                ZipEntry entry = entries2.nextElement();
                                if (!entry.getName().toLowerCase().endsWith(".exml")) continue;
                                try {
                                    Throwable throwable = null;
                                    Object var4_7 = null;
                                    try (InputStream is = zipFile.getInputStream(entry);){
                                        this.nextObject = ExmlParser.this.getObject(fZip, is);
                                    }
                                    catch (Throwable throwable2) {
                                        if (throwable == null) {
                                            throwable = throwable2;
                                        } else if (throwable != throwable2) {
                                            throwable.addSuppressed(throwable2);
                                        }
                                        throw throwable;
                                    }
                                }
                                catch (IOException | FactoryConfigurationError | XMLStreamException e) {
                                    LOGGER.error("Could not parse entry " + entry.getName() + " in " + zipFile.getName() + ": skipping", e);
                                }
                            }
                            if (this.nextObject == null) {
                                try {
                                    this.closed = true;
                                    zipFile.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            return this.nextObject;
                        }
                    };
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    return Collections.emptyIterator();
                }
            }
        };
    }

    private void fillObject(XMLEventReader reader, ExmlObject exmlObj) throws XMLStreamException {
        XMLEvent ev;
        String currentLink = null;
        String currentComp = null;
        do {
            block43: {
                if (!(ev = this.skipUntilElement(reader)).isStartElement()) break block43;
                StartElement evStart = ev.asStartElement();
                switch (evStart.getName().getLocalPart()) {
                    case "ID": 
                    case "EXTID": 
                    case "FOREIGNID": {
                        ExmlReference ref;
                        if (currentLink != null) {
                            ref = new ExmlReference(exmlObj.getFile());
                            this.fillInReference(evStart, ref);
                            exmlObj.addToLink(currentLink, ref);
                            break;
                        }
                        if (currentComp != null) {
                            ref = new ExmlReference(exmlObj.getFile());
                            this.fillInReference(evStart, ref);
                            exmlObj.addToComposition(currentComp, ref);
                            break;
                        }
                        this.fillInReference(evStart, exmlObj);
                        break;
                    }
                    case "PID": {
                        exmlObj.setParentName(this.getAttribute(evStart, "name"));
                        exmlObj.setParentMClassName(this.getAttribute(evStart, "mc"));
                        exmlObj.setParentUID(this.getAttribute(evStart, "uid"));
                        break;
                    }
                    case "COMPID": {
                        ExmlReference ref = new ExmlReference(exmlObj.getFile());
                        this.fillInReference(evStart, ref);
                        exmlObj.addToComposition(currentComp, ref);
                        break;
                    }
                    case "ATT": {
                        exmlObj.setAttribute(this.getAttribute(evStart, "name"), reader.getElementText());
                        break;
                    }
                    case "LINK": {
                        currentLink = this.getAttribute(evStart, "relation");
                        break;
                    }
                    case "COMP": {
                        currentComp = this.getAttribute(evStart, "relation");
                        break;
                    }
                    case "OBJECT": {
                        if (currentComp != null) {
                            ExmlObject compObj = new ExmlObject(exmlObj.getFile());
                            this.fillObject(reader, compObj);
                            exmlObj.addToComposition(currentComp, compObj);
                            break;
                        }
                        throw new IllegalArgumentException("Unexpected <OBJECT> outside a composition");
                    }
                }
                continue;
            }
            if (!ev.isEndElement()) continue;
            switch (ev.asEndElement().getName().getLocalPart()) {
                case "LINK": {
                    currentLink = null;
                    break;
                }
                case "COMP": {
                    currentComp = null;
                }
            }
        } while (!ev.isEndElement() || !ev.asEndElement().getName().getLocalPart().equals("OBJECT"));
    }

    private void fillInReference(StartElement evStart, ExmlReference ref) {
        if (ref.getName() == null) {
            ref.setName(this.getAttribute(evStart, "name"));
            ref.setMClassName(this.getAttribute(evStart, "mc"));
            ref.setUID(this.getAttribute(evStart, "uid"));
        } else {
            System.err.println("WARNING: tried to overwrite reference " + ref);
        }
    }

    private String getAttribute(StartElement evStart, String attr) {
        return evStart.getAttributeByName(new QName(attr)).getValue();
    }

    private XMLEvent skipUntilElement(XMLEventReader reader) throws XMLStreamException {
        XMLEvent ev = reader.nextEvent();
        while (!ev.isStartElement() && !ev.isEndElement()) {
            ev = reader.nextEvent();
        }
        return ev;
    }

    private XMLEvent skipUntilElementStarts(XMLEventReader reader, String localPart) throws XMLStreamException {
        XMLEvent ev = reader.nextEvent();
        while (!ev.isStartElement() || !ev.asStartElement().getName().getLocalPart().equals(localPart)) {
            ev = reader.nextEvent();
        }
        return ev;
    }
}

