/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc;

import io.quarkus.arc.InjectableReferenceProvider;
import io.quarkus.arc.impl.Qualifiers;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;

public interface InjectableBean<T>
extends Bean<T>,
InjectableReferenceProvider<T> {
    public String getIdentifier();

    default public Kind getKind() {
        return Kind.CLASS;
    }

    @Override
    default public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    @Override
    public Set<Type> getTypes();

    @Override
    default public Set<Annotation> getQualifiers() {
        return Qualifiers.DEFAULT_QUALIFIERS;
    }

    @Override
    default public void destroy(T instance, CreationalContext<T> creationalContext) {
        creationalContext.release();
    }

    default public InjectableBean<?> getDeclaringBean() {
        return null;
    }

    @Override
    default public String getName() {
        return null;
    }

    @Override
    default public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    @Override
    default public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    @Override
    @Deprecated
    default public boolean isNullable() {
        return false;
    }

    @Override
    default public boolean isAlternative() {
        return false;
    }

    default public Integer getAlternativePriority() {
        return this.isAlternative() ? Integer.valueOf(this.getPriority()) : null;
    }

    default public boolean isDefaultBean() {
        return false;
    }

    default public boolean isSuppressed() {
        return false;
    }

    default public int getPriority() {
        return 0;
    }

    public static enum Kind {
        CLASS,
        PRODUCER_FIELD,
        PRODUCER_METHOD,
        SYNTHETIC,
        INTERCEPTOR,
        DECORATOR;


        public static Kind from(String value) {
            for (Kind kind : Kind.values()) {
                if (!kind.toString().equals(value)) continue;
                return kind;
            }
            return null;
        }
    }
}

