/*
 * Decompiled with CFR 0.152.
 */
package com.aayushatharva.brotli4j;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class Brotli4jLoader {
    private static final Throwable UNAVAILABILITY_CAUSE;

    public static boolean isAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    public static void ensureAvailability() {
        if (UNAVAILABILITY_CAUSE != null) {
            UnsatisfiedLinkError error = new UnsatisfiedLinkError("Failed to load Brotli native library");
            error.initCause(UNAVAILABILITY_CAUSE);
            throw error;
        }
    }

    public static Throwable getUnavailabilityCause() {
        return UNAVAILABILITY_CAUSE;
    }

    private static String getPlatform() {
        String osName = System.getProperty("os.name");
        String archName = System.getProperty("os.arch");
        if (osName.equalsIgnoreCase("Linux")) {
            if (archName.equalsIgnoreCase("amd64")) {
                return "linux-x86_64";
            }
            if (archName.equalsIgnoreCase("aarch64")) {
                return "linux-aarch64";
            }
        } else if (osName.startsWith("Windows")) {
            if (archName.equalsIgnoreCase("amd64")) {
                return "windows-x86_64";
            }
        } else if (osName.startsWith("Mac") && archName.equalsIgnoreCase("x86_64")) {
            return "osx-x86_64";
        }
        throw new UnsupportedOperationException("Unsupported OS and Architecture: " + osName + ", " + archName);
    }

    static {
        Throwable cause = null;
        try {
            System.loadLibrary("brotli");
        }
        catch (Throwable t) {
            try {
                String nativeLibName = System.mapLibraryName("brotli");
                String libPath = "/lib/" + Brotli4jLoader.getPlatform() + "/" + nativeLibName;
                File tempDir = new File(System.getProperty("java.io.tmpdir"), "com_aayushatharva_brotli4j_" + System.nanoTime());
                tempDir.mkdir();
                tempDir.deleteOnExit();
                File tempFile = new File(tempDir, nativeLibName);
                try (InputStream in = Brotli4jLoader.class.getResourceAsStream(libPath);){
                    Files.copy(in, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable) {
                    tempFile.delete();
                    throw throwable;
                }
                System.load(tempFile.getAbsolutePath());
            }
            catch (Throwable throwable) {
                cause = throwable;
            }
        }
        UNAVAILABILITY_CAUSE = cause;
    }
}

