/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codegen.doc;

import io.vertx.codegen.doc.Token;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Text {
    final String value;
    final List<Token> tokens;

    public Text(String value) {
        this.value = value;
        this.tokens = Token.tokenize(value);
    }

    private Text(String value, List<Token> tokens) {
        this.value = value;
        this.tokens = tokens;
    }

    public String getValue() {
        return this.value;
    }

    public Text map(Function<Token, Token> mapping) {
        return new Text(this.value, this.tokens.stream().map(mapping).collect(Collectors.toList()));
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Text) {
            Text that = (Text)o;
            return this.value.equals(that.value);
        }
        return false;
    }

    public String toString() {
        return this.value;
    }
}

