/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.groups.MultiResource;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;

public class MultiResourceUni<R, I> {
    private final Function<? super R, ? extends Publisher<I>> streamSupplier;
    private final Supplier<Uni<R>> resourceSupplier;

    public MultiResourceUni(Supplier<Uni<R>> resourceSupplier, Function<? super R, ? extends Publisher<I>> streamSupplier) {
        this.resourceSupplier = resourceSupplier;
        this.streamSupplier = streamSupplier;
    }

    @CheckReturnValue
    public Multi<I> withFinalizer(Consumer<? super R> finalizer) {
        Function actual = MultiResource.getUniFunction(finalizer);
        return this.withFinalizer(actual, (r, ignored) -> (Uni)actual.apply((Object)r), actual);
    }

    @CheckReturnValue
    public Multi<I> withFinalizer(Function<? super R, Uni<Void>> finalizer) {
        Function actual = Infrastructure.decorate(ParameterValidation.nonNull(finalizer, "finalizer"));
        return this.withFinalizer(actual, (r, ignored) -> (Uni)actual.apply((Object)r), actual);
    }

    @CheckReturnValue
    public Multi<I> withFinalizer(Function<? super R, Uni<Void>> onCompletion, BiFunction<? super R, ? super Throwable, Uni<Void>> onFailure, Function<? super R, Uni<Void>> onCancellation) {
        return Uni.createFrom().deferred(() -> {
            Uni<R> uni;
            try {
                uni = this.resourceSupplier.get();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            if (uni == null) {
                throw new IllegalArgumentException("The supplier returned `null`");
            }
            return uni;
        }).onItem().transformToMulti(res -> Multi.createFrom().resource(() -> res, this.streamSupplier).withFinalizer(onCompletion, onFailure, onCancellation));
    }
}

