/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.mutiny.core.file;

import io.smallrye.common.annotation.CheckReturnValue;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.AsyncResultUni;
import io.smallrye.mutiny.vertx.DelegatingConsumerHandler;
import io.smallrye.mutiny.vertx.DelegatingHandler;
import io.smallrye.mutiny.vertx.MultiHelper;
import io.smallrye.mutiny.vertx.MutinyGen;
import io.smallrye.mutiny.vertx.MutinyHelper;
import io.smallrye.mutiny.vertx.TypeArg;
import io.smallrye.mutiny.vertx.UniHelper;
import io.smallrye.mutiny.vertx.WriteStreamSubscriber;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.core.file.AsyncFileLock;
import io.vertx.mutiny.core.streams.Pipe;
import io.vertx.mutiny.core.streams.ReadStream;
import io.vertx.mutiny.core.streams.WriteStream;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;

@MutinyGen(value=io.vertx.core.file.AsyncFile.class)
public class AsyncFile
implements ReadStream<Buffer>,
WriteStream<Buffer> {
    public static final TypeArg<AsyncFile> __TYPE_ARG = new TypeArg<AsyncFile>(obj -> new AsyncFile((io.vertx.core.file.AsyncFile)obj), AsyncFile::getDelegate);
    private final io.vertx.core.file.AsyncFile delegate;
    static final TypeArg<Buffer> TYPE_ARG_0 = new TypeArg<Buffer>(o1 -> Buffer.newInstance((io.vertx.core.buffer.Buffer)o1), o1 -> o1.getDelegate());
    private WriteStreamSubscriber<Buffer> subscriber;
    private Multi<Buffer> multi;

    public AsyncFile(io.vertx.core.file.AsyncFile delegate) {
        this.delegate = delegate;
    }

    public AsyncFile(Object delegate) {
        this.delegate = (io.vertx.core.file.AsyncFile)delegate;
    }

    AsyncFile() {
        this.delegate = null;
    }

    @Override
    public io.vertx.core.file.AsyncFile getDelegate() {
        return this.delegate;
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncFile that = (AsyncFile)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @CheckReturnValue
    public synchronized WriteStreamSubscriber<Buffer> toSubscriber() {
        if (this.subscriber == null) {
            Function<Buffer, io.vertx.core.buffer.Buffer> conv = Buffer::getDelegate;
            this.subscriber = MutinyHelper.toSubscriber(this.getDelegate(), conv);
        }
        return this.subscriber;
    }

    @Override
    public Pipe<Buffer> pipe() {
        Pipe<Buffer> ret = Pipe.newInstance(this.delegate.pipe(), TYPE_ARG_0);
        return ret;
    }

    @Override
    @CheckReturnValue
    public Uni<Void> pipeTo(WriteStream<Buffer> dst) {
        return AsyncResultUni.toUni(handler -> this.delegate.pipeTo(dst.getDelegate(), (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void pipeToAndAwait(WriteStream<Buffer> dst) {
        return this.pipeTo(dst).await().indefinitely();
    }

    @Override
    public void pipeToAndForget(WriteStream<Buffer> dst) {
        this.pipeTo(dst).subscribe().with(UniHelper.NOOP);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> write(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.delegate.write(data.getDelegate(), (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void writeAndAwait(Buffer data) {
        return this.write(data).await().indefinitely();
    }

    @Override
    public void writeAndForget(Buffer data) {
        this.write(data).subscribe().with(UniHelper.NOOP);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> end() {
        return AsyncResultUni.toUni(handler -> this.delegate.end((Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void endAndAwait() {
        return this.end().await().indefinitely();
    }

    @Override
    public void endAndForget() {
        this.end().subscribe().with(UniHelper.NOOP);
    }

    @Override
    @CheckReturnValue
    public Uni<Void> end(Buffer data) {
        return AsyncResultUni.toUni(handler -> this.delegate.end(data.getDelegate(), (Handler<AsyncResult<Void>>)handler));
    }

    @Override
    public Void endAndAwait(Buffer data) {
        return this.end(data).await().indefinitely();
    }

    @Override
    public void endAndForget(Buffer data) {
        this.end(data).subscribe().with(UniHelper.NOOP);
    }

    @Override
    public boolean writeQueueFull() {
        boolean ret = this.delegate.writeQueueFull();
        return ret;
    }

    @Fluent
    private AsyncFile __handler(Handler<Buffer> handler) {
        this.delegate.handler(new DelegatingHandler<io.vertx.core.buffer.Buffer, Buffer>(handler, event -> Buffer.newInstance(event)));
        return this;
    }

    public AsyncFile handler(Consumer<Buffer> handler) {
        return this.__handler((Handler<Buffer>)(handler != null ? new DelegatingConsumerHandler<Buffer>(handler) : null));
    }

    @Fluent
    public AsyncFile pause() {
        this.delegate.pause();
        return this;
    }

    @Fluent
    public AsyncFile resume() {
        this.delegate.resume();
        return this;
    }

    @Fluent
    private AsyncFile __endHandler(Handler<Void> endHandler) {
        this.delegate.endHandler((Handler)endHandler);
        return this;
    }

    public AsyncFile endHandler(Runnable endHandler) {
        return this.__endHandler(ignored -> endHandler.run());
    }

    @Fluent
    public AsyncFile setWriteQueueMaxSize(int maxSize) {
        this.delegate.setWriteQueueMaxSize(maxSize);
        return this;
    }

    @Fluent
    private AsyncFile __drainHandler(Handler<Void> handler) {
        this.delegate.drainHandler((Handler)handler);
        return this;
    }

    public AsyncFile drainHandler(Runnable handler) {
        return this.__drainHandler(ignored -> handler.run());
    }

    @Fluent
    private AsyncFile __exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler((Handler)handler);
        return this;
    }

    @Override
    public AsyncFile exceptionHandler(Consumer<Throwable> handler) {
        return this.__exceptionHandler((Handler<Throwable>)(handler != null ? new DelegatingConsumerHandler<Throwable>(handler) : null));
    }

    @Fluent
    public AsyncFile fetch(long amount) {
        this.delegate.fetch(amount);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> close() {
        return AsyncResultUni.toUni(handler -> this.delegate.close((Handler<AsyncResult<Void>>)handler));
    }

    public Void closeAndAwait() {
        return this.close().await().indefinitely();
    }

    public void closeAndForget() {
        this.close().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Void> write(Buffer buffer, long position) {
        return AsyncResultUni.toUni(handler -> this.delegate.write(buffer.getDelegate(), position, (Handler<AsyncResult<Void>>)handler));
    }

    public Void writeAndAwait(Buffer buffer, long position) {
        return this.write(buffer, position).await().indefinitely();
    }

    public void writeAndForget(Buffer buffer, long position) {
        this.write(buffer, position).subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<Buffer> read(Buffer buffer, int offset, long position, int length) {
        return AsyncResultUni.toUni(handler -> this.delegate.read(buffer.getDelegate(), offset, position, length, new DelegatingHandler<AsyncResult, AsyncResult>((Handler<AsyncResult>)handler, ar -> ar.map(event -> Buffer.newInstance(event)))));
    }

    public Buffer readAndAwait(Buffer buffer, int offset, long position, int length) {
        return this.read(buffer, offset, position, length).await().indefinitely();
    }

    @Fluent
    public AsyncFile readAndForget(Buffer buffer, int offset, long position, int length) {
        this.read(buffer, offset, position, length).subscribe().with(UniHelper.NOOP);
        return this;
    }

    @CheckReturnValue
    public Uni<Void> flush() {
        return AsyncResultUni.toUni(handler -> this.delegate.flush((Handler<AsyncResult<Void>>)handler));
    }

    public Void flushAndAwait() {
        return this.flush().await().indefinitely();
    }

    @Fluent
    public AsyncFile flushAndForget() {
        this.flush().subscribe().with(UniHelper.NOOP);
        return this;
    }

    @Fluent
    public AsyncFile setReadPos(long readPos) {
        this.delegate.setReadPos(readPos);
        return this;
    }

    @Fluent
    public AsyncFile setReadLength(long readLength) {
        this.delegate.setReadLength(readLength);
        return this;
    }

    public long getReadLength() {
        long ret = this.delegate.getReadLength();
        return ret;
    }

    @Fluent
    public AsyncFile setWritePos(long writePos) {
        this.delegate.setWritePos(writePos);
        return this;
    }

    public long getWritePos() {
        long ret = this.delegate.getWritePos();
        return ret;
    }

    @Fluent
    public AsyncFile setReadBufferSize(int readBufferSize) {
        this.delegate.setReadBufferSize(readBufferSize);
        return this;
    }

    public long sizeBlocking() {
        long ret = this.delegate.sizeBlocking();
        return ret;
    }

    @CheckReturnValue
    public Uni<Long> size() {
        return AsyncResultUni.toUni(handler -> this.delegate.size((Handler<AsyncResult<Long>>)handler));
    }

    public Long sizeAndAwait() {
        return this.size().await().indefinitely();
    }

    public void sizeAndForget() {
        this.size().subscribe().with(UniHelper.NOOP);
    }

    public AsyncFileLock tryLock() {
        AsyncFileLock ret = AsyncFileLock.newInstance(this.delegate.tryLock());
        return ret;
    }

    public AsyncFileLock tryLock(long position, long size, boolean shared) {
        AsyncFileLock ret = AsyncFileLock.newInstance(this.delegate.tryLock(position, size, shared));
        return ret;
    }

    @CheckReturnValue
    public Uni<AsyncFileLock> lock() {
        return AsyncResultUni.toUni(handler -> this.delegate.lock(new DelegatingHandler<AsyncResult, AsyncResult>((Handler<AsyncResult>)handler, ar -> ar.map(event -> AsyncFileLock.newInstance(event)))));
    }

    public AsyncFileLock lockAndAwait() {
        return this.lock().await().indefinitely();
    }

    public void lockAndForget() {
        this.lock().subscribe().with(UniHelper.NOOP);
    }

    @CheckReturnValue
    public Uni<AsyncFileLock> lock(long position, long size, boolean shared) {
        return AsyncResultUni.toUni(handler -> this.delegate.lock(position, size, shared, new DelegatingHandler<AsyncResult, AsyncResult>((Handler<AsyncResult>)handler, ar -> ar.map(event -> AsyncFileLock.newInstance(event)))));
    }

    public AsyncFileLock lockAndAwait(long position, long size, boolean shared) {
        return this.lock(position, size, shared).await().indefinitely();
    }

    public void lockAndForget(long position, long size, boolean shared) {
        this.lock(position, size, shared).subscribe().with(UniHelper.NOOP);
    }

    @Override
    @CheckReturnValue
    public synchronized Multi<Buffer> toMulti() {
        if (this.multi == null) {
            Function<io.vertx.core.buffer.Buffer, Buffer> conv = Buffer::newInstance;
            this.multi = MultiHelper.toMulti(this.delegate, conv);
        }
        return this.multi;
    }

    public Iterable<Buffer> toBlockingIterable() {
        return this.toMulti().subscribe().asIterable();
    }

    public Stream<Buffer> toBlockingStream() {
        return this.toMulti().subscribe().asStream();
    }

    public static AsyncFile newInstance(io.vertx.core.file.AsyncFile arg) {
        return arg != null ? new AsyncFile(arg) : null;
    }
}

