/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.TrustAnchor;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.security.auth.x500.X500Principal;
import org.eclipse.hono.util.Adapter;
import org.eclipse.hono.util.JsonBackedValueObject;
import org.eclipse.hono.util.ResourceLimits;
import org.eclipse.hono.util.RevocableTrustAnchor;
import org.eclipse.hono.util.TenantTracingConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public final class TenantObject
extends JsonBackedValueObject {
    private static final Logger LOG = LoggerFactory.getLogger(TenantObject.class);
    @JsonIgnore
    private List<Adapter> adapters;
    @JsonIgnore
    private ResourceLimits resourceLimits;
    @JsonIgnore
    private TenantTracingConfig tracingConfig;
    @JsonIgnore
    private Set<TrustAnchor> trustAnchors;

    public TenantObject(@JsonProperty(value="tenant-id", required=true) String tenantId, @JsonProperty(value="enabled", required=true) boolean enabled) {
        Objects.requireNonNull(tenantId);
        this.setProperty("tenant-id", tenantId);
        this.setProperty("enabled", enabled);
    }

    @JsonAnySetter
    public TenantObject setProperty(String name, Object value) {
        this.json.put(Objects.requireNonNull(name), value);
        return this;
    }

    @JsonIgnore
    public String getTenantId() {
        return this.getProperty("tenant-id", String.class);
    }

    @JsonIgnore
    public boolean isEnabled() {
        return this.getProperty("enabled", Boolean.class, true);
    }

    @JsonIgnore
    public TenantObject setTrustAnchor(PublicKey publicKey, X500Principal subjectDn) {
        Objects.requireNonNull(publicKey);
        Objects.requireNonNull(subjectDn);
        this.setProperty("trusted-ca", new JsonArray());
        return this.addTrustAnchor(publicKey, subjectDn, false);
    }

    @JsonIgnore
    public TenantObject addTrustAnchor(PublicKey publicKey, X500Principal subjectDn, Boolean autoProvisioningEnabled) {
        Objects.requireNonNull(publicKey);
        Objects.requireNonNull(subjectDn);
        return this.addTrustAnchor(publicKey.getEncoded(), publicKey.getAlgorithm(), subjectDn, null, autoProvisioningEnabled);
    }

    @JsonIgnore
    public TenantObject addTrustAnchor(byte[] publicKey, String publicKeyAlgorithm, X500Principal subjectDn, String authIdTemplate, Boolean autoProvisioningEnabled) {
        Objects.requireNonNull(publicKey);
        Objects.requireNonNull(publicKeyAlgorithm);
        Objects.requireNonNull(subjectDn);
        JsonObject trustedCa = new JsonObject();
        trustedCa.put("subject-dn", subjectDn.getName("RFC2253"));
        trustedCa.put("public-key", publicKey);
        trustedCa.put("algorithm", publicKeyAlgorithm);
        trustedCa.put("auto-provisioning-enabled", autoProvisioningEnabled);
        Optional.ofNullable(authIdTemplate).ifPresent(t -> trustedCa.put("auth-id-template", t));
        JsonArray cas = this.getProperty("trusted-ca", JsonArray.class, new JsonArray());
        this.trustAnchors = null;
        return this.setProperty("trusted-ca", cas.add(trustedCa));
    }

    @JsonIgnore
    public Set<TrustAnchor> getTrustAnchors() {
        if (this.trustAnchors == null) {
            this.trustAnchors = this.getProperty("trusted-ca", JsonArray.class, new JsonArray()).stream().filter(obj -> obj instanceof JsonObject).map(JsonObject.class::cast).map(this::getTrustAnchorForPublicKey).filter(anchor -> anchor != null).collect(Collectors.toSet());
        }
        return this.trustAnchors;
    }

    @JsonIgnore
    private TrustAnchor getTrustAnchorForPublicKey(JsonObject keyProps) {
        X500Principal principal;
        if (keyProps == null) {
            return null;
        }
        byte[] subjectDnBytes = TenantObject.getProperty(keyProps, "subject-dn-bytes", byte[].class);
        if (subjectDnBytes != null) {
            principal = new X500Principal(subjectDnBytes);
        } else {
            String subjectDn = TenantObject.getProperty(keyProps, "subject-dn", String.class);
            if (subjectDn == null) {
                LOG.debug("trust anchor definition does not contain required property {}", (Object)"subject-dn");
                return null;
            }
            principal = new X500Principal(subjectDn);
        }
        byte[] encodedKey = TenantObject.getProperty(keyProps, "public-key", byte[].class);
        if (encodedKey == null) {
            LOG.debug("trust anchor definition does not contain required property {}", (Object)"public-key");
            return null;
        }
        try {
            String type = TenantObject.getProperty(keyProps, "algorithm", String.class, "RSA");
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
            KeyFactory factory = KeyFactory.getInstance(type);
            PublicKey publicKey = factory.generatePublic(keySpec);
            return new RevocableTrustAnchor(principal, publicKey, null, keyProps);
        }
        catch (GeneralSecurityException e) {
            LOG.debug("failed to instantiate trust anchor's public key", e);
            return null;
        }
    }

    @JsonIgnore
    public boolean isAutoProvisioningEnabled(String subjectDn) {
        Objects.requireNonNull(subjectDn);
        return this.getProperty("trusted-ca", JsonArray.class, new JsonArray()).stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(ca -> subjectDn.equals(TenantObject.getProperty(ca, "subject-dn", String.class))).map(caInUse -> TenantObject.getProperty(caInUse, "auto-provisioning-enabled", Boolean.class, false)).findFirst().orElse(false);
    }

    @JsonIgnore
    public Optional<String> getAuthIdTemplate(String subjectDn) {
        Objects.requireNonNull(subjectDn, "Subject DN must not be null");
        return this.getProperty("trusted-ca", JsonArray.class, new JsonArray()).stream().filter(JsonObject.class::isInstance).map(JsonObject.class::cast).filter(ca -> subjectDn.equals(TenantObject.getProperty(ca, "subject-dn", String.class))).map(caInUse -> TenantObject.getProperty(caInUse, "auth-id-template", String.class)).filter(Objects::nonNull).findFirst();
    }

    @JsonProperty(value="adapters")
    public List<Adapter> getAdapters() {
        return this.adapters;
    }

    @JsonProperty(value="adapters")
    public TenantObject setAdapters(List<Adapter> adapters) {
        this.adapters = this.validateAdapterTypes(adapters);
        return this;
    }

    @JsonIgnore
    private List<Adapter> validateAdapterTypes(List<Adapter> adapters) {
        if (adapters != null) {
            Set uniqueAdapterTypes = adapters.stream().map(Adapter::getType).collect(Collectors.toSet());
            if (adapters.size() != uniqueAdapterTypes.size()) {
                throw new IllegalArgumentException("Each adapter must have a unique type");
            }
        }
        return adapters;
    }

    @JsonIgnore
    public Adapter getAdapter(String type) {
        Objects.requireNonNull(type);
        return Optional.ofNullable(this.adapters).flatMap(ok -> this.adapters.stream().filter(adapter -> type.equals(adapter.getType())).findFirst()).orElse(null);
    }

    public TenantObject addAdapter(Adapter adapter) {
        Objects.requireNonNull(adapter);
        if (this.adapters == null) {
            this.adapters = new ArrayList<Adapter>();
        } else if (this.getAdapter(adapter.getType()) != null) {
            throw new IllegalArgumentException(String.format("Already an adapter of the type [%s] exists", adapter.getType()));
        }
        this.adapters.add(adapter);
        return this;
    }

    @JsonIgnore
    public boolean isAdapterEnabled(String typeName) {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.adapters == null) {
            return true;
        }
        Adapter adapter = this.getAdapter(typeName);
        if (adapter == null) {
            return false;
        }
        return adapter.isEnabled();
    }

    @JsonIgnore
    public int getMaxTimeUntilDisconnect(String typeName) {
        Objects.requireNonNull(typeName);
        return Optional.ofNullable(this.getAdapter(typeName)).map(Adapter::getExtensions).map(extensions -> {
            try {
                return (Integer)extensions.get("max-ttd");
            }
            catch (ClassCastException e) {
                return null;
            }
        }).filter(maxTtd -> maxTtd >= 0).orElse(60);
    }

    public static TenantObject from(String tenantId) {
        return new TenantObject(tenantId, true);
    }

    public static TenantObject from(String tenantId, boolean enabled) {
        return new TenantObject(tenantId, enabled);
    }

    @JsonGetter(value="resource-limits")
    public ResourceLimits getResourceLimits() {
        return this.resourceLimits;
    }

    @JsonIgnore
    public TenantObject setResourceLimits(JsonObject resourceLimits) {
        return this.setResourceLimits((ResourceLimits)Optional.of(resourceLimits).map(json -> json.mapTo(ResourceLimits.class)).orElse(null));
    }

    @JsonSetter(value="resource-limits")
    public TenantObject setResourceLimits(ResourceLimits resourceLimits) {
        this.resourceLimits = resourceLimits;
        return this;
    }

    @JsonIgnore
    public int getMinimumMessageSize() {
        return this.getProperty("minimum-message-size", Integer.class, 0);
    }

    public TenantObject setMinimumMessageSize(int payloadSize) {
        if (payloadSize < 0) {
            throw new IllegalArgumentException("message payload size must be >= 0");
        }
        return this.setProperty("minimum-message-size", payloadSize);
    }

    @JsonIgnore
    public JsonObject getDefaults() {
        return this.getProperty("defaults", JsonObject.class, new JsonObject());
    }

    @JsonIgnore
    public TenantObject setDefaults(JsonObject defaultProperties) {
        this.setProperty("defaults", Objects.requireNonNull(defaultProperties));
        return this;
    }

    @JsonProperty(value="tracing")
    public TenantTracingConfig getTracingConfig() {
        return this.tracingConfig;
    }

    @JsonProperty(value="tracing")
    public TenantObject setTracingConfig(TenantTracingConfig tracing) {
        this.tracingConfig = tracing;
        return this;
    }
}

