/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.matchers.psystem.queries;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import org.eclipse.incquery.runtime.matchers.psystem.IQueryReference;
import org.eclipse.incquery.runtime.matchers.psystem.PBody;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;

public final class PQueries {
    private PQueries() {
    }

    public static Predicate<PQuery> queryStatusPredicate(final PQuery.PQueryStatus status) {
        return new Predicate<PQuery>(){

            public boolean apply(PQuery query) {
                return query.getStatus().equals((Object)status);
            }
        };
    }

    public static Function<PQuery, String> queryNameFunction() {
        return new Function<PQuery, String>(){

            public String apply(PQuery query) {
                return query.getFullyQualifiedName();
            }
        };
    }

    public static Function<PParameter, String> parameterNameFunction() {
        return new Function<PParameter, String>(){

            public String apply(PParameter param) {
                return param.getName();
            }
        };
    }

    public static Function<IQueryReference, PQuery> queryOfReferenceFunction() {
        return new Function<IQueryReference, PQuery>(){

            public PQuery apply(IQueryReference reference) {
                return reference.getReferredQuery();
            }
        };
    }

    public static Function<PBody, Iterable<PQuery>> directlyReferencedQueriesFunction() {
        return new Function<PBody, Iterable<PQuery>>(){

            public Iterable<PQuery> apply(PBody body) {
                return Iterables.transform(body.getConstraintsOfType(IQueryReference.class), PQueries.queryOfReferenceFunction());
            }
        };
    }
}

