/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.po.parser.session;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.keyple.command.AbstractApduResponseParser;
import org.eclipse.keyple.seproxy.message.ApduResponse;

public final class CloseSessionRespPars
extends AbstractApduResponseParser {
    private static final Map<Integer, AbstractApduResponseParser.StatusProperties> STATUS_TABLE;
    private byte[] signatureLo;
    private byte[] postponedData;

    protected Map<Integer, AbstractApduResponseParser.StatusProperties> getStatusTable() {
        return STATUS_TABLE;
    }

    public CloseSessionRespPars(ApduResponse response) {
        super(response);
        this.parse(response.getDataOut());
    }

    private void parse(byte[] response) {
        if (response.length == 8) {
            this.signatureLo = Arrays.copyOfRange(response, 4, 8);
            this.postponedData = Arrays.copyOfRange(response, 0, 4);
        } else if (response.length == 4) {
            this.signatureLo = Arrays.copyOfRange(response, 0, 4);
        } else if (response.length != 0) {
            throw new IllegalArgumentException("Unexpected length in response to CloseSecureSession command: " + response.length);
        }
    }

    public byte[] getSignatureLo() {
        return this.signatureLo;
    }

    public byte[] getPostponedData() {
        return this.postponedData;
    }

    static {
        HashMap<Integer, AbstractApduResponseParser.StatusProperties> m = new HashMap<Integer, AbstractApduResponseParser.StatusProperties>(AbstractApduResponseParser.STATUS_TABLE);
        m.put(26368, new AbstractApduResponseParser.StatusProperties(false, "Lc signatureLo not supported (e.g. Lc=4 with a Revision 3.2 mode for Open Secure Session)."));
        m.put(27392, new AbstractApduResponseParser.StatusProperties(false, "P1 or P2 signatureLo not supported."));
        m.put(27016, new AbstractApduResponseParser.StatusProperties(false, "incorrect signatureLo."));
        m.put(27013, new AbstractApduResponseParser.StatusProperties(false, "No session was opened."));
        STATUS_TABLE = m;
    }
}

