/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.command.sam.builder.session;

import org.eclipse.keyple.calypso.command.sam.CalypsoSamCommands;
import org.eclipse.keyple.calypso.command.sam.SamCommandBuilder;
import org.eclipse.keyple.calypso.command.sam.SamRevision;

public class DigestInitCmdBuild
extends SamCommandBuilder {
    private static final CalypsoSamCommands command = CalypsoSamCommands.DIGEST_INIT;

    public DigestInitCmdBuild(SamRevision revision, boolean verificationMode, boolean rev3_2Mode, byte workKeyRecordNumber, byte workKeyKif, byte workKeyKVC, byte[] digestData) throws IllegalArgumentException {
        super(command, null);
        byte[] dataIn;
        if (revision != null) {
            this.defaultRevision = revision;
        }
        if (workKeyRecordNumber == 0 && (workKeyKif == 0 || workKeyKVC == 0)) {
            throw new IllegalArgumentException("Bad key record number, kif or kvc!");
        }
        if (digestData == null) {
            throw new IllegalArgumentException("Digest data is null!");
        }
        byte cla = SamRevision.S1D.equals((Object)this.defaultRevision) ? (byte)-108 : -128;
        byte p1 = 0;
        if (verificationMode) {
            p1 = (byte)(p1 + 1);
        }
        if (rev3_2Mode) {
            p1 = (byte)(p1 + 2);
        }
        byte p2 = -1;
        if (workKeyKif == -1) {
            p2 = workKeyRecordNumber;
        }
        if (p2 == -1) {
            dataIn = new byte[2 + digestData.length];
            dataIn[0] = workKeyKif;
            dataIn[1] = workKeyKVC;
            System.arraycopy(digestData, 0, dataIn, 2, digestData.length);
        } else {
            dataIn = null;
        }
        this.request = this.setApduRequest(cla, CalypsoSamCommands.DIGEST_INIT, p1, p2, dataIn, null);
    }
}

