/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.keyple.calypso.transaction;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.keyple.calypso.command.SendableInSession;
import org.eclipse.keyple.calypso.command.po.PoCommandBuilder;
import org.eclipse.keyple.calypso.command.po.PoCustomReadCommandBuilder;
import org.eclipse.keyple.calypso.command.po.PoModificationCommand;
import org.eclipse.keyple.calypso.command.po.PoRevision;
import org.eclipse.keyple.calypso.command.po.PoSendableInSession;
import org.eclipse.keyple.calypso.command.po.builder.AppendRecordCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.DecreaseCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.IncreaseCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.ReadRecordsCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.UpdateRecordCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.session.AbstractOpenSessionCmdBuild;
import org.eclipse.keyple.calypso.command.po.builder.session.CloseSessionCmdBuild;
import org.eclipse.keyple.calypso.command.po.parser.AppendRecordRespPars;
import org.eclipse.keyple.calypso.command.po.parser.DecreaseRespPars;
import org.eclipse.keyple.calypso.command.po.parser.IncreaseRespPars;
import org.eclipse.keyple.calypso.command.po.parser.ReadDataStructure;
import org.eclipse.keyple.calypso.command.po.parser.ReadRecordsRespPars;
import org.eclipse.keyple.calypso.command.po.parser.UpdateRecordRespPars;
import org.eclipse.keyple.calypso.command.po.parser.session.AbstractOpenSessionRespPars;
import org.eclipse.keyple.calypso.command.po.parser.session.CloseSessionRespPars;
import org.eclipse.keyple.calypso.command.sam.SamRevision;
import org.eclipse.keyple.calypso.command.sam.SamSendableInSession;
import org.eclipse.keyple.calypso.command.sam.builder.session.DigestAuthenticateCmdBuild;
import org.eclipse.keyple.calypso.command.sam.builder.session.DigestCloseCmdBuild;
import org.eclipse.keyple.calypso.command.sam.builder.session.DigestInitCmdBuild;
import org.eclipse.keyple.calypso.command.sam.builder.session.DigestUpdateCmdBuild;
import org.eclipse.keyple.calypso.command.sam.builder.session.SamGetChallengeCmdBuild;
import org.eclipse.keyple.calypso.command.sam.builder.session.SelectDiversifierCmdBuild;
import org.eclipse.keyple.calypso.command.sam.parser.session.DigestAuthenticateRespPars;
import org.eclipse.keyple.calypso.command.sam.parser.session.DigestCloseRespPars;
import org.eclipse.keyple.calypso.command.sam.parser.session.SamGetChallengeRespPars;
import org.eclipse.keyple.calypso.transaction.CalypsoPo;
import org.eclipse.keyple.calypso.transaction.exception.KeypleCalypsoSecureSessionException;
import org.eclipse.keyple.calypso.transaction.exception.KeypleCalypsoSecureSessionUnauthorizedKvcException;
import org.eclipse.keyple.command.AbstractApduCommandBuilder;
import org.eclipse.keyple.command.AbstractApduResponseParser;
import org.eclipse.keyple.seproxy.ChannelState;
import org.eclipse.keyple.seproxy.SeReader;
import org.eclipse.keyple.seproxy.exception.KeypleReaderException;
import org.eclipse.keyple.seproxy.message.ApduRequest;
import org.eclipse.keyple.seproxy.message.ApduResponse;
import org.eclipse.keyple.seproxy.message.ProxyReader;
import org.eclipse.keyple.seproxy.message.SeRequest;
import org.eclipse.keyple.seproxy.message.SeResponse;
import org.eclipse.keyple.seproxy.protocol.TransmissionMode;
import org.eclipse.keyple.util.ByteArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PoTransaction {
    public static final byte KEY_INDEX_PERSONALIZATION = 1;
    public static final byte KEY_INDEX_LOAD = 2;
    public static final byte KEY_INDEX_VALIDATION_DEBIT = 3;
    public static final byte DEFAULT_KIF_PERSO = 33;
    public static final byte DEFAULT_KIF_LOAD = 39;
    public static final byte DEFAULT_KIF_DEBIT = 48;
    public static final byte DEFAULT_KEY_RECORD_NUMER = 0;
    private static final byte KIF_UNDEFINED = -1;
    private static final byte CHALLENGE_LENGTH_REV_INF_32 = 4;
    private static final byte CHALLENGE_LENGTH_REV32 = 8;
    private static final byte SIGNATURE_LENGTH_REV_INF_32 = 4;
    private static final byte SIGNATURE_LENGTH_REV32 = 8;
    private static final int OFFSET_CLA = 0;
    private static final int OFFSET_INS = 1;
    private static final int OFFSET_P1 = 2;
    private static final int OFFSET_P2 = 3;
    private static final int OFFSET_Lc = 4;
    private static final int OFFSET_DATA = 5;
    private static final byte[] ratificationCmdApduLegacy = ByteArrayUtils.fromHex((String)"94B2000000");
    private static final byte[] ratificationCmdApdu = ByteArrayUtils.fromHex((String)"00B2000000");
    private static final Logger logger = LoggerFactory.getLogger(PoTransaction.class);
    private final ProxyReader poReader;
    private ProxyReader samReader;
    private final SamRevision samRevision = SamRevision.C1;
    private final EnumMap<SamSettings, Byte> samSetting = new EnumMap(SamSettings.class);
    private final byte[] poCalypsoInstanceSerial;
    protected final CalypsoPo calypsoPo;
    private SessionState currentState;
    private byte[] poCalypsoInstanceAid;
    private PoRevision poRevision = PoRevision.REV3_1;
    private boolean transactionResult;
    private boolean isDiversificationDone;
    private byte poKif;
    private boolean wasRatified;
    private byte[] openRecordDataRead;
    private List<PoSendableInSession> poCommandBuilderList = new ArrayList<PoSendableInSession>();
    private List<AbstractApduResponseParser> poResponseParserList = new ArrayList<AbstractApduResponseParser>();
    private boolean samSettingsDefined;
    private List<Byte> authorizedKvcList;
    private ModificationMode currentModificationMode;
    private SessionAccessLevel currentAccessLevel;
    private boolean modificationsCounterIsInBytes;
    private int modificationsCounterMax;
    private int modificationsCounter;

    public PoTransaction(SeReader poReader, CalypsoPo calypsoPO, SeReader samReader, EnumMap<SamSettings, Byte> samSetting) {
        this(poReader, calypsoPO);
        this.setSamSettings(samReader, samSetting);
    }

    public PoTransaction(SeReader poReader, CalypsoPo calypsoPO) {
        this.poReader = (ProxyReader)poReader;
        this.calypsoPo = calypsoPO;
        this.poRevision = calypsoPO.getRevision();
        this.poCalypsoInstanceAid = calypsoPO.getDfName();
        this.modificationsCounterIsInBytes = calypsoPO.isModificationsCounterInBytes();
        this.modificationsCounterMax = this.modificationsCounter = calypsoPO.getModificationsCounter();
        this.poCalypsoInstanceSerial = calypsoPO.getApplicationSerialNumber();
        this.currentState = SessionState.SESSION_CLOSED;
    }

    public void setSamSettings(SeReader samReader, EnumMap<SamSettings, Byte> samSetting) {
        this.samReader = (ProxyReader)samReader;
        if (samSetting != null) {
            this.samSetting.putAll(samSetting);
        }
        if (!this.samSetting.containsKey((Object)SamSettings.SAM_DEFAULT_KIF_PERSO)) {
            this.samSetting.put(SamSettings.SAM_DEFAULT_KIF_PERSO, (byte)33);
        }
        if (!this.samSetting.containsKey((Object)SamSettings.SAM_DEFAULT_KIF_LOAD)) {
            this.samSetting.put(SamSettings.SAM_DEFAULT_KIF_LOAD, (byte)39);
        }
        if (!this.samSetting.containsKey((Object)SamSettings.SAM_DEFAULT_KIF_DEBIT)) {
            this.samSetting.put(SamSettings.SAM_DEFAULT_KIF_DEBIT, (byte)48);
        }
        if (!this.samSetting.containsKey((Object)SamSettings.SAM_DEFAULT_KEY_RECORD_NUMBER)) {
            this.samSetting.put(SamSettings.SAM_DEFAULT_KEY_RECORD_NUMBER, (byte)0);
        }
        logger.debug("Contructor => SAMSETTING = {}", this.samSetting);
        this.samSettingsDefined = true;
    }

    public void setAuthorizedKvcList(List<Byte> authorizedKvcList) {
        this.authorizedKvcList = authorizedKvcList;
    }

    public boolean isSamSettingsDefined() {
        return this.samSettingsDefined;
    }

    private SeResponse processAtomicOpening(SessionAccessLevel accessLevel, byte openingSfiToSelect, byte openingRecordNumberToRead, List<PoSendableInSession> poCommandsInsideSession) throws KeypleReaderException {
        byte kif;
        byte[] sessionTerminalChallenge;
        int numberOfSamCmd = 1;
        ArrayList<ApduRequest> samApduRequestList = new ArrayList<ApduRequest>();
        if (logger.isDebugEnabled()) {
            logger.debug("processAtomicOpening => Identification: DFNAME = {}, SERIALNUMBER = {}", (Object)ByteArrayUtils.toHex((byte[])this.poCalypsoInstanceAid), (Object)ByteArrayUtils.toHex((byte[])this.poCalypsoInstanceSerial));
        }
        if (!this.isDiversificationDone) {
            SelectDiversifierCmdBuild selectDiversifier = new SelectDiversifierCmdBuild(this.samRevision, this.poCalypsoInstanceSerial);
            samApduRequestList.add(selectDiversifier.getApduRequest());
            ++numberOfSamCmd;
            this.isDiversificationDone = true;
        }
        int challengeLength = this.poRevision.equals((Object)PoRevision.REV3_2) ? 8 : 4;
        SamGetChallengeCmdBuild samGetChallenge = new SamGetChallengeCmdBuild(this.samRevision, (byte)challengeLength);
        samApduRequestList.add(samGetChallenge.getApduRequest());
        SeRequest samSeRequest = new SeRequest(samApduRequestList, ChannelState.KEEP_OPEN);
        logger.debug("processAtomicOpening => identification: SAMSEREQUEST = {}", (Object)samSeRequest);
        SeResponse samSeResponse = this.samReader.transmit(samSeRequest);
        if (samSeResponse == null) {
            throw new KeypleCalypsoSecureSessionException("Null response received", KeypleCalypsoSecureSessionException.Type.SAM, samSeRequest.getApduRequests(), null);
        }
        logger.debug("processAtomicOpening => identification: SAMSERESPONSE = {}", (Object)samSeResponse);
        List samApduResponseList = samSeResponse.getApduResponses();
        if (samApduResponseList.size() == numberOfSamCmd && ((ApduResponse)samApduResponseList.get(numberOfSamCmd - 1)).isSuccessful() && ((ApduResponse)samApduResponseList.get(numberOfSamCmd - 1)).getDataOut().length == challengeLength) {
            SamGetChallengeRespPars samChallengePars = new SamGetChallengeRespPars((ApduResponse)samApduResponseList.get(numberOfSamCmd - 1));
            sessionTerminalChallenge = samChallengePars.getChallenge();
            if (logger.isDebugEnabled()) {
                logger.debug("processAtomicOpening => identification: TERMINALCHALLENGE = {}", (Object)ByteArrayUtils.toHex((byte[])sessionTerminalChallenge));
            }
        } else {
            throw new KeypleCalypsoSecureSessionException("Invalid message received", KeypleCalypsoSecureSessionException.Type.SAM, samApduRequestList, samApduResponseList);
        }
        ArrayList<ApduRequest> poApduRequestList = new ArrayList<ApduRequest>();
        AbstractOpenSessionCmdBuild poOpenSession = AbstractOpenSessionCmdBuild.create(this.getRevision(), (byte)(accessLevel.ordinal() + 1), sessionTerminalChallenge, openingSfiToSelect, openingRecordNumberToRead, "");
        poApduRequestList.add(poOpenSession.getApduRequest());
        if (poCommandsInsideSession != null) {
            poApduRequestList.addAll(this.getApduRequestsToSendInSession(poCommandsInsideSession));
        }
        SeRequest poSeRequest = new SeRequest(poApduRequestList, ChannelState.KEEP_OPEN);
        logger.debug("processAtomicOpening => opening:  POSEREQUEST = {}", (Object)poSeRequest);
        SeResponse poSeResponse = this.poReader.transmit(poSeRequest);
        logger.debug("processAtomicOpening => opening:  POSERESPONSE = {}", (Object)poSeResponse);
        if (poSeResponse == null) {
            throw new KeypleCalypsoSecureSessionException("Null response received", KeypleCalypsoSecureSessionException.Type.PO, poSeRequest.getApduRequests(), null);
        }
        if (!poSeResponse.wasChannelPreviouslyOpen()) {
            throw new KeypleCalypsoSecureSessionException("The logical channel was not open", KeypleCalypsoSecureSessionException.Type.PO, poSeRequest.getApduRequests(), null);
        }
        List poApduResponseList = poSeResponse.getApduResponses();
        if (poApduRequestList.size() != poApduResponseList.size()) {
            throw new KeypleCalypsoSecureSessionException("Inconsistent requests and responses", KeypleCalypsoSecureSessionException.Type.PO, poApduRequestList, poApduResponseList);
        }
        for (ApduResponse apduR : poApduResponseList) {
            if (apduR.isSuccessful()) continue;
            throw new KeypleCalypsoSecureSessionException("Invalid response", KeypleCalypsoSecureSessionException.Type.PO, poApduRequestList, poApduResponseList);
        }
        AnticipatedResponseBuilder.storeCommandResponse(poCommandsInsideSession, poApduRequestList, poApduResponseList, true);
        AbstractOpenSessionRespPars poOpenSessionPars = AbstractOpenSessionRespPars.create((ApduResponse)poApduResponseList.get(0), this.poRevision);
        byte[] sessionCardChallenge = poOpenSessionPars.getPoChallenge();
        this.poKif = poOpenSessionPars.getSelectedKif();
        byte poKvc = poOpenSessionPars.getSelectedKvc();
        if (logger.isDebugEnabled()) {
            logger.debug("processAtomicOpening => opening: CARDCHALLENGE = {}, POKIF = {}, POKVC = {}", new Object[]{ByteArrayUtils.toHex((byte[])sessionCardChallenge), String.format("%02X", this.poKif), String.format("%02X", poKvc)});
        }
        if (this.authorizedKvcList != null && !this.authorizedKvcList.contains(poKvc)) {
            throw new KeypleCalypsoSecureSessionUnauthorizedKvcException(String.format("PO KVC = %02X", poKvc));
        }
        if (this.poKif == -1) {
            switch (accessLevel) {
                case SESSION_LVL_PERSO: {
                    kif = this.samSetting.get((Object)SamSettings.SAM_DEFAULT_KIF_PERSO);
                    break;
                }
                case SESSION_LVL_LOAD: {
                    kif = this.samSetting.get((Object)SamSettings.SAM_DEFAULT_KIF_LOAD);
                    break;
                }
                default: {
                    kif = this.samSetting.get((Object)SamSettings.SAM_DEFAULT_KIF_DEBIT);
                    break;
                }
            }
        } else {
            kif = this.poKif;
        }
        this.wasRatified = poOpenSessionPars.wasRatified();
        this.openRecordDataRead = poOpenSessionPars.getRecordDataRead();
        DigestProcessor.initialize(this.poRevision, this.samRevision, false, false, this.poRevision.equals((Object)PoRevision.REV3_2), this.samSetting.get((Object)SamSettings.SAM_DEFAULT_KEY_RECORD_NUMBER), kif, poKvc, ((ApduResponse)poApduResponseList.get(0)).getDataOut());
        if (poCommandsInsideSession != null && !poCommandsInsideSession.isEmpty()) {
            for (int i = 1; i < poApduRequestList.size(); ++i) {
                DigestProcessor.pushPoExchangeData((ApduRequest)poApduRequestList.get(i), (ApduResponse)poApduResponseList.get(i));
            }
        }
        this.currentState = SessionState.SESSION_OPEN;
        poApduResponseList.remove(0);
        return new SeResponse(true, poSeResponse.getSelectionStatus(), poApduResponseList);
    }

    private List<ApduRequest> getApduRequestsToSendInSession(List<SendableInSession> poOrSamCommandsInsideSession) {
        ArrayList<ApduRequest> apduRequestList = new ArrayList<ApduRequest>();
        if (poOrSamCommandsInsideSession != null) {
            for (SendableInSession cmd : poOrSamCommandsInsideSession) {
                apduRequestList.add(((AbstractApduCommandBuilder)cmd).getApduRequest());
            }
        }
        return apduRequestList;
    }

    private SeResponse processAtomicPoCommands(List<PoSendableInSession> poCommands, ChannelState channelState) throws KeypleReaderException {
        List<ApduRequest> poApduRequestList = this.getApduRequestsToSendInSession(poCommands);
        SeRequest poSeRequest = new SeRequest(poApduRequestList, channelState);
        logger.debug("processAtomicPoCommands => POREQUEST = {}", (Object)poSeRequest);
        SeResponse poSeResponse = this.poReader.transmit(poSeRequest);
        logger.debug("processAtomicPoCommands => PORESPONSE = {}", (Object)poSeResponse);
        if (poSeResponse == null) {
            throw new KeypleCalypsoSecureSessionException("Null response received", KeypleCalypsoSecureSessionException.Type.PO, poSeRequest.getApduRequests(), null);
        }
        if (!poSeResponse.wasChannelPreviouslyOpen()) {
            throw new KeypleCalypsoSecureSessionException("The logical channel was not open", KeypleCalypsoSecureSessionException.Type.PO, poSeRequest.getApduRequests(), null);
        }
        List poApduResponseList = poSeResponse.getApduResponses();
        if (poApduRequestList.size() != poApduResponseList.size()) {
            throw new KeypleCalypsoSecureSessionException("Inconsistent requests and responses", KeypleCalypsoSecureSessionException.Type.PO, poApduRequestList, poApduResponseList);
        }
        for (ApduResponse apduR : poApduResponseList) {
            if (apduR.isSuccessful()) continue;
            throw new KeypleCalypsoSecureSessionException("Invalid response", KeypleCalypsoSecureSessionException.Type.PO, poApduRequestList, poApduResponseList);
        }
        AnticipatedResponseBuilder.storeCommandResponse(poCommands, poApduRequestList, poApduResponseList, false);
        if (this.currentState == SessionState.SESSION_OPEN) {
            for (int i = 0; i < poApduRequestList.size(); ++i) {
                DigestProcessor.pushPoExchangeData(poApduRequestList.get(i), (ApduResponse)poApduResponseList.get(i));
            }
        }
        return poSeResponse;
    }

    public SeResponse processSamCommands(List<SamSendableInSession> samCommands) throws KeypleReaderException {
        List<ApduRequest> samApduRequestList = this.getApduRequestsToSendInSession(samCommands);
        SeRequest samSeRequest = new SeRequest(samApduRequestList, ChannelState.KEEP_OPEN);
        logger.debug("processSamCommands => SAMSEREQUEST = {}", (Object)samSeRequest);
        SeResponse samSeResponse = this.samReader.transmit(samSeRequest);
        if (samSeResponse == null) {
            throw new KeypleCalypsoSecureSessionException("Null response received", KeypleCalypsoSecureSessionException.Type.SAM, samSeRequest.getApduRequests(), null);
        }
        if (this.currentState == SessionState.SESSION_OPEN && !samSeResponse.wasChannelPreviouslyOpen()) {
            throw new KeypleCalypsoSecureSessionException("The logical channel was not open", KeypleCalypsoSecureSessionException.Type.SAM, samSeRequest.getApduRequests(), null);
        }
        return samSeResponse;
    }

    private SeResponse processAtomicClosing(List<PoModificationCommand> poModificationCommands, List<ApduResponse> poAnticipatedResponses, TransmissionMode transmissionMode, ChannelState channelState) throws KeypleReaderException {
        SeResponse poSeResponse;
        SeRequest poSeRequest;
        int closeCommandIndex;
        boolean ratificationAsked;
        List samApduResponseList;
        SeResponse samSeResponse;
        SeRequest samSeRequest;
        List<ApduRequest> poApduRequestList;
        block25: {
            PoCustomReadCommandBuilder ratificationCommand;
            if (this.currentState != SessionState.SESSION_OPEN) {
                throw new IllegalStateException("Bad session state. Current: " + this.currentState.toString() + ", expected: " + SessionState.SESSION_OPEN.toString());
            }
            poApduRequestList = this.getApduRequestsToSendInSession(poModificationCommands);
            if (poModificationCommands != null && !poApduRequestList.isEmpty()) {
                if (poApduRequestList.size() == poAnticipatedResponses.size()) {
                    for (int i = 0; i < poApduRequestList.size(); ++i) {
                        DigestProcessor.pushPoExchangeData(poApduRequestList.get(i), poAnticipatedResponses.get(i));
                    }
                } else {
                    throw new KeypleCalypsoSecureSessionException("Inconsistent requests and anticipated responses", KeypleCalypsoSecureSessionException.Type.PO, poApduRequestList, poAnticipatedResponses);
                }
            }
            samSeRequest = DigestProcessor.getSamDigestRequest();
            logger.debug("processAtomicClosing => SAMREQUEST = {}", (Object)samSeRequest);
            samSeResponse = this.samReader.transmit(samSeRequest);
            logger.debug("processAtomicClosing => SAMRESPONSE = {}", (Object)samSeResponse);
            if (samSeResponse == null) {
                throw new KeypleCalypsoSecureSessionException("Null response received", KeypleCalypsoSecureSessionException.Type.SAM, samSeRequest.getApduRequests(), null);
            }
            if (!samSeResponse.wasChannelPreviouslyOpen()) {
                throw new KeypleCalypsoSecureSessionException("The logical channel was not open", KeypleCalypsoSecureSessionException.Type.PO, samSeRequest.getApduRequests(), null);
            }
            samApduResponseList = samSeResponse.getApduResponses();
            for (int i = 0; i < samApduResponseList.size(); ++i) {
                if (((ApduResponse)samApduResponseList.get(i)).isSuccessful()) continue;
                logger.debug("processAtomicClosing => command failure REQUEST = {}, RESPONSE = {}", samSeRequest.getApduRequests().get(i), samApduResponseList.get(i));
                throw new IllegalStateException("ProcessClosing command failure during digest computation process.");
            }
            byte[] sessionTerminalSignature = null;
            if (!samApduResponseList.isEmpty()) {
                DigestCloseRespPars respPars = new DigestCloseRespPars((ApduResponse)samApduResponseList.get(samApduResponseList.size() - 1));
                sessionTerminalSignature = respPars.getSignature();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("processAtomicClosing => SIGNATURE = {}", (Object)ByteArrayUtils.toHex(sessionTerminalSignature));
            }
            if (transmissionMode == TransmissionMode.CONTACTLESS) {
                ratificationCommand = this.poRevision == PoRevision.REV2_4 ? new PoCustomReadCommandBuilder("Ratification command", new ApduRequest(ratificationCmdApduLegacy, false)) : new PoCustomReadCommandBuilder("Ratification command", new ApduRequest(ratificationCmdApdu, false));
                ratificationAsked = false;
            } else {
                ratificationAsked = true;
                ratificationCommand = null;
            }
            CloseSessionCmdBuild closeCommand = new CloseSessionCmdBuild(this.calypsoPo.getPoClass(), ratificationAsked, sessionTerminalSignature);
            poApduRequestList.add(closeCommand.getApduRequest());
            closeCommandIndex = poApduRequestList.size() - 1;
            if (ratificationCommand != null) {
                poApduRequestList.add(ratificationCommand.getApduRequest());
            }
            poSeRequest = new SeRequest(poApduRequestList, channelState);
            logger.debug("processAtomicClosing => POSEREQUEST = {}", (Object)poSeRequest);
            try {
                poSeResponse = this.poReader.transmit(poSeRequest);
            }
            catch (KeypleReaderException ex) {
                poSeResponse = ex.getSeResponse();
                if (!ratificationAsked && poSeResponse != null && poSeResponse.getApduResponses().size() == poApduRequestList.size() - 1) break block25;
                ex.setSeResponse(poSeResponse);
                throw new KeypleReaderException("PO Reader Exception while closing Secure Session", (Throwable)ex);
            }
        }
        if (poSeResponse == null) {
            throw new KeypleCalypsoSecureSessionException("Null response received", KeypleCalypsoSecureSessionException.Type.PO, poSeRequest.getApduRequests(), null);
        }
        if (!poSeResponse.wasChannelPreviouslyOpen()) {
            throw new KeypleCalypsoSecureSessionException("The logical channel was not open", KeypleCalypsoSecureSessionException.Type.PO, poSeRequest.getApduRequests(), null);
        }
        logger.debug("processAtomicClosing => POSERESPONSE = {}", (Object)poSeResponse);
        List poApduResponseList = poSeResponse.getApduResponses();
        CloseSessionRespPars poCloseSessionPars = new CloseSessionRespPars((ApduResponse)poApduResponseList.get(closeCommandIndex));
        if (!poCloseSessionPars.isSuccessful()) {
            throw new KeypleCalypsoSecureSessionException("Didn't get a signature", KeypleCalypsoSecureSessionException.Type.PO, poApduRequestList, poApduResponseList);
        }
        DigestAuthenticateCmdBuild digestAuth = new DigestAuthenticateCmdBuild(this.samRevision, poCloseSessionPars.getSignatureLo());
        ArrayList<ApduRequest> samApduRequestList = new ArrayList<ApduRequest>();
        samApduRequestList.add(digestAuth.getApduRequest());
        samSeRequest = new SeRequest(samApduRequestList, ChannelState.KEEP_OPEN);
        logger.debug("PoTransaction.DigestProcessor => checkPoSignature: SAMREQUEST = {}", (Object)samSeRequest);
        samSeResponse = this.samReader.transmit(samSeRequest);
        logger.debug("PoTransaction.DigestProcessor => checkPoSignature: SAMRESPONSE = {}", (Object)samSeResponse);
        if (samSeResponse == null) {
            throw new KeypleCalypsoSecureSessionException("Null response received", KeypleCalypsoSecureSessionException.Type.SAM, samSeRequest.getApduRequests(), null);
        }
        if (!samSeResponse.wasChannelPreviouslyOpen()) {
            throw new KeypleCalypsoSecureSessionException("The logical channel was not open", KeypleCalypsoSecureSessionException.Type.SAM, samSeRequest.getApduRequests(), null);
        }
        samApduResponseList = samSeResponse.getApduResponses();
        this.transactionResult = false;
        if (samApduResponseList != null && !samApduResponseList.isEmpty()) {
            DigestAuthenticateRespPars respPars = new DigestAuthenticateRespPars((ApduResponse)samApduResponseList.get(0));
            this.transactionResult = respPars.isSuccessful();
            if (this.transactionResult) {
                logger.debug("PoTransaction.DigestProcessor => checkPoSignature: mutual authentication successful.");
            } else {
                logger.debug("PoTransaction.DigestProcessor => checkPoSignature: mutual authentication failure.");
            }
        } else {
            logger.debug("DigestProcessor => checkPoSignature: no response to Digest Authenticate.");
            throw new IllegalStateException("No response to Digest Authenticate.");
        }
        this.currentState = SessionState.SESSION_CLOSED;
        if (!ratificationAsked) {
            poApduResponseList.remove(poApduResponseList.size() - 1);
        }
        poApduResponseList.remove(poApduResponseList.size() - 1);
        return new SeResponse(true, poSeResponse.getSelectionStatus(), poApduResponseList);
    }

    private SeResponse processAtomicClosing(List<PoModificationCommand> poModificationCommands, TransmissionMode transmissionMode, ChannelState channelState) throws KeypleReaderException {
        List<ApduResponse> poAnticipatedResponses = AnticipatedResponseBuilder.getResponses(poModificationCommands);
        return this.processAtomicClosing(poModificationCommands, poAnticipatedResponses, transmissionMode, channelState);
    }

    public PoRevision getRevision() {
        return this.poRevision;
    }

    public boolean isSuccessful() {
        if (this.currentState != SessionState.SESSION_CLOSED) {
            throw new IllegalStateException("Session is not closed, state:" + this.currentState.toString() + ", expected: " + SessionState.SESSION_OPEN.toString());
        }
        return this.transactionResult;
    }

    public byte getPoKif() {
        return this.poKif;
    }

    public boolean wasRatified() {
        return this.wasRatified;
    }

    public byte[] getOpenRecordDataRead() {
        return this.openRecordDataRead;
    }

    public boolean processOpening(ModificationMode modificationMode, SessionAccessLevel accessLevel, byte openingSfiToSelect, byte openingRecordNumberToRead) throws KeypleReaderException {
        this.currentModificationMode = modificationMode;
        this.currentAccessLevel = accessLevel;
        byte localOpeningRecordNumberToRead = openingRecordNumberToRead;
        boolean poProcessSuccess = true;
        Iterator<AbstractApduResponseParser> apduResponseParserIterator = this.poResponseParserList.iterator();
        ArrayList<PoSendableInSession> poAtomicCommandBuilderList = new ArrayList<PoSendableInSession>();
        for (PoSendableInSession poCommandBuilderElement : this.poCommandBuilderList) {
            if (!(poCommandBuilderElement instanceof PoModificationCommand)) {
                poAtomicCommandBuilderList.add(poCommandBuilderElement);
                continue;
            }
            if (this.willOverflowBuffer((PoModificationCommand)((Object)poCommandBuilderElement))) {
                if (this.currentModificationMode == ModificationMode.ATOMIC) {
                    throw new IllegalStateException("ATOMIC mode error! This command would overflow the PO modifications buffer: " + poCommandBuilderElement.toString());
                }
                SeResponse seResponseOpening = this.processAtomicOpening(this.currentAccessLevel, openingSfiToSelect, localOpeningRecordNumberToRead, poAtomicCommandBuilderList);
                localOpeningRecordNumberToRead = 0;
                if (!this.updateParsersWithResponses(seResponseOpening, apduResponseParserIterator)) {
                    poProcessSuccess = false;
                }
                this.processAtomicClosing(null, TransmissionMode.CONTACTS, ChannelState.KEEP_OPEN);
                this.resetModificationsBufferCounter();
                poAtomicCommandBuilderList.clear();
                poAtomicCommandBuilderList.add(poCommandBuilderElement);
                this.willOverflowBuffer((PoModificationCommand)((Object)poCommandBuilderElement));
                continue;
            }
            poAtomicCommandBuilderList.add(poCommandBuilderElement);
        }
        SeResponse seResponseOpening = this.processAtomicOpening(this.currentAccessLevel, openingSfiToSelect, localOpeningRecordNumberToRead, poAtomicCommandBuilderList);
        if (!this.updateParsersWithResponses(seResponseOpening, apduResponseParserIterator)) {
            poProcessSuccess = false;
        }
        this.poCommandBuilderList.clear();
        this.poResponseParserList.clear();
        return poProcessSuccess;
    }

    public boolean processPoCommands(ChannelState channelState) throws KeypleReaderException {
        if (this.currentState == SessionState.SESSION_OPEN) {
            throw new IllegalStateException("A session is open");
        }
        boolean poProcessSuccess = true;
        Iterator<AbstractApduResponseParser> abstractApduResponseParserIterator = this.poResponseParserList.iterator();
        SeResponse seResponsePoCommands = this.processAtomicPoCommands(this.poCommandBuilderList, channelState);
        if (!this.updateParsersWithResponses(seResponsePoCommands, abstractApduResponseParserIterator)) {
            poProcessSuccess = false;
        }
        this.poCommandBuilderList.clear();
        this.poResponseParserList.clear();
        return poProcessSuccess;
    }

    public boolean processPoCommandsInSession() throws KeypleReaderException {
        SeResponse seResponsePoCommands;
        if (this.currentState == SessionState.SESSION_CLOSED) {
            throw new IllegalStateException("No open session");
        }
        boolean poProcessSuccess = true;
        Iterator<AbstractApduResponseParser> abstractApduResponseParserIterator = this.poResponseParserList.iterator();
        ArrayList<PoSendableInSession> poAtomicCommandBuilderList = new ArrayList<PoSendableInSession>();
        for (PoSendableInSession poCommandBuilderElement : this.poCommandBuilderList) {
            if (!(poCommandBuilderElement instanceof PoModificationCommand)) {
                poAtomicCommandBuilderList.add(poCommandBuilderElement);
                continue;
            }
            if (this.willOverflowBuffer((PoModificationCommand)((Object)poCommandBuilderElement))) {
                if (this.currentModificationMode == ModificationMode.ATOMIC) {
                    throw new IllegalStateException("ATOMIC mode error! This command would overflow the PO modifications buffer: " + poCommandBuilderElement.toString());
                }
                SeResponse seResponsePoCommands2 = this.processAtomicPoCommands(poAtomicCommandBuilderList, ChannelState.KEEP_OPEN);
                if (!this.updateParsersWithResponses(seResponsePoCommands2, abstractApduResponseParserIterator)) {
                    poProcessSuccess = false;
                }
                this.processAtomicClosing(null, TransmissionMode.CONTACTS, ChannelState.KEEP_OPEN);
                this.resetModificationsBufferCounter();
                SeResponse seResponseOpening = this.processAtomicOpening(this.currentAccessLevel, (byte)0, (byte)0, null);
                poAtomicCommandBuilderList.clear();
                poAtomicCommandBuilderList.add(poCommandBuilderElement);
                this.willOverflowBuffer((PoModificationCommand)((Object)poCommandBuilderElement));
                continue;
            }
            poAtomicCommandBuilderList.add(poCommandBuilderElement);
        }
        if (!poAtomicCommandBuilderList.isEmpty() && !this.updateParsersWithResponses(seResponsePoCommands = this.processAtomicPoCommands(poAtomicCommandBuilderList, ChannelState.KEEP_OPEN), abstractApduResponseParserIterator)) {
            poProcessSuccess = false;
        }
        this.poCommandBuilderList.clear();
        this.poResponseParserList.clear();
        return poProcessSuccess;
    }

    public boolean processClosing(TransmissionMode transmissionMode, ChannelState channelState) throws KeypleReaderException {
        SeResponse seResponseClosing;
        boolean poProcessSuccess = true;
        boolean atLeastOneReadCommand = false;
        boolean sessionPreviouslyClosed = false;
        ArrayList poModificationCommandList = new ArrayList();
        Iterator<AbstractApduResponseParser> abstractApduResponseParserIterator = this.poResponseParserList.iterator();
        ArrayList<PoModificationCommand> poAtomicCommandBuilderList = new ArrayList<PoModificationCommand>();
        for (PoSendableInSession poCommandBuilderElement : this.poCommandBuilderList) {
            if (!(poCommandBuilderElement instanceof PoModificationCommand)) {
                poAtomicCommandBuilderList.add((PoModificationCommand)((Object)poCommandBuilderElement));
                atLeastOneReadCommand = true;
                continue;
            }
            if (this.willOverflowBuffer((PoModificationCommand)((Object)poCommandBuilderElement))) {
                if (this.currentModificationMode == ModificationMode.ATOMIC) {
                    throw new IllegalStateException("ATOMIC mode error! This command would overflow the PO modifications buffer: " + poCommandBuilderElement.toString());
                }
                if (sessionPreviouslyClosed) {
                    this.processAtomicOpening(this.currentAccessLevel, (byte)0, (byte)0, null);
                }
                if (atLeastOneReadCommand) {
                    ArrayList<PoSendableInSession> poSendableInSessionList = new ArrayList<PoSendableInSession>();
                    for (PoModificationCommand command : poAtomicCommandBuilderList) {
                        poSendableInSessionList.add((PoSendableInSession)((Object)command));
                    }
                    seResponseClosing = this.processAtomicPoCommands(poSendableInSessionList, ChannelState.KEEP_OPEN);
                    atLeastOneReadCommand = false;
                } else {
                    seResponseClosing = this.processAtomicClosing(poAtomicCommandBuilderList, TransmissionMode.CONTACTS, ChannelState.KEEP_OPEN);
                    this.resetModificationsBufferCounter();
                    sessionPreviouslyClosed = true;
                }
                Iterator<AbstractApduResponseParser> apduResponseParserIterator = this.poResponseParserList.iterator();
                if (!this.updateParsersWithResponses(seResponseClosing, apduResponseParserIterator)) {
                    poProcessSuccess = false;
                }
                poAtomicCommandBuilderList.clear();
                poAtomicCommandBuilderList.add((PoModificationCommand)((Object)poCommandBuilderElement));
                this.willOverflowBuffer((PoModificationCommand)((Object)poCommandBuilderElement));
                continue;
            }
            poAtomicCommandBuilderList.add((PoModificationCommand)((Object)poCommandBuilderElement));
        }
        if (sessionPreviouslyClosed) {
            this.processAtomicOpening(this.currentAccessLevel, (byte)0, (byte)0, null);
        }
        if (!this.updateParsersWithResponses(seResponseClosing = this.processAtomicClosing(poAtomicCommandBuilderList, transmissionMode, channelState), abstractApduResponseParserIterator)) {
            poProcessSuccess = false;
        }
        this.poCommandBuilderList.clear();
        this.poResponseParserList.clear();
        return poProcessSuccess;
    }

    public boolean processCancel(ChannelState channelState) {
        SeResponse poSeResponse;
        ArrayList<ApduRequest> poApduRequestList = new ArrayList<ApduRequest>();
        CloseSessionCmdBuild closeCommand = new CloseSessionCmdBuild(this.calypsoPo.getPoClass());
        poApduRequestList.add(closeCommand.getApduRequest());
        SeRequest poSeRequest = new SeRequest(poApduRequestList, channelState);
        logger.debug("processCancel => POSEREQUEST = {}", (Object)poSeRequest);
        try {
            poSeResponse = this.poReader.transmit(poSeRequest);
        }
        catch (KeypleReaderException ex) {
            poSeResponse = ex.getSeResponse();
        }
        logger.debug("processCancel => POSERESPONSE = {}", (Object)poSeResponse);
        this.poCommandBuilderList.clear();
        this.poResponseParserList.clear();
        this.currentState = SessionState.SESSION_CLOSED;
        return ((ApduResponse)poSeResponse.getApduResponses().get(0)).isSuccessful();
    }

    private boolean updateParsersWithResponses(SeResponse seResponse, Iterator<AbstractApduResponseParser> parserIterator) {
        boolean allSuccessfulCommands = true;
        for (ApduResponse apduResponse : seResponse.getApduResponses()) {
            if (!parserIterator.hasNext()) {
                throw new IllegalStateException("Parsers list and responses list mismatch! ");
            }
            parserIterator.next().setApduResponse(apduResponse);
            if (apduResponse.isSuccessful()) continue;
            allSuccessfulCommands = false;
        }
        return allSuccessfulCommands;
    }

    private boolean willOverflowBuffer(PoModificationCommand modificationCommand) {
        boolean willOverflow = false;
        if (this.modificationsCounterIsInBytes) {
            int bufferRequirement = ((AbstractApduCommandBuilder)modificationCommand).getApduRequest().getBytes()[4] + 6;
            if (this.modificationsCounter - bufferRequirement > 0) {
                this.modificationsCounter -= bufferRequirement;
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("Modifications buffer overflow! BYTESMODE, CURRENTCOUNTER = {}, REQUIREMENT = {}", (Object)this.modificationsCounter, (Object)bufferRequirement);
                }
                willOverflow = true;
            }
        } else if (this.modificationsCounter > 0) {
            --this.modificationsCounter;
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace("Modifications buffer overflow! COMMANDSMODE, CURRENTCOUNTER = {}, REQUIREMENT = {}", (Object)this.modificationsCounter, (Object)1);
            }
            willOverflow = true;
        }
        return willOverflow;
    }

    private void resetModificationsBufferCounter() {
        if (logger.isTraceEnabled()) {
            logger.trace("Modifications buffer counter reset: PREVIOUSVALUE = {}, NEWVALUE = {}", (Object)this.modificationsCounter, (Object)this.modificationsCounterMax);
        }
        this.modificationsCounter = this.modificationsCounterMax;
    }

    private ReadRecordsRespPars prepareReadRecordsCmdInternal(byte sfi, ReadDataStructure readDataStructureEnum, byte firstRecordNumber, int expectedLength, String extraInfo) {
        boolean readJustOneRecord = readDataStructureEnum != ReadDataStructure.MULTIPLE_RECORD_DATA;
        this.poCommandBuilderList.add(new ReadRecordsCmdBuild(this.calypsoPo.getPoClass(), sfi, firstRecordNumber, readJustOneRecord, (byte)expectedLength, extraInfo));
        ReadRecordsRespPars poResponseParser = new ReadRecordsRespPars(firstRecordNumber, readDataStructureEnum);
        this.poResponseParserList.add(poResponseParser);
        return poResponseParser;
    }

    public ReadRecordsRespPars prepareReadRecordsCmd(byte sfi, ReadDataStructure readDataStructureEnum, byte firstRecordNumber, int expectedLength, String extraInfo) {
        if (expectedLength < 1 || expectedLength > 250) {
            throw new IllegalArgumentException("Bad length.");
        }
        return this.prepareReadRecordsCmdInternal(sfi, readDataStructureEnum, firstRecordNumber, expectedLength, extraInfo);
    }

    public ReadRecordsRespPars prepareReadRecordsCmd(byte sfi, ReadDataStructure readDataStructureEnum, byte firstRecordNumber, String extraInfo) {
        if (this.poReader.getTransmissionMode() == TransmissionMode.CONTACTS) {
            throw new IllegalArgumentException("In contacts mode, the expected length must be specified.");
        }
        return this.prepareReadRecordsCmdInternal(sfi, readDataStructureEnum, firstRecordNumber, 0, extraInfo);
    }

    public AppendRecordRespPars prepareAppendRecordCmd(byte sfi, byte[] newRecordData, String extraInfo) {
        this.poCommandBuilderList.add(new AppendRecordCmdBuild(this.calypsoPo.getPoClass(), sfi, newRecordData, extraInfo));
        AppendRecordRespPars poResponseParser = new AppendRecordRespPars();
        this.poResponseParserList.add(poResponseParser);
        return poResponseParser;
    }

    public UpdateRecordRespPars prepareUpdateRecordCmd(byte sfi, byte recordNumber, byte[] newRecordData, String extraInfo) {
        this.poCommandBuilderList.add(new UpdateRecordCmdBuild(this.calypsoPo.getPoClass(), sfi, recordNumber, newRecordData, extraInfo));
        UpdateRecordRespPars poResponseParser = new UpdateRecordRespPars();
        this.poResponseParserList.add(poResponseParser);
        return poResponseParser;
    }

    public IncreaseRespPars prepareIncreaseCmd(byte sfi, byte counterNumber, int incValue, String extraInfo) {
        this.poCommandBuilderList.add(new IncreaseCmdBuild(this.calypsoPo.getPoClass(), sfi, counterNumber, incValue, extraInfo));
        IncreaseRespPars poResponseParser = new IncreaseRespPars();
        this.poResponseParserList.add(poResponseParser);
        return poResponseParser;
    }

    public DecreaseRespPars prepareDecreaseCmd(byte sfi, byte counterNumber, int decValue, String extraInfo) {
        this.poCommandBuilderList.add(new DecreaseCmdBuild(this.calypsoPo.getPoClass(), sfi, counterNumber, decValue, extraInfo));
        DecreaseRespPars poResponseParser = new DecreaseRespPars();
        this.poResponseParserList.add(poResponseParser);
        return poResponseParser;
    }

    private static class AnticipatedResponseBuilder {
        private static Map<Byte, CommandResponse> sfiCommandResponseHashMap = new HashMap<Byte, CommandResponse>();

        private AnticipatedResponseBuilder() {
        }

        static void storeCommandResponse(List<PoSendableInSession> poSendableInSessions, List<ApduRequest> apduRequests, List<ApduResponse> apduResponses, Boolean skipFirstItem) {
            if (poSendableInSessions != null) {
                Iterator<ApduRequest> apduRequestIterator = apduRequests.iterator();
                Iterator<ApduResponse> apduResponseIterator = apduResponses.iterator();
                if (skipFirstItem.booleanValue()) {
                    apduRequestIterator.next();
                    apduResponseIterator.next();
                }
                for (PoSendableInSession poSendableInSession : poSendableInSessions) {
                    if (poSendableInSession instanceof ReadRecordsCmdBuild) {
                        ApduRequest apduRequest = apduRequestIterator.next();
                        byte sfi = (byte)(apduRequest.getBytes()[3] >> 3 & 0x1F);
                        sfiCommandResponseHashMap.put(sfi, new CommandResponse(apduRequest, apduResponseIterator.next()));
                        continue;
                    }
                    apduRequestIterator.next();
                    apduResponseIterator.next();
                }
            }
        }

        public static List<ApduResponse> getResponses(List<PoModificationCommand> poModificationCommands) throws KeypleCalypsoSecureSessionException {
            ArrayList<ApduResponse> apduResponses = new ArrayList<ApduResponse>();
            if (poModificationCommands != null) {
                for (PoModificationCommand poModificationCommand : poModificationCommands) {
                    if (poModificationCommand instanceof DecreaseCmdBuild || poModificationCommand instanceof IncreaseCmdBuild) {
                        byte[] modCounterApduRequest = ((PoCommandBuilder)((Object)poModificationCommand)).getApduRequest().getBytes();
                        byte sfi = (byte)(modCounterApduRequest[3] >> 3 & 0x1F);
                        CommandResponse commandResponse = sfiCommandResponseHashMap.get(sfi);
                        if (commandResponse != null) {
                            byte counterNumber = modCounterApduRequest[2];
                            int currentCounterValue = ByteArrayUtils.threeBytesToInt((byte[])commandResponse.getApduResponse().getBytes(), (int)((counterNumber - 1) * 3));
                            int addSubtractValue = ByteArrayUtils.threeBytesToInt((byte[])modCounterApduRequest, (int)5);
                            byte[] response = new byte[5];
                            int newCounterValue = poModificationCommand instanceof DecreaseCmdBuild ? currentCounterValue - addSubtractValue : currentCounterValue + addSubtractValue;
                            response[0] = (byte)((newCounterValue & 0xFF0000) >> 16);
                            response[1] = (byte)((newCounterValue & 0xFF00) >> 8);
                            response[2] = (byte)((newCounterValue & 0xFF) >> 0);
                            response[3] = -112;
                            response[4] = 0;
                            apduResponses.add(new ApduResponse(response, null));
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug("Anticipated response. COMMAND = {}, SFI = {}, COUNTERVALUE = {}, DECREMENT = {}, NEWVALUE = {} ", new Object[]{poModificationCommand instanceof DecreaseCmdBuild ? "Decrease" : "Increase", sfi, currentCounterValue, addSubtractValue, newCounterValue});
                            continue;
                        }
                        throw new KeypleCalypsoSecureSessionException("Anticipated response. COMMAND = " + (poModificationCommand instanceof DecreaseCmdBuild ? "Decrease" : "Increase") + ". Unable to determine anticipated counter value. SFI = " + sfi, ((PoCommandBuilder)((Object)poModificationCommand)).getApduRequest(), null);
                    }
                    apduResponses.add(new ApduResponse(ByteArrayUtils.fromHex((String)"9000"), null));
                }
            }
            return apduResponses;
        }

        private static class CommandResponse {
            private final ApduRequest apduRequest;
            private final ApduResponse apduResponse;

            CommandResponse(ApduRequest apduRequest, ApduResponse apduResponse) {
                this.apduRequest = apduRequest;
                this.apduResponse = apduResponse;
            }

            public ApduRequest getApduRequest() {
                return this.apduRequest;
            }

            public ApduResponse getApduResponse() {
                return this.apduResponse;
            }
        }
    }

    private static class DigestProcessor {
        private static final List<byte[]> poDigestDataCache = new ArrayList<byte[]>();
        private static SamRevision samRevision;
        private static PoRevision poRevision;
        private static boolean encryption;
        private static boolean verification;
        private static boolean revMode;
        private static byte keyRecordNumber;
        private static byte keyKIF;
        private static byte keyKVC;

        private DigestProcessor() {
        }

        static void initialize(PoRevision poRev, SamRevision samRev, boolean sessionEncryption, boolean verificationMode, boolean rev3_2Mode, byte workKeyRecordNumber, byte workKeyKif, byte workKeyKVC, byte[] digestData) {
            poRevision = poRev;
            samRevision = samRev;
            encryption = sessionEncryption;
            verification = verificationMode;
            revMode = rev3_2Mode;
            keyRecordNumber = workKeyRecordNumber;
            keyKIF = workKeyKif;
            keyKVC = workKeyKVC;
            if (logger.isDebugEnabled()) {
                logger.debug("PoTransaction.DigestProcessor => initialize: POREVISION = {}, SAMREVISION = {}, SESSIONENCRYPTION = {}", new Object[]{poRev, samRev, sessionEncryption, verificationMode});
                logger.debug("PoTransaction.DigestProcessor => initialize: VERIFICATIONMODE = {}, REV32MODE = {} KEYRECNUMBER = {}", new Object[]{verificationMode, rev3_2Mode, workKeyRecordNumber});
                logger.debug("PoTransaction.DigestProcessor => initialize: KIF = {}, KVC {}, DIGESTDATA = {}", new Object[]{String.format("%02X", workKeyKif), String.format("%02X", workKeyKVC), ByteArrayUtils.toHex((byte[])digestData)});
            }
            poDigestDataCache.clear();
            poDigestDataCache.add(digestData);
        }

        static void pushPoExchangeData(ApduRequest request, ApduResponse response) {
            logger.debug("PoTransaction.DigestProcessor => pushPoExchangeData: REQUEST = {}", (Object)request);
            if (request.isCase4()) {
                poDigestDataCache.add(Arrays.copyOfRange(request.getBytes(), 0, request.getBytes().length - 1));
            } else {
                poDigestDataCache.add(request.getBytes());
            }
            logger.debug("PoTransaction.DigestProcessor => pushPoExchangeData: RESPONSE = {}", (Object)response);
            poDigestDataCache.add(response.getBytes());
        }

        static SeRequest getSamDigestRequest() {
            ArrayList<ApduRequest> samApduRequestList = new ArrayList<ApduRequest>();
            if (poDigestDataCache.size() == 0) {
                logger.debug("PoTransaction.DigestProcessor => getSamDigestRequest: no data in cache.");
                throw new IllegalStateException("Digest data cache is empty.");
            }
            if (poDigestDataCache.size() % 2 == 0) {
                logger.debug("PoTransaction.DigestProcessor => getSamDigestRequest: wrong number of buffer in cache NBR = {}.", (Object)poDigestDataCache.size());
                throw new IllegalStateException("Digest data cache is inconsistent.");
            }
            samApduRequestList.add(new DigestInitCmdBuild(samRevision, verification, revMode, keyRecordNumber, keyKIF, keyKVC, poDigestDataCache.get(0)).getApduRequest());
            for (int i = 1; i < poDigestDataCache.size(); ++i) {
                samApduRequestList.add(new DigestUpdateCmdBuild(samRevision, encryption, poDigestDataCache.get(i)).getApduRequest());
            }
            samApduRequestList.add(new DigestCloseCmdBuild(samRevision, poRevision.equals((Object)PoRevision.REV3_2) ? (byte)8 : 4).getApduRequest());
            return new SeRequest(samApduRequestList, ChannelState.KEEP_OPEN);
        }
    }

    public static enum SessionState {
        SESSION_CLOSED,
        SESSION_OPEN;

    }

    public static enum ModificationMode {
        ATOMIC,
        MULTIPLE;

    }

    public static enum SessionAccessLevel {
        SESSION_LVL_PERSO,
        SESSION_LVL_LOAD,
        SESSION_LVL_DEBIT;

    }

    public static enum SamSettings {
        SAM_DEFAULT_KIF_PERSO,
        SAM_DEFAULT_KIF_LOAD,
        SAM_DEFAULT_KIF_DEBIT,
        SAM_DEFAULT_KEY_RECORD_NUMBER;

    }
}

