/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.IDEPlugin;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences.Messages;
import org.eclipse.linuxtools.internal.systemtap.ui.ide.preferences.PreferenceConstants;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class EnvironmentVariablesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static StringFieldEditor[] envVariables;

    public EnvironmentVariablesPreferencePage() {
        this.setPreferenceStore(IDEPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.EnvironmentVariablesPreferencePage_Title);
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        Composite c = new Composite((Composite)sc, 0);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        sc.setContent((Control)c);
        envVariables = new StringFieldEditor[PreferenceConstants.P_ENV.values().length];
        int i = 0;
        for (PreferenceConstants.P_ENV env : PreferenceConstants.P_ENV.values()) {
            EnvironmentVariablesPreferencePage.envVariables[i] = this.createStringFieldEditor(env.toPrefKey(), env.toEnvKey(), c);
            ++i;
        }
        return sc;
    }

    private StringFieldEditor createStringFieldEditor(String name, String lblText, Composite parent) {
        StringFieldEditor sfe = new StringFieldEditor(name, lblText, parent);
        sfe.setPage((DialogPage)this);
        sfe.setPreferenceStore(this.getPreferenceStore());
        sfe.load();
        return sfe;
    }

    protected void performDefaults() {
        for (StringFieldEditor envVariable : envVariables) {
            envVariable.loadDefault();
        }
        super.performDefaults();
    }

    public boolean performOk() {
        for (StringFieldEditor envVariable : envVariables) {
            envVariable.store();
        }
        return true;
    }

    public static String[] getEnvironmentVariables() {
        ArrayList<String> vars = new ArrayList<String>();
        String[] envVars = null;
        if (IDEPlugin.getDefault() == null || IDEPlugin.getDefault().getPreferenceStore() == null) {
            return null;
        }
        IPreferenceStore p = IDEPlugin.getDefault().getPreferenceStore();
        for (PreferenceConstants.P_ENV env : PreferenceConstants.P_ENV.values()) {
            String val = p.getString(env.toPrefKey()).trim();
            if (val.isEmpty()) continue;
            vars.add(env.createKeyValString(val));
        }
        if (vars.size() > 0) {
            envVars = new String[vars.size()];
            for (int i = 0; i < vars.size(); ++i) {
                envVars[i] = (String)vars.get(i);
            }
        }
        return envVars;
    }

    public void dispose() {
        super.dispose();
        for (int i = 0; i < envVariables.length; ++i) {
            envVariables[i].dispose();
            EnvironmentVariablesPreferencePage.envVariables[i] = null;
        }
        envVariables = null;
    }
}

