/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rdt.proxy;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.linuxtools.internal.rdt.proxy.Activator;
import org.eclipse.linuxtools.internal.rdt.proxy.Messages;
import org.eclipse.linuxtools.internal.rdt.proxy.RDTProxyManager;
import org.eclipse.linuxtools.internal.rdt.proxy.RemoteProcessClosure;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteProcessService;
import org.eclipse.remote.core.IRemoteResource;
import org.eclipse.remote.core.RemoteProcessAdapter;
import org.eclipse.remote.core.exception.RemoteConnectionException;

public class RDTCommandLauncher
implements IRemoteCommandLauncher {
    private IRemoteProcess fProcess = null;
    private boolean fShowCommand = false;
    private String[] fCommandArgs;
    private String fErrorMessage = "";
    private String lineSeparator;
    private URI uri;
    private static final long DELAY = 50L;

    public RDTCommandLauncher(IProject project) {
        try {
            if (project.hasNature("org.eclipse.ptp.rdt.sync.core.remoteSyncNature")) {
                IRemoteResource remoteRes = (IRemoteResource)project.getAdapter(IRemoteResource.class);
                this.uri = remoteRes.getActiveLocationURI();
            } else {
                this.uri = project.getLocationURI();
            }
        }
        catch (CoreException e) {
            this.uri = project.getLocationURI();
        }
        this.lineSeparator = System.getProperty("line.separator", "\n");
    }

    public RDTCommandLauncher(URI uri) {
        this.uri = uri;
        this.lineSeparator = System.getProperty("line.separator", "\n");
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    private String[] getCommandArgs() {
        return this.fCommandArgs;
    }

    private static String[] constructCommandArray(String command, String[] commandArgs) {
        String[] args = new String[1 + commandArgs.length];
        args[0] = command;
        System.arraycopy(commandArgs, 0, args, 1, commandArgs.length);
        return args;
    }

    public Process execute(IPath commandPath, String[] args, String[] env, IPath changeToDirectory, IProgressMonitor monitor, PTY pty) {
        try {
            this.fCommandArgs = RDTCommandLauncher.constructCommandArray(commandPath.toOSString(), args);
            this.fShowCommand = true;
            IRemoteConnection connection = RDTProxyManager.getConnection(this.uri);
            if (connection == null) {
                this.fErrorMessage = Messages.RDTCommandLauncher_connection_not_found;
                return null;
            }
            if (!connection.isOpen()) {
                try {
                    connection.open(monitor);
                }
                catch (RemoteConnectionException e) {
                    this.fErrorMessage = e.getMessage();
                    return null;
                }
            }
            IRemoteProcessService ps = (IRemoteProcessService)connection.getService(IRemoteProcessService.class);
            IRemoteProcessBuilder builder = ps.getProcessBuilder(Arrays.asList(this.fCommandArgs));
            if (changeToDirectory != null) {
                IRemoteFileService fm = (IRemoteFileService)connection.getService(IRemoteFileService.class);
                builder.directory(fm.getResource(changeToDirectory.toString()));
            }
            Map envMap = builder.environment();
            block8: for (int i = 0; i < env.length; ++i) {
                String s = env[i];
                String[] tokens = s.split("=", 2);
                switch (tokens.length) {
                    case 1: {
                        envMap.put(tokens[0], null);
                        continue block8;
                    }
                    case 2: {
                        envMap.put(tokens[0], tokens[1]);
                        continue block8;
                    }
                    default: {
                        Activator.log(2, Messages.RDTCommandLauncher_malformed_env_var_string + s);
                    }
                }
            }
            this.fProcess = builder.start();
            this.fErrorMessage = "";
        }
        catch (IOException e) {
            this.fErrorMessage = e.getMessage();
            return null;
        }
        return new RemoteProcessAdapter(this.fProcess);
    }

    public int waitAndRead(OutputStream output, OutputStream err, IProgressMonitor monitor) {
        if (this.fShowCommand) {
            this.printCommandLine(output);
        }
        if (this.fProcess == null) {
            return -1;
        }
        RemoteProcessClosure closure = new RemoteProcessClosure(this.fProcess, output, err);
        closure.runNonBlocking();
        while (!monitor.isCanceled() && closure.isAlive()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        int state = 0;
        if (monitor.isCanceled()) {
            closure.terminate();
            state = 1;
            this.fErrorMessage = Activator.getResourceString("CommandLauncher.error.commandCanceled");
        }
        try {
            this.fProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return state;
    }

    private void printCommandLine(OutputStream os) {
        if (os != null) {
            String cmd = this.getCommandLine(this.getCommandArgs());
            try {
                os.write(cmd.getBytes());
                os.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private String getCommandLine(String[] commandArgs) {
        StringBuilder buf = new StringBuilder();
        if (this.fCommandArgs != null) {
            for (String commandArg : commandArgs) {
                buf.append(commandArg);
                buf.append(' ');
            }
            buf.append(this.lineSeparator);
        }
        return buf.toString();
    }

    public Process execute(IPath commandPath, String[] args, String[] env, IPath changeToDirectory, IProgressMonitor monitor) {
        return this.execute(commandPath, args, env, changeToDirectory, monitor, null);
    }
}

