
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;

/**
 * Immutable implementation of {@link EncryptionConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableEncryptionConfig.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableEncryptionConfig
    implements EncryptionConfig {
  private final @Nullable Boolean autoLockManagers;

  private ImmutableEncryptionConfig(@Nullable Boolean autoLockManagers) {
    this.autoLockManagers = autoLockManagers;
  }

  /**
   * @return The value of the {@code autoLockManagers} attribute
   */
  @JsonProperty("AutoLockManagers")
  @Override
  public @Nullable Boolean autoLockManagers() {
    return autoLockManagers;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link EncryptionConfig#autoLockManagers() autoLockManagers} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for autoLockManagers (can be {@code null})
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableEncryptionConfig withAutoLockManagers(@Nullable Boolean value) {
    if (Objects.equals(this.autoLockManagers, value)) return this;
    return new ImmutableEncryptionConfig(value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableEncryptionConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableEncryptionConfig
        && equalsByValue((ImmutableEncryptionConfig) another);
  }

  private boolean equalsByValue(ImmutableEncryptionConfig another) {
    return Objects.equals(autoLockManagers, another.autoLockManagers);
  }

  /**
   * Computes a hash code from attributes: {@code autoLockManagers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(autoLockManagers);
    return h;
  }

  /**
   * Prints the immutable value {@code EncryptionConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "EncryptionConfig{"
        + "autoLockManagers=" + autoLockManagers
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link EncryptionConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable EncryptionConfig instance
   */
  public static ImmutableEncryptionConfig copyOf(EncryptionConfig instance) {
    if (instance instanceof ImmutableEncryptionConfig) {
      return (ImmutableEncryptionConfig) instance;
    }
    return ImmutableEncryptionConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableEncryptionConfig ImmutableEncryptionConfig}.
   * <pre>
   * ImmutableEncryptionConfig.builder()
   *    .autoLockManagers(Boolean | null) // nullable {@link EncryptionConfig#autoLockManagers() autoLockManagers}
   *    .build();
   * </pre>
   * @return A new ImmutableEncryptionConfig builder
   */
  public static ImmutableEncryptionConfig.Builder builder() {
    return new ImmutableEncryptionConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableEncryptionConfig ImmutableEncryptionConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder implements EncryptionConfig.Builder {
    private Boolean autoLockManagers;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code EncryptionConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(EncryptionConfig instance) {
      Objects.requireNonNull(instance, "instance");
      @Nullable Boolean autoLockManagersValue = instance.autoLockManagers();
      if (autoLockManagersValue != null) {
        autoLockManagers(autoLockManagersValue);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link EncryptionConfig#autoLockManagers() autoLockManagers} attribute.
     * @param autoLockManagers The value for autoLockManagers (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("AutoLockManagers")
    public final Builder autoLockManagers(@Nullable Boolean autoLockManagers) {
      this.autoLockManagers = autoLockManagers;
      return this;
    }

    /**
     * Builds a new {@link ImmutableEncryptionConfig ImmutableEncryptionConfig}.
     * @return An immutable instance of EncryptionConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableEncryptionConfig build() {
      return new ImmutableEncryptionConfig(autoLockManagers);
    }
  }
}
