/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.cda.xml.ui.handlers;

import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.mdht.cda.xml.ui.handlers.CDAValueUtil;
import org.eclipse.mdht.cda.xml.ui.handlers.MatchEncounterBy;
import org.eclipse.mdht.uml.cda.Act;
import org.eclipse.mdht.uml.cda.Author;
import org.eclipse.mdht.uml.cda.Encounter;
import org.eclipse.mdht.uml.cda.Observation;
import org.eclipse.mdht.uml.cda.Organizer;
import org.eclipse.mdht.uml.cda.Procedure;
import org.eclipse.mdht.uml.cda.SubstanceAdministration;
import org.eclipse.mdht.uml.cda.Supply;
import org.eclipse.mdht.uml.hl7.datatypes.II;
import org.eclipse.mdht.uml.hl7.datatypes.IVL_TS;
import org.eclipse.mdht.uml.hl7.datatypes.SXCM_TS;

public class EncounterUtil {
    public static HashMap<EObject, MatchEncounterBy> encounterCache = new HashMap();

    public static boolean isWithinEncounterDateRate(Encounter encounter, Date date) {
        if (encounter.getEffectiveTime() != null) {
            Date edate;
            if (!StringUtils.isEmpty((String)encounter.getEffectiveTime().getValue()) && (edate = CDAValueUtil.getDate(encounter.getEffectiveTime().getValue())) != null) {
                if (edate.compareTo(date) == 0) {
                    return true;
                }
                if (edate.getYear() == date.getYear() && edate.getMonth() == date.getMonth() && edate.getDay() == date.getDay()) {
                    return true;
                }
            }
            if (encounter.getEffectiveTime().getLow() != null && !StringUtils.isEmpty((String)encounter.getEffectiveTime().getLow().getValue()) && (edate = CDAValueUtil.getDate(encounter.getEffectiveTime().getLow().getValue())) != null && edate.getYear() == date.getYear() && edate.getMonth() == date.getMonth() && edate.getDay() == date.getDay()) {
                return true;
            }
            if (encounter.getEffectiveTime().getHigh() != null && !StringUtils.isEmpty((String)encounter.getEffectiveTime().getLow().getValue()) && (edate = CDAValueUtil.getDate(encounter.getEffectiveTime().getHigh().getValue())) != null && edate != null && date != null && edate.getYear() == date.getYear() && edate.getMonth() == date.getMonth() && edate.getDay() == date.getDay()) {
                return true;
            }
        }
        return false;
    }

    public static MatchEncounterBy matchesEncounter(Encounter encounter, Act act) {
        if (encounterCache.containsKey(act)) {
            return encounterCache.get(act);
        }
        if (act == null) {
            encounterCache.put((EObject)act, MatchEncounterBy.NOMATCH);
            return MatchEncounterBy.NOMATCH;
        }
        for (II ii : act.getIds()) {
            for (II iii : encounter.getIds()) {
                if (!CDAValueUtil.getKey(ii).equals(CDAValueUtil.getKey(iii))) continue;
                encounterCache.put((EObject)act, MatchEncounterBy.NOMATCH);
                return MatchEncounterBy.BYID;
            }
        }
        Date observationTime = null;
        MatchEncounterBy result = MatchEncounterBy.BYEFFECTIVETIME;
        if (act.getEffectiveTime() != null) {
            IVL_TS ivlts = act.getEffectiveTime();
            if (observationTime == null && ivlts.getLow() != null && !StringUtils.isEmpty((String)ivlts.getLow().getValue())) {
                observationTime = CDAValueUtil.getDate(ivlts.getLow().getValue());
            }
            if (observationTime == null && ivlts.getHigh() != null && !StringUtils.isEmpty((String)ivlts.getHigh().getValue())) {
                observationTime = CDAValueUtil.getDate(ivlts.getHigh().getValue());
            }
        }
        if (observationTime == null) {
            for (Author author : act.getAuthors()) {
                if (author.getTime() == null || StringUtils.isEmpty((String)author.getTime().getValue())) continue;
                observationTime = CDAValueUtil.getDate(author.getTime().getValue());
                result = MatchEncounterBy.BYAUTHORID;
            }
        }
        if (observationTime != null && EncounterUtil.isWithinEncounterDateRate(encounter, observationTime)) {
            encounterCache.put((EObject)act, result);
            return result;
        }
        encounterCache.put((EObject)act, MatchEncounterBy.NOMATCH);
        return MatchEncounterBy.NOMATCH;
    }

    public static MatchEncounterBy matchesEncounter(Encounter encounter, Observation observation) {
        for (II ii : observation.getIds()) {
            for (II iii : encounter.getIds()) {
                if (!CDAValueUtil.getKey(ii).equals(CDAValueUtil.getKey(iii))) continue;
                return MatchEncounterBy.BYID;
            }
        }
        Date observationTime = null;
        MatchEncounterBy result = MatchEncounterBy.BYEFFECTIVETIME;
        if (observation.getEffectiveTime() != null) {
            IVL_TS ivlts = observation.getEffectiveTime();
            if (observationTime == null && ivlts.getLow() != null && !StringUtils.isEmpty((String)ivlts.getLow().getValue())) {
                observationTime = CDAValueUtil.getDate(ivlts.getLow().getValue());
            }
            if (observationTime == null && ivlts.getHigh() != null && !StringUtils.isEmpty((String)ivlts.getHigh().getValue())) {
                observationTime = CDAValueUtil.getDate(ivlts.getHigh().getValue());
            }
        }
        if (observationTime == null) {
            for (Author author : observation.getAuthors()) {
                if (author.getTime() == null || StringUtils.isEmpty((String)author.getTime().getValue())) continue;
                observationTime = CDAValueUtil.getDate(author.getTime().getValue());
                result = MatchEncounterBy.BYAUTHORID;
            }
        }
        if (observationTime != null && EncounterUtil.isWithinEncounterDateRate(encounter, observationTime)) {
            return result;
        }
        return MatchEncounterBy.NOMATCH;
    }

    public static MatchEncounterBy matchesEncounter(Encounter encounter, Organizer organizer) {
        if (encounterCache.containsKey(organizer)) {
            return encounterCache.get(organizer);
        }
        for (II ii : organizer.getIds()) {
            for (II iii : encounter.getIds()) {
                if (!CDAValueUtil.getKey(ii).equals(CDAValueUtil.getKey(iii))) continue;
                encounterCache.put((EObject)organizer, MatchEncounterBy.BYID);
                return MatchEncounterBy.BYID;
            }
        }
        Date observationTime = null;
        MatchEncounterBy result = MatchEncounterBy.BYEFFECTIVETIME;
        if (organizer.getEffectiveTime() != null) {
            IVL_TS ivlts = organizer.getEffectiveTime();
            if (observationTime == null && ivlts.getLow() != null && !StringUtils.isEmpty((String)ivlts.getLow().getValue())) {
                observationTime = CDAValueUtil.getDate(ivlts.getLow().getValue());
            }
            if (observationTime == null && ivlts.getHigh() != null && !StringUtils.isEmpty((String)ivlts.getHigh().getValue())) {
                observationTime = CDAValueUtil.getDate(ivlts.getHigh().getValue());
            }
        }
        if (observationTime == null) {
            for (Author author : organizer.getAuthors()) {
                if (author.getTime() == null || StringUtils.isEmpty((String)author.getTime().getValue())) continue;
                observationTime = CDAValueUtil.getDate(author.getTime().getValue());
                result = MatchEncounterBy.BYAUTHORID;
            }
        }
        if (observationTime != null && EncounterUtil.isWithinEncounterDateRate(encounter, observationTime)) {
            encounterCache.put((EObject)organizer, result);
            return result;
        }
        encounterCache.put((EObject)organizer, MatchEncounterBy.NOMATCH);
        return MatchEncounterBy.NOMATCH;
    }

    public static MatchEncounterBy matchesEncounter(Encounter encounter, Procedure procedure) {
        for (II ii : procedure.getIds()) {
            for (II iii : encounter.getIds()) {
                if (!CDAValueUtil.getKey(ii).equals(CDAValueUtil.getKey(iii))) continue;
                return MatchEncounterBy.BYID;
            }
        }
        Date observationTime = null;
        MatchEncounterBy result = MatchEncounterBy.BYEFFECTIVETIME;
        if (procedure.getEffectiveTime() != null) {
            IVL_TS ivlts = procedure.getEffectiveTime();
            if (observationTime == null && ivlts.getLow() != null && !StringUtils.isEmpty((String)ivlts.getLow().getValue())) {
                observationTime = CDAValueUtil.getDate(ivlts.getLow().getValue());
            }
            if (observationTime == null && ivlts.getHigh() != null && !StringUtils.isEmpty((String)ivlts.getHigh().getValue())) {
                observationTime = CDAValueUtil.getDate(ivlts.getHigh().getValue());
            }
        }
        if (observationTime == null) {
            for (Author author : procedure.getAuthors()) {
                if (author.getTime() == null || StringUtils.isEmpty((String)author.getTime().getValue())) continue;
                observationTime = CDAValueUtil.getDate(author.getTime().getValue());
                result = MatchEncounterBy.BYAUTHORID;
            }
        }
        if (observationTime != null && EncounterUtil.isWithinEncounterDateRate(encounter, observationTime)) {
            return result;
        }
        return MatchEncounterBy.NOMATCH;
    }

    public static MatchEncounterBy matchesEncounter(Encounter encounter, SubstanceAdministration item) {
        for (Encounter e : item.getEncounters()) {
            for (II ii : e.getIds()) {
                for (II iii : encounter.getIds()) {
                    if (!CDAValueUtil.getKey(ii).equals(CDAValueUtil.getKey(iii))) continue;
                    return MatchEncounterBy.BYID;
                }
            }
        }
        MatchEncounterBy result = MatchEncounterBy.BYEFFECTIVETIME;
        Date substanceAdminTime = null;
        for (SXCM_TS ts : item.getEffectiveTimes()) {
            if (ts instanceof IVL_TS) {
                IVL_TS ivlts = (IVL_TS)ts;
                if (ivlts.getLow() == null || ivlts.getLow().getValue() == null) continue;
                substanceAdminTime = CDAValueUtil.getDate(ivlts.getLow().getValue());
                continue;
            }
            if (StringUtils.isEmpty((String)ts.getValue())) continue;
            substanceAdminTime = CDAValueUtil.getDate(ts.getValue());
        }
        if (substanceAdminTime == null) {
            for (Author author : item.getAuthors()) {
                if (author.getTime() == null || StringUtils.isEmpty((String)author.getTime().getValue())) continue;
                substanceAdminTime = CDAValueUtil.getDate(author.getTime().getValue());
            }
        }
        if (substanceAdminTime != null && EncounterUtil.isWithinEncounterDateRate(encounter, substanceAdminTime)) {
            return result;
        }
        return MatchEncounterBy.NOMATCH;
    }

    public static MatchEncounterBy matchesEncounter(Encounter encounter, Supply supply) {
        for (Encounter e : supply.getEncounters()) {
            for (II ii : e.getIds()) {
                for (II iii : encounter.getIds()) {
                    if (!CDAValueUtil.getKey(ii).equals(CDAValueUtil.getKey(iii))) continue;
                    return MatchEncounterBy.BYID;
                }
            }
        }
        Date supplyTime = null;
        MatchEncounterBy result = MatchEncounterBy.BYEFFECTIVETIME;
        for (SXCM_TS ts : supply.getEffectiveTimes()) {
            if (ts instanceof IVL_TS) {
                IVL_TS ivlts = (IVL_TS)ts;
                if (ivlts.getLow() == null || ivlts.getLow().getValue() == null) continue;
                supplyTime = CDAValueUtil.getDate(ivlts.getLow().getValue());
                continue;
            }
            if (StringUtils.isEmpty((String)ts.getValue())) continue;
            supplyTime = CDAValueUtil.getDate(ts.getValue());
        }
        if (supplyTime == null) {
            for (Author author : supply.getAuthors()) {
                if (author.getTime() == null || StringUtils.isEmpty((String)author.getTime().getValue())) continue;
                supplyTime = CDAValueUtil.getDate(author.getTime().getValue());
                result = MatchEncounterBy.BYAUTHORID;
            }
        }
        if (supplyTime != null && EncounterUtil.isWithinEncounterDateRate(encounter, supplyTime)) {
            return result;
        }
        return MatchEncounterBy.NOMATCH;
    }
}

