/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.cda.ui.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mdht.uml.cda.core.profile.ActRelationship;
import org.eclipse.mdht.uml.cda.core.util.CDAProfileUtil;
import org.eclipse.mdht.uml.cda.core.util.RIMModelUtil;
import org.eclipse.mdht.uml.ui.properties.sections.WrapperAwareModelerPropertySection;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Stereotype;

public class ActRelationshipSection
extends WrapperAwareModelerPropertySection {
    private Association association;
    private List<Class> associationTypes = new ArrayList<Class>();
    private CCombo associationTypeCombo;
    private boolean associationTypeModified = false;
    private CCombo typeCodeCombo;
    private boolean typeCodeModified = false;

    private void modifyFields() {
        if (!this.associationTypeModified && !this.typeCodeModified) {
            return;
        }
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)this.association);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    ActRelationship actRelationship;
                    Stereotype actRelationshipStereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)ActRelationshipSection.this.association, (String)"ActRelationship");
                    if (actRelationshipStereotype == null) {
                        actRelationshipStereotype = CDAProfileUtil.applyCDAStereotype((Element)ActRelationshipSection.this.association, (String)"ActRelationship");
                    }
                    if ((actRelationship = CDAProfileUtil.getActRelationship((Association)ActRelationshipSection.this.association)) == null) {
                        return Status.CANCEL_STATUS;
                    }
                    if (ActRelationshipSection.this.associationTypeModified) {
                        ActRelationshipSection.this.associationTypeModified = false;
                        this.setLabel("Set Association Type");
                    }
                    if (!ActRelationshipSection.this.typeCodeModified) {
                        return Status.CANCEL_STATUS;
                    }
                    ActRelationshipSection.this.typeCodeModified = false;
                    this.setLabel("Set Type Code");
                    return Status.OK_STATUS;
                }
            };
            this.execute((IUndoableOperation)operation);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private void fillAssociationTypeCombo() {
        this.associationTypes = RIMModelUtil.getAssociationTypes((Association)this.association);
        if (this.associationTypes.isEmpty()) {
            this.associationTypeCombo.setItems(new String[0]);
        } else {
            ArrayList<String> items = new ArrayList<String>();
            items.add("");
            for (Class type : this.associationTypes) {
                items.add(type.getLabel(true));
            }
            this.associationTypeCombo.setItems(items.toArray(new String[items.size()]));
        }
    }

    private void fillTypeCodeCombo() {
        List typeCodes;
        Class associationType = null;
        if (this.associationTypeCombo.getSelectionIndex() > 0) {
            associationType = this.associationTypes.get(this.associationTypeCombo.getSelectionIndex() - 1);
        }
        if ((typeCodes = RIMModelUtil.getTypeCodes(associationType)).isEmpty()) {
            this.typeCodeCombo.setItems(new String[0]);
        } else {
            ArrayList<String> items = new ArrayList<String>();
            items.add("");
            for (EnumerationLiteral literal : typeCodes) {
                items.add(literal.getLabel(true));
            }
            this.typeCodeCombo.setItems(items.toArray(new String[items.size()]));
        }
    }

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        FormData data = null;
        this.associationTypeCombo = this.getWidgetFactory().createCCombo(composite, 0x800008);
        this.associationTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ActRelationshipSection.this.associationTypeModified = true;
                ActRelationshipSection.this.modifyFields();
                ActRelationshipSection.this.fillTypeCodeCombo();
            }

            public void widgetSelected(SelectionEvent e) {
                ActRelationshipSection.this.associationTypeModified = true;
                ActRelationshipSection.this.modifyFields();
                ActRelationshipSection.this.fillTypeCodeCombo();
            }
        });
        CLabel associationTypeLabel = this.getWidgetFactory().createCLabel(composite, "Association Type:");
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.associationTypeCombo, 0, 0x1000000);
        associationTypeLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)associationTypeLabel, 0);
        data.top = new FormAttachment((Control)this.associationTypeCombo, 0, 0x1000000);
        this.associationTypeCombo.setLayoutData((Object)data);
        this.typeCodeCombo = this.getWidgetFactory().createCCombo(composite, 0x800008);
        this.typeCodeCombo.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ActRelationshipSection.this.typeCodeModified = true;
                ActRelationshipSection.this.modifyFields();
            }

            public void widgetSelected(SelectionEvent e) {
                ActRelationshipSection.this.typeCodeModified = true;
                ActRelationshipSection.this.modifyFields();
            }
        });
        CLabel typeCodeLabel = this.getWidgetFactory().createCLabel(composite, "Type Code:");
        data = new FormData();
        data.left = new FormAttachment((Control)this.associationTypeCombo, 5);
        data.top = new FormAttachment((Control)this.typeCodeCombo, 0, 0x1000000);
        typeCodeLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)typeCodeLabel, 0);
        data.top = new FormAttachment((Control)this.typeCodeCombo, 0, 0x1000000);
        this.typeCodeCombo.setLayoutData((Object)data);
    }

    protected boolean isReadOnly() {
        TransactionalEditingDomain editingDomain;
        if (this.association != null && (editingDomain = TransactionUtil.getEditingDomain((EObject)this.association)) != null && editingDomain.isReadOnly(this.association.eResource())) {
            return true;
        }
        return super.isReadOnly();
    }

    protected boolean addToEObjectList(Object object) {
        boolean added = super.addToEObjectList(object);
        if (!added && object instanceof Element) {
            this.getEObjectList().add(object);
            added = true;
        }
        return added;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        EObject element = this.getEObject();
        Assert.isTrue((boolean)(element instanceof NamedElement));
        this.association = (Association)element;
    }

    public void dispose() {
        super.dispose();
    }

    public void refresh() {
        Stereotype stereotype = CDAProfileUtil.getAppliedCDAStereotype((Element)this.association, (String)"EntryRelationship");
        Enumeration entryRelKind = null;
        Profile cdaProfile = CDAProfileUtil.getCDAProfile((ResourceSet)this.association.eResource().getResourceSet());
        if (cdaProfile != null) {
            entryRelKind = (Enumeration)cdaProfile.getOwnedType("EntryRelationshipKind");
        }
        this.fillAssociationTypeCombo();
        this.fillTypeCodeCombo();
        this.typeCodeCombo.select(0);
        if (stereotype != null) {
            EnumerationLiteral literal;
            Object value = this.association.getValue(stereotype, "typeCode");
            String typeCode = null;
            if (value instanceof EnumerationLiteral) {
                typeCode = ((EnumerationLiteral)value).getName();
            } else if (value instanceof Enumerator) {
                typeCode = ((Enumerator)value).getName();
            }
            if (typeCode != null && (literal = entryRelKind.getOwnedLiteral(typeCode)) != null) {
                int index = entryRelKind.getOwnedLiterals().indexOf((Object)literal);
                this.typeCodeCombo.select(index + 1);
            }
        }
        if (this.isReadOnly()) {
            this.typeCodeCombo.setEnabled(false);
        } else {
            this.typeCodeCombo.setEnabled(true);
        }
    }

    public void update(Notification notification, EObject element) {
        if (!this.isDisposed()) {
            this.postUpdateRequest(new Runnable(){

                @Override
                public void run() {
                    if (!ActRelationshipSection.this.isDisposed() && ActRelationshipSection.this.association.eResource() != null) {
                        ActRelationshipSection.this.refresh();
                    }
                }
            });
        }
    }
}

