/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.ui.editors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.ui.ViewerPane;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.dnd.EditingDomainViewerDropAdapter;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mdht.uml.common.UmlPlugin;
import org.eclipse.mdht.uml.common.ui.dialogs.DialogLaunchUtil;
import org.eclipse.mdht.uml.common.ui.saveable.ModelDocument;
import org.eclipse.mdht.uml.common.ui.saveable.ModelManager;
import org.eclipse.mdht.uml.common.ui.search.IElementFilter;
import org.eclipse.mdht.uml.common.ui.search.PropertyTypeFilter;
import org.eclipse.mdht.uml.common.ui.search.StereotypePropertyTypeFilter;
import org.eclipse.mdht.uml.common.ui.util.AdapterFactoryCellModifier;
import org.eclipse.mdht.uml.common.ui.util.ComboBoxTextCellEditor;
import org.eclipse.mdht.uml.common.ui.util.TreeCursor;
import org.eclipse.mdht.uml.common.util.NamedElementComparator;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.edit.IUMLTableProperties;
import org.eclipse.mdht.uml.edit.provider.SimpleListNotifier;
import org.eclipse.mdht.uml.edit.provider.UML2ExtendedAdapterFactory;
import org.eclipse.mdht.uml.edit.reflection.ExtendedReflectiveItemProviderAdapterFactory;
import org.eclipse.mdht.uml.ui.editors.TableEditorComposedAdapterFactory;
import org.eclipse.mdht.uml.ui.editors.UMLOutlinePage;
import org.eclipse.mdht.uml.ui.editors.UMLTableActionBarContributor;
import org.eclipse.mdht.uml.ui.internal.UML2UIPlugin;
import org.eclipse.mdht.uml.ui.internal.l10n.UML2UIMessages;
import org.eclipse.mdht.uml.ui.navigator.DecoratorAdapterFactoryLabelProvider;
import org.eclipse.mdht.uml.ui.navigator.UMLDomainNavigatorItem;
import org.eclipse.mdht.uml.ui.navigator.actions.EditCommandsFactory;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class UMLTableEditor
extends EditorPart
implements IEditingDomainProvider,
IMenuListener,
ISelectionChangedListener,
ISetSelectionTarget,
IGotoMarker,
ITabbedPropertySheetPageContributor,
ISaveablesSource {
    public static final String EDITOR_ID = "org.eclipse.mdht.uml.ui.UMLTableEditorID";
    private TransactionalEditingDomain editingDomain;
    private IStructuredSelection viewSelection = null;
    private Resource resource = null;
    private ResourceSetListener dirtyResourceListener = null;
    private ResourceSetListener resourceLoadListener = null;
    protected TabbedPropertySheetPage propertySheetPage;
    private EditCommandsFactory editCommandsFactory = new EditCommandsFactory();
    private ComposedAdapterFactory adapterFactory;
    private AdapterFactoryContentProvider adapterFactoryContentProvider;
    private ILabelProvider adapterFactoryLabelProvider;
    private ViewerPane viewerPane;
    private TreeViewer treeViewerWithColumns;
    private TreeCursor cursor;
    private IOperationHistoryListener historyListener = new IOperationHistoryListener(){

        public void historyNotification(OperationHistoryEvent event) {
            if (event.getEventType() == 4 || event.getEventType() == 10 || event.getEventType() == 9) {
                ISaveablesLifecycleListener saveablesListener = (ISaveablesLifecycleListener)UMLTableEditor.this.getEditorSite().getService(ISaveablesLifecycleListener.class);
                if (saveablesListener != null) {
                    saveablesListener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)UMLTableEditor.this, 257, UMLTableEditor.this.getSaveables(), false));
                }
                UMLTableEditor.this.getSite().getShell().getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        UMLTableEditor.this.refresh();
                        if ((this).UMLTableEditor.this.propertySheetPage != null) {
                            (this).UMLTableEditor.this.propertySheetPage.refresh();
                        }
                        if (UMLTableEditor.this.cursor != null && !UMLTableEditor.this.cursor.isDisposed()) {
                            UMLTableEditor.this.cursor.redraw();
                        }
                    }
                });
            }
        }
    };
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart p) {
            if (!(p instanceof ContentOutline)) {
                if (p instanceof PropertySheet) {
                    if (((PropertySheet)p).getCurrentPage() == UMLTableEditor.this.propertySheetPage) {
                        UMLTableEditor.this.getActionBarContributor().setActiveEditor((IEditorPart)UMLTableEditor.this);
                        UMLTableEditor.this.handleActivate();
                    }
                } else if (p == UMLTableEditor.this) {
                    UMLTableEditor.this.editCommandsFactory.setActivePart((IWorkbenchPart)UMLTableEditor.this);
                    UMLTableEditor.this.handleActivate();
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPart p) {
        }

        public void partClosed(IWorkbenchPart p) {
        }

        public void partDeactivated(IWorkbenchPart p) {
            if (p == UMLTableEditor.this) {
                UMLTableEditor.this.editCommandsFactory.setActivePart(null);
            }
        }

        public void partOpened(IWorkbenchPart p) {
        }
    };
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (ModelManager.getManager().getChangedResources().contains(UMLTableEditor.this.resource)) {
                UMLTableEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (UMLTableEditor.this.getSite().getPage().getActiveEditor() == UMLTableEditor.this) {
                            UMLTableEditor.this.handleActivate();
                        }
                    }
                });
            }
        }
    };
    private Action baseTypeFilterAction = new BaseTypeFilterAction();
    private Class baseTypeFilter = null;
    private Action containerFilterAction = new ContainerFilterAction();
    private Class containerFilter = null;
    private Action containerFilterMenuAction = new ContainerFilterMenuAction();
    private Action resourceFilterAction = new ResourceFilterAction();
    private Resource resourceFilter = null;
    private Action resourceFilterMenuAction = new ResourceFilterMenuAction();
    private Action removeFiltersAction = new RemoveFilterAction();

    protected void handleActivate() {
        Collection changedResources;
        if (this.editingDomain instanceof AdapterFactoryEditingDomain && ((AdapterFactoryEditingDomain)this.editingDomain).getResourceToReadOnlyMap() != null) {
            ((AdapterFactoryEditingDomain)this.editingDomain).getResourceToReadOnlyMap().clear();
        }
        if ((changedResources = ModelManager.getManager().getChangedResources()).contains(this.resource)) {
            this.handleChangedResources();
        } else {
            for (Resource controlledResource : UMLUtil.getControlledResources((Resource)this.resource)) {
                if (!changedResources.contains(controlledResource)) continue;
                this.handleChangedResources();
                break;
            }
        }
    }

    protected void handleChangedResources() {
        if (!this.isDirty()) {
            this.treeViewerWithColumns.refresh();
            this.setDefaultSelection();
            if (AdapterFactoryEditingDomain.isStale((Object)this.getSite().getSelectionProvider().getSelection())) {
                this.getSite().getSelectionProvider().setSelection((ISelection)StructuredSelection.EMPTY);
            }
        }
    }

    void refresh() {
        this.getSite().getSelectionProvider().getSelection();
        this.treeViewerWithColumns.refresh();
    }

    public UMLTableEditor() {
        this.editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.mdht.uml.common.ui.EditingDomain");
        if (this.editingDomain instanceof AdapterFactoryEditingDomain && ((AdapterFactoryEditingDomain)this.editingDomain).getResourceToReadOnlyMap() == null) {
            ((AdapterFactoryEditingDomain)this.editingDomain).setResourceToReadOnlyMap(new Hashtable());
        }
        ModelManager.getManager().manage(this.editingDomain);
        this.adapterFactory = new TableEditorComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        this.adapterFactory.addAdapterFactory((AdapterFactory)new UML2ExtendedAdapterFactory());
        this.adapterFactory.addAdapterFactory((AdapterFactory)new ExtendedReflectiveItemProviderAdapterFactory());
        this.adapterFactoryContentProvider = new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory);
        this.adapterFactoryLabelProvider = new DecoratorAdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory);
        this.getOperationHistory().addOperationHistoryListener(this.historyListener);
        UmlPlugin.computeModelPathMapExtensions();
        this.editingDomain.getResourceSet().getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap((boolean)false));
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public Element getSelectedElement() {
        Element element = null;
        ISelection selection = this.getSite().getSelectionProvider().getSelection();
        if (((IStructuredSelection)selection).size() == 1) {
            Object firstElement = ((IStructuredSelection)selection).getFirstElement();
            if (firstElement instanceof UMLDomainNavigatorItem) {
                firstElement = ((UMLDomainNavigatorItem)firstElement).getEObject();
            }
            if (firstElement instanceof Element) {
                element = (Element)firstElement;
            }
        }
        return element;
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    private IOperationHistory getOperationHistory() {
        return ((IWorkspaceCommandStack)this.editingDomain.getCommandStack()).getOperationHistory();
    }

    public IUndoContext getUndoContext() {
        return ((IWorkspaceCommandStack)this.getEditingDomain().getCommandStack()).getDefaultUndoContext();
    }

    public UMLTableActionBarContributor getActionBarContributor() {
        return (UMLTableActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public IActionBars getActionBars() {
        return this.getActionBarContributor().getActionBars();
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(input);
        this.setPartName(input.getName());
        site.getPage().addPartListener(this.partListener);
        this.editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain("org.eclipse.mdht.uml.common.ui.EditingDomain");
        ModelManager.getManager().manage(this.editingDomain);
        ModelManager.getManager().setShell(this.getSite().getShell());
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            URI resourceURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)false);
            try {
                this.resource = this.editingDomain.getResourceSet().getResource(resourceURI, true);
                this.setDefaultSelection();
            }
            catch (Exception e) {
                this.resource = this.editingDomain.getResourceSet().getResource(resourceURI, false);
                this.setDefaultSelection();
            }
        }
        this.resourceLoadListener = new ResourceSetListenerImpl(NotificationFilter.RESOURCE_UNLOADED){

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                for (Notification notification : event.getNotifications()) {
                    Resource resource = (Resource)notification.getNotifier();
                    if (ModelManager.getManager().getChangedResources().contains(resource) || !resource.getURI().isPlatform() || !UMLTableEditor.this.resource.getURI().equals(resource.getURI())) continue;
                    UMLTableEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            UMLTableEditor.this.getSite().getPage().closeEditor((IEditorPart)UMLTableEditor.this, false);
                        }
                    });
                }
            }
        };
        this.editingDomain.addResourceSetListener(this.resourceLoadListener);
        this.dirtyResourceListener = new ResourceSetListenerImpl(NotificationFilter.NOT_TOUCH.and(NotificationFilter.READ.negated().or(NotificationFilter.createFeatureFilter((EClassifier)EcorePackage.Literals.ERESOURCE, (int)3)))){
            private final AtomicBoolean pending;
            {
                this.pending = new AtomicBoolean();
            }

            public void resourceSetChanged(ResourceSetChangeEvent event) {
                if (this.pending.compareAndSet(false, true)) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                UMLTableEditor.this.firePropertyChange(257);
                            }
                            finally {
                                pending.set(false);
                            }
                        }
                    });
                }
            }
        };
        this.editingDomain.addResourceSetListener(this.dirtyResourceListener);
    }

    public void dispose() {
        this.getOperationHistory().removeOperationHistoryListener(this.historyListener);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
        this.adapterFactoryContentProvider.dispose();
        this.adapterFactory.dispose();
        this.getSite().getPage().removePartListener(this.partListener);
        this.partListener = null;
        if (this.getActionBarContributor() != null && this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.editingDomain != null) {
            this.editingDomain.removeResourceSetListener(this.resourceLoadListener);
            this.editingDomain.removeResourceSetListener(this.dirtyResourceListener);
        }
        this.resourceLoadListener = null;
        this.dirtyResourceListener = null;
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.viewerPane = new ViewerPane(this.getSite().getPage(), (IWorkbenchPart)this){

            public Viewer createViewer(Composite composite) {
                return new TreeViewer(composite, 68354){

                    protected void hookControl(Control control) {
                        super.hookControl(control);
                        Tree treeControl = (Tree)control;
                        treeControl.addMouseListener((MouseListener)new MouseAdapter(){

                            public void mouseDown(MouseEvent e) {
                                this.cancelEditing();
                            }
                        });
                    }
                };
            }

            public void requestActivation() {
                super.requestActivation();
            }
        };
        this.viewerPane.createControl(parent);
        this.contributeToToolBar((IToolBarManager)this.viewerPane.getToolBarManager());
        this.treeViewerWithColumns = (TreeViewer)this.viewerPane.getViewer();
        this.treeViewerWithColumns.setAutoExpandLevel(2);
        final Tree tree = this.treeViewerWithColumns.getTree();
        tree.setLayoutData((Object)new FillLayout());
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeColumn column = new TreeColumn(tree, 0);
        column.setText("Name");
        column.setResizable(true);
        column.setWidth(225);
        column = new TreeColumn(tree, 0);
        column.setText("Type");
        column.setResizable(true);
        column.setWidth(125);
        column = new TreeColumn(tree, 0);
        column.setText("Multiplicity");
        column.setResizable(true);
        column.setWidth(80);
        column = new TreeColumn(tree, 0);
        column.setText("Aggregation");
        column.setResizable(false);
        column.setWidth(0);
        column = new TreeColumn(tree, 0);
        column.setText("Visibility");
        column.setResizable(false);
        column.setWidth(0);
        column = new TreeColumn(tree, 0);
        column.setText("Annotation");
        column.setResizable(true);
        column.setWidth(175);
        column = new TreeColumn(tree, 0);
        column.setText("Value");
        column.setResizable(true);
        column.setWidth(200);
        this.treeViewerWithColumns.setColumnProperties(new String[]{IUMLTableProperties.NAME_PROPERTY, IUMLTableProperties.TYPE_PROPERTY, "multiplicity", IUMLTableProperties.AGGREGATION_PROPERTY, IUMLTableProperties.VISIBILITY_PROPERTY, "annotation", IUMLTableProperties.DEFAULT_VALUE_PROPERTY});
        this.treeViewerWithColumns.setContentProvider((IContentProvider)this.adapterFactoryContentProvider);
        this.treeViewerWithColumns.setLabelProvider((IBaseLabelProvider)this.adapterFactoryLabelProvider);
        this.treeViewerWithColumns.setCellModifier((ICellModifier)new AdapterFactoryCellModifier((AdapterFactory)this.adapterFactory));
        TextCellEditor textCellEditor = new TextCellEditor((Composite)tree){

            protected void doSetValue(Object value) {
                if (value != null) {
                    super.doSetValue(value);
                }
            }

            public void deactivate() {
                super.deactivate();
                if (UMLTableEditor.this.cursor != null && UMLTableEditor.this.cursor.getRow() != null) {
                    UMLTableEditor.this.treeViewerWithColumns.update(UMLTableEditor.this.cursor.getRow().getData(), null);
                }
            }
        };
        ComboBoxTextCellEditor multiplicityEditor = new ComboBoxTextCellEditor((Composite)tree, new String[]{"0..*", "0..1", "1..1", "1..*"}){

            public void deactivate() {
                super.deactivate();
                if (UMLTableEditor.this.cursor != null && UMLTableEditor.this.cursor.getRow() != null) {
                    UMLTableEditor.this.treeViewerWithColumns.update(UMLTableEditor.this.cursor.getRow().getData(), null);
                }
            }
        };
        ComboBoxCellEditor aggregationEditor = new ComboBoxCellEditor((Composite)tree, new String[]{AggregationKind.get((int)0).getName(), AggregationKind.get((int)1).getName(), AggregationKind.get((int)2).getName()}){

            public void deactivate() {
                super.deactivate();
                if (UMLTableEditor.this.cursor != null && UMLTableEditor.this.cursor.getRow() != null) {
                    UMLTableEditor.this.treeViewerWithColumns.update(UMLTableEditor.this.cursor.getRow().getData(), null);
                }
            }
        };
        ComboBoxCellEditor visibilityEditor = new ComboBoxCellEditor((Composite)tree, new String[]{VisibilityKind.get((int)0).getName(), VisibilityKind.get((int)1).getName(), VisibilityKind.get((int)2).getName(), VisibilityKind.get((int)3).getName()}){

            public void deactivate() {
                super.deactivate();
                if (UMLTableEditor.this.cursor != null && UMLTableEditor.this.cursor.getRow() != null) {
                    UMLTableEditor.this.treeViewerWithColumns.update(UMLTableEditor.this.cursor.getRow().getData(), null);
                }
            }
        };
        ExtendedDialogCellEditor typeEditor = new ExtendedDialogCellEditor((Composite)tree, (ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory)){

            public void deactivate() {
                super.deactivate();
                if (UMLTableEditor.this.cursor != null && UMLTableEditor.this.cursor.getRow() != null) {
                    UMLTableEditor.this.treeViewerWithColumns.update(UMLTableEditor.this.cursor.getRow().getData(), null);
                }
            }

            protected Object openDialogBox(Control cellEditorWindow) {
                Element selectedElement = UMLTableEditor.this.getSelectedElement();
                Package topPackage = UMLUtil.getTopPackage((Element)selectedElement);
                Object type = null;
                type = topPackage instanceof Profile ? (selectedElement instanceof Extension ? DialogLaunchUtil.chooseUMLMetaclass((ResourceSet)UMLTableEditor.this.editingDomain.getResourceSet(), (Shell)UMLTableEditor.this.getSite().getShell()) : (selectedElement instanceof Property && ((Property)selectedElement).getClass_() instanceof Stereotype ? DialogLaunchUtil.chooseElement((IElementFilter)new StereotypePropertyTypeFilter(), (Package)topPackage, (Shell)UMLTableEditor.this.getSite().getShell()) : DialogLaunchUtil.chooseElement((IElementFilter)new PropertyTypeFilter(), (Package)topPackage, (Shell)UMLTableEditor.this.getSite().getShell()))) : DialogLaunchUtil.chooseElement((IElementFilter)new PropertyTypeFilter(), (Package)topPackage, (Shell)UMLTableEditor.this.getSite().getShell());
                return type;
            }
        };
        CellEditor[] cellEditorArray = new CellEditor[7];
        cellEditorArray[0] = textCellEditor;
        cellEditorArray[1] = typeEditor;
        cellEditorArray[2] = multiplicityEditor;
        cellEditorArray[3] = aggregationEditor;
        cellEditorArray[4] = visibilityEditor;
        cellEditorArray[6] = textCellEditor;
        CellEditor[] cellEditors = cellEditorArray;
        this.treeViewerWithColumns.setCellEditors(cellEditors);
        this.cursor = new TreeCursor(tree, 0){

            public void handleDoubleClick(Event event) {
                UMLTableEditor.this.treeViewerWithColumns.editElement((Object)this.getTreePath(this.getRow()), this.getColumn());
            }
        };
        this.cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                tree.setSelection(UMLTableEditor.this.cursor.getRow());
                Event event = new Event();
                event.item = UMLTableEditor.this.cursor.getRow();
                tree.notifyListeners(13, event);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                TreeItem row = UMLTableEditor.this.cursor.getRow();
                int column = UMLTableEditor.this.cursor.getColumn();
                UMLTableEditor.this.treeViewerWithColumns.editElement((Object)UMLTableEditor.this.cursor.getTreePath(row), column);
            }
        });
        if (this.viewSelection != null && this.viewSelection.size() > 1) {
            this.treeViewerWithColumns.setAutoExpandLevel(1);
        }
        this.treeViewerWithColumns.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
            }

            public void treeExpanded(TreeExpansionEvent event) {
            }
        });
        this.getEditorSite().setSelectionProvider((ISelectionProvider)new SelectionProvider((Control)tree));
        this.updateViewContents();
        if (this.viewSelection != null && this.viewSelection.size() >= 1) {
            this.treeViewerWithColumns.setSelection((ISelection)new StructuredSelection(this.viewSelection.getFirstElement()));
        }
        this.treeViewerWithColumns.setAutoExpandLevel(1);
        this.treeViewerWithColumns.getControl().addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                Rectangle cursorBounds;
                if (UMLTableEditor.this.cursor != null && (cursorBounds = UMLTableEditor.this.cursor.getBounds()).contains(((Control)e.widget).toControl(e.x, e.y))) {
                    e.doit = false;
                }
            }
        });
        this.createContextMenuFor(this.treeViewerWithColumns.getControl(), (ISelectionProvider)this.treeViewerWithColumns, (StructuredViewer)this.treeViewerWithColumns);
        this.createContextMenuFor((Control)this.cursor, this.getEditorSite().getSelectionProvider(), (StructuredViewer)this.treeViewerWithColumns);
    }

    private void updateViewContents() {
        if (this.viewSelection != null && this.getSite().getSelectionProvider() != null) {
            this.getSite().getSelectionProvider().setSelection((ISelection)this.viewSelection);
        }
    }

    private void setDefaultSelection() {
        if (this.resource != null && !this.resource.getContents().isEmpty()) {
            ArrayList<NamedElement> contents = new ArrayList<NamedElement>();
            for (EObject eObject : this.resource.getContents()) {
                if (!(eObject instanceof Package) && (!(eObject instanceof Classifier) || eObject instanceof Association)) continue;
                contents.add((NamedElement)eObject);
            }
            this.viewSelection = new StructuredSelection(contents);
            this.updateViewContents();
            this.selectReveal((ISelection)this.viewSelection);
        }
    }

    private void computeBaseTypeFilterSelection() {
        if (this.baseTypeFilter == null) {
            return;
        }
        final ArrayList contents = new ArrayList();
        UMLSwitch<Object> umlSwitch = new UMLSwitch<Object>(){

            public Object caseClass(Class classifier) {
                ArrayList<Class> allParents = new ArrayList<Class>((Collection<Class>)classifier.allParents());
                allParents.add(classifier);
                if (allParents.contains(UMLTableEditor.this.baseTypeFilter)) {
                    contents.add(classifier);
                }
                return classifier;
            }

            public Object casePackage(Package pkg) {
                for (NamedElement namedElement : pkg.getOwnedMembers()) {
                    this.doSwitch((EObject)namedElement);
                }
                return pkg;
            }
        };
        umlSwitch.doSwitch((EObject)this.resource.getContents().get(0));
        Collections.sort(contents, new NamedElementComparator());
        this.viewSelection = new StructuredSelection(contents);
        this.updateViewContents();
    }

    private void computeContainerFilterSelection() {
        if (this.containerFilter == null) {
            return;
        }
        HashSet<Classifier> contents = new HashSet<Classifier>();
        this.appendContainerFilterSelection((Classifier)this.containerFilter, contents);
        ArrayList<Classifier> sortedContents = new ArrayList<Classifier>(contents);
        Collections.sort(sortedContents, new NamedElementComparator());
        this.viewSelection = new StructuredSelection(sortedContents);
        this.updateViewContents();
        this.selectReveal((ISelection)new StructuredSelection((Object)this.containerFilter));
    }

    private void appendContainerFilterSelection(Classifier classifier, Set<Classifier> contents) {
        if (this.resource.equals(classifier.eResource()) || UMLUtil.getControlledResources((Resource)this.resource).contains(classifier.eResource())) {
            contents.add(classifier);
            List subtypes = UMLUtil.getAllSpecializations((Classifier)classifier);
            for (Classifier subtype : subtypes) {
                this.appendContainerFilterSelection(subtype, contents);
            }
            for (Property property : classifier.getAllAttributes()) {
                if (!(property.getType() instanceof Classifier)) continue;
                this.appendContainerFilterSelection((Classifier)property.getType(), contents);
            }
        }
    }

    private void computeResourceFilterSelection() {
        if (this.resourceFilter == null || this.resourceFilter == this.resource) {
            return;
        }
        ArrayList<EObject> contents = new ArrayList<EObject>();
        TreeIterator allContents = this.resource.getAllContents();
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            if (eObject.eResource() != this.resourceFilter) continue;
            if (eObject instanceof Package || eObject instanceof Classifier && !(eObject instanceof Association)) {
                contents.add(eObject);
            }
            allContents.prune();
        }
        this.viewSelection = new StructuredSelection(contents);
        this.updateViewContents();
    }

    private void updateMenuActions(ISelection selection) {
        if (((IStructuredSelection)selection).size() == 1) {
            Object element = ((IStructuredSelection)selection).getFirstElement();
            if (element instanceof IAdaptable) {
                element = ((IAdaptable)element).getAdapter(Element.class);
            }
            if (element instanceof Class) {
                this.containerFilterMenuAction.setEnabled(true);
            }
            if (element instanceof Element) {
                this.resourceFilterMenuAction.setEnabled(true);
            }
        }
        this.containerFilterMenuAction.setEnabled(false);
        this.resourceFilterMenuAction.setEnabled(false);
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IAction)this.baseTypeFilterAction);
        toolBarManager.add((IAction)this.containerFilterAction);
        toolBarManager.add((IAction)this.resourceFilterAction);
        toolBarManager.add((IAction)this.removeFiltersAction);
        toolBarManager.update(true);
    }

    public void setFocus() {
        this.treeViewerWithColumns.getControl().setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath path = saveAsDialog.getResult();
        URI ecoreModelURI = URI.createPlatformResourceURI((String)path.toOSString());
        this.resource.setURI(ecoreModelURI);
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((Resource)this.resource);
        AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "Save As..."){

            protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                EcoreUtil.resolveAll((ResourceSet)UMLTableEditor.this.resource.getResourceSet());
                for (Resource controlledResource : UMLUtil.getControlledResources((Resource)UMLTableEditor.this.resource)) {
                    EList umlResourceContents = UMLTableEditor.this.resource.getContents();
                    ListIterator contents = controlledResource.getContents().listIterator();
                    while (contents.hasNext()) {
                        EObject next = (EObject)contents.next();
                        contents.remove();
                        if (next.eContainer() != null) continue;
                        umlResourceContents.add((Object)next);
                    }
                }
                HashMap options = new HashMap();
                try {
                    UMLTableEditor.this.resource.save(options);
                }
                catch (IOException e1) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        IWorkspaceCommandStack commandStack = (IWorkspaceCommandStack)editingDomain.getCommandStack();
        operation.addContext(commandStack.getDefaultUndoContext());
        try {
            commandStack.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public boolean isDirty() {
        Saveable[] saveables = this.getSaveables();
        int i = 0;
        while (i < saveables.length) {
            if (saveables[i].isDirty()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Saveable[] getSaveables() {
        ArrayList<ModelDocument> saveables = new ArrayList<ModelDocument>();
        ModelDocument saveable = ModelManager.getManager().getModelDocument(this.resource);
        if (saveable != null) {
            saveables.add(saveable);
        }
        for (Resource controlledResource : UMLUtil.getControlledResources((Resource)this.resource)) {
            saveable = ModelManager.getManager().getModelDocument(controlledResource);
            if (saveable == null) continue;
            saveables.add(saveable);
        }
        return saveables.toArray(new Saveable[0]);
    }

    public Saveable[] getActiveSaveables() {
        return this.getSaveables();
    }

    protected void createContextMenuFor(Control control, ISelectionProvider selectionProvider, StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(control);
        control.setMenu(menu);
        this.getEditorSite().registerContextMenu(contextMenu, selectionProvider, false);
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        this.addDragSupport(control, dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        EditingDomainViewerDropAdapter dropAdapter = new EditingDomainViewerDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer){

            protected int getAutoFeedback() {
                return 8;
            }
        };
        this.addDropSupport(control, dndOperations, transfers, (DropTargetListener)dropAdapter);
    }

    protected void addDragSupport(Control control, int operations, Transfer[] transferTypes, DragSourceListener listener) {
        DragSource dragSource = new DragSource(control, operations);
        dragSource.setTransfer(transferTypes);
        dragSource.addDragListener(listener);
    }

    protected void addDropSupport(Control control, int operations, Transfer[] transferTypes, DropTargetListener listener) {
        DropTarget dropTarget = new DropTarget(control, operations);
        dropTarget.setTransfer(transferTypes);
        dropTarget.addDropListener(listener);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
        menuManager.appendToGroup("group.goto", (IAction)this.containerFilterMenuAction);
        menuManager.appendToGroup("group.goto", (IAction)this.resourceFilterMenuAction);
    }

    public Object getAdapter(java.lang.Class key) {
        if (key == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        if (IUndoContext.class == key) {
            return this.getUndoContext();
        }
        if (key.equals(IContentOutlinePage.class)) {
            return new UMLOutlinePage(this.treeViewerWithColumns);
        }
        if (key == IViewerProvider.class) {
            return new IViewerProvider(){

                public Viewer getViewer() {
                    return UMLTableEditor.this.treeViewerWithColumns;
                }
            };
        }
        return super.getAdapter(key);
    }

    public String getContributorId() {
        return "org.eclipse.mdht.uml.ui.properties";
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.getSite().getSelectionProvider().setSelection(event.getSelection());
    }

    public void selectReveal(ISelection selection) {
        if (this.treeViewerWithColumns != null) {
            if (selection instanceof IStructuredSelection) {
                Object[] newSelection = ((IStructuredSelection)selection).toArray();
                Object[] expandedElements = this.treeViewerWithColumns.getExpandedElements();
                Object[] newExpandedElements = new Object[newSelection.length + expandedElements.length];
                System.arraycopy(expandedElements, 0, newExpandedElements, 0, expandedElements.length);
                System.arraycopy(newSelection, 0, newExpandedElements, expandedElements.length, newSelection.length);
                this.treeViewerWithColumns.refresh();
                this.treeViewerWithColumns.setExpandedElements(newExpandedElements);
            }
            this.treeViewerWithColumns.setSelection(selection, true);
            TreeItem[] items = this.treeViewerWithColumns.getTree().getSelection();
            if (this.cursor != null && items.length > 0) {
                this.cursor.setSelection(items[0], 0);
            }
        }
    }

    public void gotoMarker(IMarker marker) {
        try {
            EObject eObject = null;
            Object markerURIAttr = marker.getAttribute("uri");
            if (markerURIAttr != null) {
                URI markerURI = URI.createURI((String)markerURIAttr.toString());
                eObject = this.editingDomain.getResourceSet().getEObject(markerURI, true);
            }
            if (eObject != null && eObject instanceof NamedElement) {
                StructuredSelection rootSelection = new StructuredSelection((Object)((NamedElement)eObject).getNearestPackage());
                this.getSite().getSelectionProvider().setSelection((ISelection)rootSelection);
                StructuredSelection selection = new StructuredSelection((Object)eObject);
                this.selectReveal((ISelection)selection);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private class BaseTypeFilterAction
    extends Action {
        String imageKey;
        ImageDescriptor imageDescriptor;

        protected BaseTypeFilterAction() {
            super(UML2UIMessages.BaseTypeFilter_title, 2);
            this.imageKey = "icons/full/eview16/filter_basetype.gif";
            this.imageDescriptor = UML2UIPlugin.getImageDescriptor(this.imageKey);
            this.setImageDescriptor(this.imageDescriptor);
            this.setToolTipText(UML2UIMessages.BaseTypeFilter_tooltip);
            if (UML2UIPlugin.getDefault().getImageRegistry().getDescriptor(this.imageKey) == null) {
                UML2UIPlugin.getDefault().getImageRegistry().put(this.imageKey, this.imageDescriptor);
            }
        }

        public void run() {
            Class baseType = (Class)DialogLaunchUtil.chooseElement((java.lang.Class[])new java.lang.Class[]{Class.class}, (ResourceSet)UMLTableEditor.this.resource.getResourceSet(), (Shell)UMLTableEditor.this.getSite().getShell(), (String)UML2UIMessages.BaseTypeFilter_title, (String)UML2UIMessages.BaseTypeFilter_message);
            if (baseType != null) {
                UMLTableEditor.this.baseTypeFilter = baseType;
                UMLTableEditor.this.computeBaseTypeFilterSelection();
            }
            if (UMLTableEditor.this.baseTypeFilter != null) {
                this.setChecked(true);
                UMLTableEditor.this.containerFilterAction.setChecked(false);
                UMLTableEditor.this.containerFilter = null;
                UMLTableEditor.this.resourceFilterAction.setChecked(false);
                UMLTableEditor.this.resourceFilter = null;
                Image filterImage = UML2UIPlugin.getDefault().getImageRegistry().get(this.imageKey);
                UMLTableEditor.this.viewerPane.setTitle(baseType.getQualifiedName(), filterImage);
            } else {
                this.setChecked(false);
            }
        }
    }

    private class ContainerFilterAction
    extends Action {
        String imageKey;
        ImageDescriptor imageDescriptor;

        protected ContainerFilterAction() {
            super(UML2UIMessages.ContainerFilter_title, 2);
            this.imageKey = "icons/full/eview16/filter_container.gif";
            this.imageDescriptor = UML2UIPlugin.getImageDescriptor(this.imageKey);
            this.setImageDescriptor(this.imageDescriptor);
            this.setToolTipText(UML2UIMessages.ContainerFilter_tooltip);
            if (UML2UIPlugin.getDefault().getImageRegistry().getDescriptor(this.imageKey) == null) {
                UML2UIPlugin.getDefault().getImageRegistry().put(this.imageKey, this.imageDescriptor);
            }
        }

        public void run() {
            Class containerType = (Class)DialogLaunchUtil.chooseElement((java.lang.Class[])new java.lang.Class[]{Class.class}, (Resource)UMLTableEditor.this.resource, (Shell)UMLTableEditor.this.getSite().getShell(), (String)UML2UIMessages.ContainerFilter_title, (String)UML2UIMessages.ContainerFilter_message);
            if (containerType != null) {
                UMLTableEditor.this.containerFilter = containerType;
                UMLTableEditor.this.computeContainerFilterSelection();
            }
            if (UMLTableEditor.this.containerFilter != null) {
                this.setChecked(true);
                UMLTableEditor.this.baseTypeFilterAction.setChecked(false);
                UMLTableEditor.this.baseTypeFilter = null;
                UMLTableEditor.this.resourceFilterAction.setChecked(false);
                UMLTableEditor.this.resourceFilter = null;
                Image filterImage = UML2UIPlugin.getDefault().getImageRegistry().get(this.imageKey);
                UMLTableEditor.this.viewerPane.setTitle(containerType.getQualifiedName(), filterImage);
            } else {
                this.setChecked(false);
            }
        }
    }

    private class ContainerFilterMenuAction
    extends Action {
        String imageKey;
        ImageDescriptor imageDescriptor;

        protected ContainerFilterMenuAction() {
            super(UML2UIMessages.ContainerFilter_menu, 1);
            this.imageKey = "icons/full/eview16/filter_container.gif";
            this.imageDescriptor = UML2UIPlugin.getImageDescriptor(this.imageKey);
            this.setImageDescriptor(this.imageDescriptor);
            this.setToolTipText(UML2UIMessages.ContainerFilter_tooltip);
            if (UML2UIPlugin.getDefault().getImageRegistry().getDescriptor(this.imageKey) == null) {
                UML2UIPlugin.getDefault().getImageRegistry().put(this.imageKey, this.imageDescriptor);
            }
        }

        public void selectionChanged(IAction action, ISelection selection) {
        }

        public void run() {
            ISelection selection = UMLTableEditor.this.getSite().getSelectionProvider().getSelection();
            Class containerType = null;
            if (((IStructuredSelection)selection).size() == 1) {
                Object element = ((IStructuredSelection)selection).getFirstElement();
                if (element instanceof IAdaptable) {
                    element = ((IAdaptable)element).getAdapter(Element.class);
                }
                if (element instanceof Class) {
                    containerType = (Class)element;
                }
            }
            if (containerType != null) {
                UMLTableEditor.this.containerFilter = containerType;
                UMLTableEditor.this.computeContainerFilterSelection();
            }
            if (UMLTableEditor.this.containerFilter != null) {
                UMLTableEditor.this.containerFilterAction.setChecked(true);
                UMLTableEditor.this.baseTypeFilterAction.setChecked(false);
                UMLTableEditor.this.baseTypeFilter = null;
                UMLTableEditor.this.resourceFilterAction.setChecked(false);
                UMLTableEditor.this.resourceFilter = null;
                Image filterImage = UML2UIPlugin.getDefault().getImageRegistry().get(this.imageKey);
                UMLTableEditor.this.viewerPane.setTitle(containerType.getQualifiedName(), filterImage);
            } else {
                UMLTableEditor.this.containerFilterAction.setChecked(false);
            }
        }
    }

    private class RemoveFilterAction
    extends Action {
        protected RemoveFilterAction() {
            super(UML2UIMessages.RemoveFilter_title, 1);
            this.setImageDescriptor(UML2UIPlugin.getImageDescriptor("icons/full/eview16/remove.gif"));
            this.setToolTipText(UML2UIMessages.RemoveFilter_tooltip);
        }

        public void run() {
            UMLTableEditor.this.baseTypeFilter = null;
            UMLTableEditor.this.containerFilter = null;
            UMLTableEditor.this.resourceFilter = null;
            UMLTableEditor.this.baseTypeFilterAction.setChecked(false);
            UMLTableEditor.this.containerFilterAction.setChecked(false);
            UMLTableEditor.this.resourceFilterAction.setChecked(false);
            UMLTableEditor.this.viewerPane.setTitle(null);
            UMLTableEditor.this.setDefaultSelection();
        }
    }

    private class ResourceFilterAction
    extends Action {
        String imageKey;
        ImageDescriptor imageDescriptor;

        protected ResourceFilterAction() {
            super(UML2UIMessages.ResourceFilter_title, 2);
            this.imageKey = "icons/full/eview16/filter_resource.gif";
            this.imageDescriptor = UML2UIPlugin.getImageDescriptor(this.imageKey);
            this.setImageDescriptor(this.imageDescriptor);
            this.setToolTipText(UML2UIMessages.ResourceFilter_tooltip);
            if (this.imageDescriptor != null && UML2UIPlugin.getDefault().getImageRegistry().getDescriptor(this.imageKey) == null) {
                UML2UIPlugin.getDefault().getImageRegistry().put(this.imageKey, this.imageDescriptor);
            }
        }

        public void run() {
            ElementListSelectionDialog dialog = new ElementListSelectionDialog(UMLTableEditor.this.getSite().getShell(), (ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    return ((Resource)element).getURI().lastSegment();
                }
            });
            dialog.setMessage(UML2UIMessages.ResourceFilter_message);
            dialog.setFilter("*");
            dialog.setTitle(UML2UIMessages.ResourceFilter_title);
            dialog.setElements(UMLUtil.getControlledResources((Resource)UMLTableEditor.this.resource).toArray());
            if (dialog.open() == 0) {
                UMLTableEditor.this.resourceFilter = (Resource)dialog.getFirstResult();
                UMLTableEditor.this.computeResourceFilterSelection();
            }
            if (UMLTableEditor.this.resourceFilter != null) {
                this.setChecked(true);
                UMLTableEditor.this.baseTypeFilterAction.setChecked(false);
                UMLTableEditor.this.baseTypeFilter = null;
                UMLTableEditor.this.containerFilterAction.setChecked(false);
                UMLTableEditor.this.containerFilter = null;
                Image filterImage = UML2UIPlugin.getDefault().getImageRegistry().get(this.imageKey);
                UMLTableEditor.this.viewerPane.setTitle(UMLTableEditor.this.resourceFilter.getURI().lastSegment(), filterImage);
            } else {
                this.setChecked(false);
            }
        }
    }

    private class ResourceFilterMenuAction
    extends Action {
        String imageKey;
        ImageDescriptor imageDescriptor;

        protected ResourceFilterMenuAction() {
            super(UML2UIMessages.ResourceFilter_menu, 1);
            this.imageKey = "icons/full/eview16/filter_resource.gif";
            this.imageDescriptor = UML2UIPlugin.getImageDescriptor(this.imageKey);
            this.setImageDescriptor(this.imageDescriptor);
            this.setToolTipText(UML2UIMessages.ResourceFilter_tooltip);
            if (UML2UIPlugin.getDefault().getImageRegistry().getDescriptor(this.imageKey) == null) {
                UML2UIPlugin.getDefault().getImageRegistry().put(this.imageKey, this.imageDescriptor);
            }
        }

        public void selectionChanged(IAction action, ISelection selection) {
        }

        public void run() {
            ISelection selection = UMLTableEditor.this.getSite().getSelectionProvider().getSelection();
            if (((IStructuredSelection)selection).size() == 1) {
                Object element = ((IStructuredSelection)selection).getFirstElement();
                if (element instanceof IAdaptable) {
                    element = ((IAdaptable)element).getAdapter(Element.class);
                }
                if (element instanceof Element) {
                    UMLTableEditor.this.resourceFilter = ((Element)element).eResource();
                }
            }
            if (UMLTableEditor.this.resourceFilter != null) {
                UMLTableEditor.this.computeResourceFilterSelection();
            }
            if (UMLTableEditor.this.resourceFilter != null) {
                UMLTableEditor.this.resourceFilterAction.setChecked(true);
                UMLTableEditor.this.baseTypeFilterAction.setChecked(false);
                UMLTableEditor.this.baseTypeFilter = null;
                UMLTableEditor.this.containerFilterAction.setChecked(false);
                UMLTableEditor.this.containerFilter = null;
                Image filterImage = UML2UIPlugin.getDefault().getImageRegistry().get(this.imageKey);
                UMLTableEditor.this.viewerPane.setTitle(UMLTableEditor.this.resourceFilter.getURI().lastSegment(), filterImage);
            } else {
                UMLTableEditor.this.containerFilterAction.setChecked(false);
            }
        }
    }

    private class SelectionProvider
    implements ISelectionProvider {
        private ListenerList fListeners = new ListenerList();
        private Control fControl;

        public SelectionProvider(Control control) {
            Assert.isNotNull((Object)control);
            this.fControl = control;
            if (this.fControl instanceof Tree) {
                ((Tree)this.fControl).addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        SelectionProvider.this.fireSelectionChanged();
                    }
                });
            }
        }

        public void fireSelectionChanged() {
            ISelection selection = this.getSelection();
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
            Object[] selectionChangedListeners = this.fListeners.getListeners();
            int i = 0;
            while (i < selectionChangedListeners.length) {
                ((ISelectionChangedListener)selectionChangedListeners[i]).selectionChanged(event);
                ++i;
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.add((Object)listener);
        }

        public ISelection getSelection() {
            if (this.fControl.isDisposed()) {
                UMLTableEditor.this.setDefaultSelection();
            }
            if (this.fControl instanceof Tree) {
                TreeItem[] selection = ((Tree)this.fControl).getSelection();
                Object[] values = new Object[selection.length];
                int i = 0;
                while (i < values.length) {
                    values[i] = selection[i].getData() instanceof EObject ? new UMLDomainNavigatorItem((EObject)selection[i].getData(), null, UMLTableEditor.this.adapterFactoryContentProvider) : selection[i].getData();
                    ++i;
                }
                return new StructuredSelection(values);
            }
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.remove((Object)listener);
        }

        public void setSelection(ISelection selection) {
            SimpleListNotifier rootList = new SimpleListNotifier();
            rootList.getMembers().addAll(((IStructuredSelection)selection).toList());
            UMLTableEditor.this.treeViewerWithColumns.setInput((Object)rootList);
            this.fireSelectionChanged();
        }
    }
}

