/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.common.ui.dialogs;

import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.mdht.uml.common.ui.dialogs.ElementLabelProvider;
import org.eclipse.mdht.uml.common.ui.dialogs.StringMatcher;
import org.eclipse.mdht.uml.common.ui.internal.l10n.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredList;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;
import org.eclipse.uml2.uml.NamedElement;

public class ElementSelectionDialog
extends TwoPaneElementSelector {
    private List typeList;

    public ElementSelectionDialog(Shell parent, IRunnableContext context, List typeList) {
        super(parent, (ILabelProvider)new ElementLabelProvider(16), (ILabelProvider)new ElementLabelProvider(96));
        Assert.isNotNull((Object)context);
        this.typeList = typeList;
        this.setUpperListLabel(Messages.ElementSelectionDialog_upperLabel);
        this.setLowerListLabel(Messages.ElementSelectionDialog_lowerLabel);
    }

    protected FilteredList createFilteredList(Composite parent) {
        FilteredList list = super.createFilteredList(parent);
        this.fFilteredList.setFilterMatcher((FilteredList.FilterMatcher)new TypeFilterMatcher());
        this.fFilteredList.setComparator((Comparator)new StringComparator());
        return list;
    }

    public int open() {
        if (this.typeList.isEmpty()) {
            String title = Messages.ElementSelectionDialog_notypes_title;
            String message = Messages.ElementSelectionDialog_notypes_message;
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return 1;
        }
        Object[] typeArray = this.typeList.toArray(new Object[this.typeList.size()]);
        this.setElements(typeArray);
        return super.open();
    }

    private static class StringComparator
    implements Comparator {
        private StringComparator() {
        }

        public int compare(Object left, Object right) {
            String leftString = (String)left;
            String rightString = (String)right;
            if (left == null || right == null || leftString.length() == 0 || rightString.length() == 0) {
                return 0;
            }
            if (Character.isLowerCase(leftString.charAt(0)) && !Character.isLowerCase(rightString.charAt(0))) {
                return 1;
            }
            if (Character.isLowerCase(rightString.charAt(0)) && !Character.isLowerCase(leftString.charAt(0))) {
                return -1;
            }
            int result = leftString.compareToIgnoreCase(rightString);
            if (result == 0) {
                result = leftString.compareTo(rightString);
            }
            return result;
        }
    }

    private static class TypeFilterMatcher
    implements FilteredList.FilterMatcher {
        private StringMatcher fMatcher;
        private StringMatcher fQualifierMatcher;

        private TypeFilterMatcher() {
        }

        public void setFilter(String pattern, boolean ignoreCase, boolean igoreWildCards) {
            int qualifierIndex = pattern.lastIndexOf("::");
            if (qualifierIndex == -1) {
                this.fQualifierMatcher = null;
                this.fMatcher = new StringMatcher(String.valueOf(pattern) + '*', ignoreCase, igoreWildCards);
            } else {
                this.fQualifierMatcher = new StringMatcher(pattern.substring(0, qualifierIndex), ignoreCase, igoreWildCards);
                this.fMatcher = new StringMatcher(pattern.substring(qualifierIndex + 1), ignoreCase, igoreWildCards);
            }
        }

        public boolean match(Object element) {
            if (!(element instanceof NamedElement)) {
                return false;
            }
            NamedElement type = (NamedElement)element;
            if (type.getName() != null && !this.fMatcher.match(type.getName())) {
                return false;
            }
            if (this.fQualifierMatcher == null) {
                return true;
            }
            return this.fQualifierMatcher.match(type.getNearestPackage().getQualifiedName());
        }
    }
}

