/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.UIServices;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.Window;
import org.eclipse.oomph.jreinfo.JREManager;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.ProfileTransaction;
import org.eclipse.oomph.setup.internal.core.SetupContext;
import org.eclipse.oomph.setup.internal.core.util.SetupCoreUtil;
import org.eclipse.oomph.setup.internal.installer.CocoaUtil;
import org.eclipse.oomph.setup.internal.installer.Installer;
import org.eclipse.oomph.setup.internal.installer.InstallerDialog;
import org.eclipse.oomph.setup.internal.installer.InstallerUI;
import org.eclipse.oomph.setup.internal.installer.KeepInstallerDialog;
import org.eclipse.oomph.setup.internal.installer.KeepInstallerUtil;
import org.eclipse.oomph.setup.internal.installer.NetworkConnectionsDialog;
import org.eclipse.oomph.setup.internal.installer.SelfUpdate;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.internal.installer.SimpleInstallerDialog;
import org.eclipse.oomph.setup.ui.wizards.SetupWizard;
import org.eclipse.oomph.ui.ErrorDialog;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallerApplication
implements IApplication {
    public static final Integer EXIT_ERROR = 1;
    private static final OomphPlugin.Preference PREF_MODE = SetupInstallerPlugin.INSTANCE.getConfigurationPreference("mode");
    private static final boolean SKIP_COCOA_MENU = PropertiesUtil.isProperty((String)"oomph.cocoa.menu.skip");
    private Mode mode = Mode.SIMPLE;

    protected Integer run(final IApplicationContext context) throws Exception {
        int retcode;
        SetupWizard.SelectionMemento selectionMemento;
        File restarting;
        boolean restarted;
        InstallerUI[] installerDialog;
        block30: {
            Bundle brandingBundle;
            Location configurationLocation;
            IProvisioningAgent agent = P2Util.getCurrentProvisioningAgent();
            agent.registerService(UIServices.SERVICE_NAME, (Object)Installer.SERVICE_UI);
            Location location = Platform.getInstanceLocation();
            if (location != null && !location.isSet() && (configurationLocation = Platform.getConfigurationLocation()) != null) {
                URL configurationLocationURL = configurationLocation.getURL();
                location.set(configurationLocationURL, false);
            }
            installerDialog = new InstallerUI[1];
            Thread jreInitializer = new Thread("JRE Initializer"){

                public void run() {
                    InstallerUI installerUI;
                    JREManager.INSTANCE.getJREs();
                    while (true) {
                        if ((installerUI = installerDialog[0]) != null) break;
                        try {
                            1.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            return;
                        }
                    }
                    installerUI.refreshJREs();
                }
            };
            jreInitializer.setDaemon(true);
            jreInitializer.start();
            String windowImages = context.getBrandingProperty("windowImages");
            if (windowImages != null && (brandingBundle = context.getBrandingBundle()) != null) {
                ArrayList<Image> images = new ArrayList<Image>();
                for (String windowImageValue : StringUtil.explode((String)windowImages, (String)",")) {
                    URI windowImageURI = URI.createURI((String)windowImageValue);
                    if (windowImageURI.isRelative()) {
                        URL url = brandingBundle.getEntry(windowImageValue);
                        if (url == null) continue;
                        windowImageURI = URI.createURI((String)url.toString());
                    }
                    images.add(ExtendedImageRegistry.INSTANCE.getImage((Object)windowImageURI));
                }
                if (!images.isEmpty()) {
                    Window.setDefaultImages((Image[])images.toArray(new Image[images.size()]));
                }
            }
            restarted = false;
            restarting = new File(SetupContext.CONFIGURATION_STATE_LOCATION_URI.appendSegment("restarting").toFileString());
            selectionMemento = null;
            if (restarting.exists()) {
                try {
                    try {
                        restarted = true;
                        selectionMemento = (SetupWizard.SelectionMemento)IOUtil.readObject((File)restarting, (ClassLoader)this.getClass().getClassLoader());
                    }
                    catch (Throwable throwable) {
                        try {
                            restarting.delete();
                        }
                        catch (Throwable throwable2) {}
                        break block30;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        restarting.delete();
                    }
                    catch (Throwable throwable3) {}
                    throw throwable;
                }
                try {
                    restarting.delete();
                }
                catch (Throwable throwable) {}
            }
        }
        Display display = Display.getDefault();
        Display.setAppName((String)PropertiesUtil.getProductName());
        this.handleCocoaMenu(display, installerDialog);
        display.asyncExec(new Runnable(){

            public void run() {
                context.applicationRunning();
            }
        });
        String modeName = PropertiesUtil.getProperty((String)"oomph.setup.installer.mode");
        if (modeName == null) {
            modeName = PREF_MODE.get(Mode.SIMPLE.name());
        }
        this.mode = Mode.valueOf(modeName.toUpperCase());
        Map arguments = context.getArguments();
        String[] applicationArgs = arguments == null ? null : (String[])arguments.get("application.args");
        Collection<Object> configurationResources = this.getConfigurationResources(applicationArgs);
        while (true) {
            if (selectionMemento == null) {
                selectionMemento = new SetupWizard.SelectionMemento();
            }
            Installer installer = new Installer(selectionMemento);
            if (this.mode == Mode.ADVANCED) {
                Shell shell;
                if (KeepInstallerUtil.canKeepInstaller() && MessageDialog.openQuestion((Shell)(shell = new Shell(display)), (String)PropertiesUtil.getProductName(), (String)"As an advanced user, do you want to keep the installer in a permanent location?") && new KeepInstallerDialog(shell, true).open() == 0) {
                    return EXIT_OK;
                }
                installer.setConfigurationResources(configurationResources);
                installerDialog[0] = new InstallerDialog(null, installer, restarted);
            } else {
                installer.setConfigurationResources(configurationResources);
                SimpleInstallerDialog dialog = new SimpleInstallerDialog(display, installer, restarted);
                installer.setSimpleShell(dialog);
                installerDialog[0] = dialog;
            }
            retcode = installerDialog[0].show();
            if (retcode == 2) {
                this.setMode(Mode.SIMPLE);
                selectionMemento = null;
                configurationResources = installer.getAppliedConfigurationResources();
                continue;
            }
            if (retcode != 3) break;
            this.setMode(Mode.ADVANCED);
            selectionMemento = null;
            configurationResources = installer.getAppliedConfigurationResources();
        }
        if (retcode == -4) {
            try {
                IOUtil.writeObject((File)restarting, (Object)selectionMemento);
            }
            catch (Throwable throwable) {}
            String launcher = OS.getCurrentLauncher((boolean)false);
            if (launcher != null) {
                try {
                    InstallerApplication.launch(launcher);
                    return EXIT_OK;
                }
                catch (Throwable throwable) {}
            }
            return EXIT_RESTART;
        }
        return EXIT_OK;
    }

    private void setMode(Mode mode) {
        this.mode = mode;
        PREF_MODE.set(mode.name());
    }

    private Set<Resource> getConfigurationResources(String[] applicationArgs) {
        HashSet<Resource> resources = new HashSet<Resource>();
        ResourceSet resourceSet = null;
        String[] stringArray = applicationArgs;
        int n = applicationArgs.length;
        int n2 = 0;
        while (n2 < n) {
            block4: {
                URI uri;
                String arg = stringArray[n2];
                try {
                    uri = this.getConfigurationResourceURI(arg);
                }
                catch (Throwable ex) {
                    SetupInstallerPlugin.INSTANCE.log(ex);
                    break block4;
                }
                if (resourceSet == null) {
                    resourceSet = SetupCoreUtil.createResourceSet();
                }
                Resource resource = resourceSet.createResource(uri);
                resources.add(resource);
            }
            ++n2;
        }
        return resources;
    }

    private URI getConfigurationResourceURI(String arg) {
        try {
            File file = new File(arg);
            if (file.isFile() && file.canRead()) {
                return URI.createFileURI((String)IOUtil.getCanonicalFile((File)file).toString());
            }
        }
        catch (Throwable throwable) {}
        URI uri = URI.createURI((String)arg);
        String scheme = uri.scheme();
        if (scheme == null || OS.INSTANCE.isWin() && scheme.length() == 1) {
            uri = URI.createFileURI((String)IOUtil.getCanonicalFile((File)new File(arg)).toString());
        }
        return uri;
    }

    private void handleCocoaMenu(final Display display, final InstallerUI[] installerDialog) {
        if (!SKIP_COCOA_MENU && "cocoa".equals(Platform.getWS())) {
            Runnable about = new Runnable(){

                public void run() {
                    if (installerDialog[0] != null) {
                        installerDialog[0].showAbout();
                    }
                }
            };
            Runnable preferences = new Runnable(){

                public void run() {
                    if (installerDialog[0] != null) {
                        NetworkConnectionsDialog proxyPreferenceDialog = new NetworkConnectionsDialog(installerDialog[0].getShell());
                        proxyPreferenceDialog.open();
                    }
                }
            };
            Runnable quit = new Runnable(){

                public void run() {
                    if (installerDialog[0] != null) {
                        display.dispose();
                    }
                }
            };
            CocoaUtil.register(display, about, preferences, quit);
        }
    }

    public Object start(IApplicationContext context) throws Exception {
        try {
            return this.run(context);
        }
        catch (Throwable t) {
            SetupInstallerPlugin.INSTANCE.log(t);
            final AtomicInteger exitCode = new AtomicInteger(EXIT_ERROR);
            ErrorDialog dialog = new ErrorDialog("Error", t, 0, 2, new String[]{IDialogConstants.OK_LABEL, "Update", IDialogConstants.SHOW_DETAILS_LABEL}){

                protected void buttonPressed(int buttonId) {
                    super.buttonPressed(buttonId);
                    if (buttonId == 1) {
                        this.update();
                    }
                }

                private void update() {
                    try {
                        final Shell shell = this.getShell();
                        if (!MessageDialog.openQuestion((Shell)shell, (String)"Emergency Update", (String)"This is an emergency update. Continue?\n\nTo lower the risk of problems during this update it will be implied that you accept new licenses or unsigned content.")) {
                            return;
                        }
                        ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell){

                            protected Point getInitialSize() {
                                Point calculatedSize = super.getInitialSize();
                                if (calculatedSize.x < 800) {
                                    calculatedSize.x = 800;
                                }
                                return calculatedSize;
                            }
                        };
                        try {
                            dialog.run(true, true, new IRunnableWithProgress(){

                                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
                                    try {
                                        ProfileTransaction.Resolution resolution = SelfUpdate.resolve(null, (IProgressMonitor)progress.newChild(1));
                                        if (resolution == null) {
                                            UIUtil.syncExec((Runnable)new Runnable(){

                                                public void run() {
                                                    MessageDialog.openInformation((Shell)shell, (String)"Update", (String)"No updates were found.");
                                                }
                                            });
                                            return;
                                        }
                                        try {
                                            resolution.commit((IProgressMonitor)progress.newChild(1));
                                            exitCode.set(EXIT_RESTART);
                                        }
                                        catch (Throwable ex) {
                                            throw new InvocationTargetException(ex);
                                        }
                                    }
                                    finally {
                                        progress.done();
                                    }
                                }
                            });
                        }
                        catch (OperationCanceledException operationCanceledException) {
                        }
                        catch (InvocationTargetException ex) {
                            if (!(ex.getCause() instanceof OperationCanceledException)) {
                                throw ex;
                            }
                        }
                    }
                    catch (Throwable ex) {
                        SetupInstallerPlugin.INSTANCE.log(ex);
                        ErrorDialog.open((Throwable)ex);
                    }
                }
            };
            dialog.open();
            return exitCode.get();
        }
    }

    public void stop() {
    }

    static void launch(String launcher) throws IOException {
        String[] args = Platform.getCommandLineArgs();
        String[] cmdarray = new String[1 + args.length];
        cmdarray[0] = launcher;
        System.arraycopy(args, 0, cmdarray, 1, args.length);
        Runtime.getRuntime().exec(cmdarray);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        SIMPLE,
        ADVANCED;

    }
}

