/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.views.modelexplorer.handler;

import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.papyrus.infra.core.sashwindows.di.service.IPageManager;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.DiagramUtils;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.views.modelexplorer.handler.AbstractModelExplorerHandler;

public class OpenHandler
extends AbstractModelExplorerHandler
implements IExecutableExtension {
    public static final String IS_DUPLICATE_EDITOR_ALLOWED_PARAMETER = "isDuplicateEditorAllowed";
    protected boolean isDuplicateDiagramAllowed = false;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IPageManager pageManager = this.getPageManager();
        if (pageManager == null) {
            return null;
        }
        List<EObject> selectedProperties = this.getCurrentSelectionAdaptedToType(event, EObject.class);
        if (selectedProperties == null) {
            return null;
        }
        LinkedList<EObject> pagesToOpen = new LinkedList<EObject>();
        LinkedList<EObject> pagesToSelect = new LinkedList<EObject>();
        for (EObject selected : selectedProperties) {
            if (!this.canOpenByPolicy(selected)) continue;
            if (!pageManager.isOpen((Object)selected) || this.isDuplicateDiagramAllowed) {
                pagesToOpen.add(selected);
                continue;
            }
            pagesToSelect.add(selected);
        }
        if (!pagesToOpen.isEmpty()) {
            for (EObject page : pagesToOpen) {
                pageManager.openPage((Object)page);
            }
        }
        for (EObject page : pagesToSelect) {
            pageManager.selectPage((Object)page);
        }
        return null;
    }

    private boolean canOpenByPolicy(EObject selection) {
        if (selection instanceof Diagram) {
            Diagram diagram = (Diagram)selection;
            ViewPrototype proto = DiagramUtils.getPrototype((Diagram)diagram);
            return proto != ViewPrototype.UNAVAILABLE_VIEW && proto != ViewPrototype.UNAVAILABLE_DIAGRAM;
        }
        return true;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (!(data instanceof Hashtable)) {
            return;
        }
        Hashtable map = (Hashtable)data;
        try {
            this.isDuplicateDiagramAllowed = Boolean.parseBoolean((String)map.get(IS_DUPLICATE_EDITOR_ALLOWED_PARAMETER));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

